using System;
using System.Resources;
using System.Reflection;

namespace gov.va.med.vbecs.Common
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Department of Veterans Affairs</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>3/16/2011</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///    Automatically generated class providing code mapping for string resource names
	///
	///    The content in this file was generated by UpdateStringResourcesAccessClasses macro.
	///    Please do not modify the file manually since it should only contain 
	///    throw-away code which can be re-created by the macro.
	///
	///    Last time generated by YURDOMAIN\vhaishdobrak at 10:21:39 AM, Wednesday, March 16, 2011
	///
	///    WARNING: Regenerate this file every time resource files change!
	///</summary>

	#endregion

	public sealed class StrRes
	{
		/// <summary>
		/// String Retrieval Failure Message constant
		/// </summary>
		public const string StringRetrievalFailureMessage = "There was an error while retrieving string from application resources";

		/// <summary>
		/// StringResourceItem struct - used to collect the message itself and message type
		/// </summary>
		public struct StringResourceItem 
		{
			/// <summary>
			/// String Resource Message constant
			/// </summary>
			public string ResString;
			/// <summary>
			/// String Resource type
			/// </summary>
			public StringResourceType ResType;

			/// <summary>
			/// String Resource public method that returns the struct
			/// </summary>
			public StringResourceItem( string resourceString, StringResourceType resourceType )
			{
				if( resourceString != null && resourceType != StringResourceType.ResourceRetrievalFailure )
				{
					this.ResString = resourceString;
					this.ResType = resourceType;
				}
				else
				{
					this.ResString = StringRetrievalFailureMessage;
					this.ResType = StringResourceType.ResourceRetrievalFailure;
				}
			}
		}

		private StrRes(){}

		private static ResourceManager CreateResourceManagerInstance( string resourceFileNameRoot )
		{
			return new ResourceManager( string.Format( "gov.va.med.vbecs.AppResources.{0}", resourceFileNameRoot ), Assembly.Load("VBECS.AppResources") );
		}

		private static StringResourceItem GetStringResourceItem( StringResourceType resourceType, string rawString, params object[] args )
		{
			try
			{
				return new StringResourceItem( String.Format( rawString, args ), resourceType );
			}
			catch
			{
				return new StringResourceItem( StringRetrievalFailureMessage, StringResourceType.Other );
			}
		}


		/// <summary>
		/// ConfMsg class
		/// </summary>
		public sealed class ConfMsg
		{
			private const StringResourceType _classResType = StringResourceType.Confirmation;
			private static readonly ResourceManager _resourceManager = CreateResourceManagerInstance("ConfirmationMessages");

			private ConfMsg(){}
			static ConfMsg(){}	// get rid of "beforefieldinit" attribute (DON'T REMOVE!)


			/// <summary>
			/// Common class
			/// </summary>
			public sealed class Common
			{
				/// <summary>
				/// ActivateBloodProduct class
				/// </summary>
				public static StringResourceItem ActivateBloodProduct()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ActivateBloodProduct") );
				}

				/// <summary>
				/// AntiseraWillExpire class
				/// </summary>
				public static StringResourceItem AntiseraWillExpire(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.AntiseraWillExpire"), arg0 );
				}

				/// <summary>
				/// ConfirmInvalidQCResults class
				/// </summary>
				public static StringResourceItem ConfirmInvalidQCResults()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ConfirmInvalidQCResults") );
				}

				/// <summary>
				/// Dynamic class
				/// </summary>
				public static StringResourceItem Dynamic(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.Dynamic"), arg0 );
				}

				/// <summary>
				/// ExitVbecs class
				/// </summary>
				public static StringResourceItem ExitVbecs()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ExitVbecs") );
				}

                /// <summary>
                /// ReportExportSuccess class
                /// </summary>
                public static StringResourceItem ReportExportSuccess(object arg0)
                {
                    return GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ReportExportSuccess"), arg0);
                }

				/// <summary>
				/// ExpirationDateExtensionWarning class
				/// </summary>
				public static StringResourceItem ExpirationDateExtensionWarning(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ExpirationDateExtensionWarning"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// ExpirationDateOutOfRangeOverride class
				/// </summary>
				public static StringResourceItem ExpirationDateOutOfRangeOverride()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ExpirationDateOutOfRangeOverride") );
				}

				/// <summary>
				/// InvalidateTestResults class
				/// </summary>
				public static StringResourceItem InvalidateTestResults()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InvalidateTestResults") );
				}

				/// <summary>
				/// MakeAvailableExpiredorUnacceptableSpecimen class
				/// </summary>
				public static StringResourceItem MakeAvailableExpiredorUnacceptableSpecimen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.MakeAvailableExpiredorUnacceptableSpecimen") );
				}

				/// <summary>
				/// OKToSave class
				/// </summary>
				public static StringResourceItem OKToSave(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.OKToSave"), arg0 );
				}

				/// <summary>
				/// PrintModifiedLabel class
				/// </summary>
				public static StringResourceItem PrintModifiedLabel(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PrintModifiedLabel"), arg0 );
				}

				/// <summary>
				/// ReadyToVerifyLabeling class
				/// </summary>
				public static StringResourceItem ReadyToVerifyLabeling(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ReadyToVerifyLabeling"), arg0 );
				}

				/// <summary>
				/// ScheduledReportGreaterThanThirtyDays class
				/// </summary>
				public static StringResourceItem ScheduledReportGreaterThanThirtyDays()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ScheduledReportGreaterThanThirtyDays") );
				}

				/// <summary>
				/// SelectDeceasedPatient class
				/// </summary>
				public static StringResourceItem SelectDeceasedPatient(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SelectDeceasedPatient"), arg0 );
				}

				/// <summary>
				/// UnhandledExceptionDialog class
				/// </summary>
				public static StringResourceItem UnhandledExceptionDialog()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UnhandledExceptionDialog") );
				}

				/// <summary>
				/// UnsatisfactoryReagent class
				/// </summary>
				public static StringResourceItem UnsatisfactoryReagent(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UnsatisfactoryReagent"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// UnsavedData class
				/// </summary>
				public static StringResourceItem UnsavedData()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UnsavedData") );
				}

				/// <summary>
				/// UseUnQCdRack class
				/// </summary>
				public static StringResourceItem UseUnQCdRack(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UseUnQCdRack"), arg0 );
				}
			}
			/// <summary>
			/// MUC02 class
			/// </summary>
			public sealed class MUC02
			{
				/// <summary>
				/// DivisionDataNotSaved class
				/// </summary>
				public static StringResourceItem DivisionDataNotSaved(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.DivisionDataNotSaved"), arg0 );
				}

				/// <summary>
				/// InactivateDivision class
				/// </summary>
				public static StringResourceItem InactivateDivision(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.InactivateDivision"), arg0 );
				}
			}
			/// <summary>
			/// MUC03 class
			/// </summary>
			public sealed class MUC03
			{
				/// <summary>
				/// ChangeUserActivation class
				/// </summary>
				public static StringResourceItem ChangeUserActivation(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC03.ChangeUserActivation"), arg0, arg1 );
				}

				/// <summary>
				/// OkToSaveUserChanges class
				/// </summary>
				public static StringResourceItem OkToSaveUserChanges()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC03.OkToSaveUserChanges") );
				}

				/// <summary>
				/// UserDataNotSaved class
				/// </summary>
				public static StringResourceItem UserDataNotSaved()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC03.UserDataNotSaved") );
				}
			}
			/// <summary>
			/// MUC04 class
			/// </summary>
			public sealed class MUC04
			{
				/// <summary>
				/// DisableInterface class
				/// </summary>
				public static StringResourceItem DisableInterface(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC04.DisableInterface"), arg0 );
				}

				/// <summary>
				/// EnableInterface class
				/// </summary>
				public static StringResourceItem EnableInterface(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC04.EnableInterface"), arg0 );
				}

				/// <summary>
				/// InterfaceDataNotSaved class
				/// </summary>
				public static StringResourceItem InterfaceDataNotSaved(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC04.InterfaceDataNotSaved"), arg0 );
				}
			}
			/// <summary>
			/// UC001 class
			/// </summary>
			public sealed class UC001
			{
				/// <summary>
				/// AddUnit class
				/// </summary>
				public static StringResourceItem AddUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.AddUnit") );
				}

				/// <summary>
				/// AddUnitsToExistingInvoice class
				/// </summary>
				public static StringResourceItem AddUnitsToExistingInvoice()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.AddUnitsToExistingInvoice") );
				}

				/// <summary>
				/// BR1_61 class
				/// </summary>
				public static StringResourceItem BR1_61()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.BR1.61") );
				}

				/// <summary>
				/// BR140Full class
				/// </summary>
				public static StringResourceItem BR140Full()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.BR140Full") );
				}

				/// <summary>
				/// BR140Trans class
				/// </summary>
				public static StringResourceItem BR140Trans()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.BR140Trans") );
				}

				/// <summary>
				/// CreateNewInvoice class
				/// </summary>
				public static StringResourceItem CreateNewInvoice()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.CreateNewInvoice") );
				}

				/// <summary>
				/// MustbeUnitinIncomingShipmentTable class
				/// </summary>
				public static StringResourceItem MustbeUnitinIncomingShipmentTable()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.MustbeUnitinIncomingShipmentTable") );
				}
			}
			/// <summary>
			/// UC002 class
			/// </summary>
			public sealed class UC002
			{
				/// <summary>
				/// IncompleteTestsNotSaved class
				/// </summary>
				public static StringResourceItem IncompleteTestsNotSaved()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC002.IncompleteTestsNotSaved") );
				}
			}
			/// <summary>
			/// UC003 class
			/// </summary>
			public sealed class UC003
			{
				/// <summary>
				/// BR316ABORhConfirmation class
				/// </summary>
				public static StringResourceItem BR316ABORhConfirmation()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR316ABORhConfirmation") );
				}

				/// <summary>
				/// EXM class
				/// </summary>
				public static StringResourceItem EXM(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.EXM"), arg0 );
				}

				/// <summary>
				/// PrintTags class
				/// </summary>
				public static StringResourceItem PrintTags(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.PrintTags"), arg0 );
				}

				/// <summary>
				/// XM class
				/// </summary>
				public static StringResourceItem XM()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.XM") );
				}
			}
			/// <summary>
			/// UC006 class
			/// </summary>
			public sealed class UC006
			{
				/// <summary>
				/// AddorMaintainAnotherCollectionFacility class
				/// </summary>
				public static StringResourceItem AddorMaintainAnotherCollectionFacility()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.AddorMaintainAnotherCollectionFacility") );
				}

				/// <summary>
				/// InactivateFacility class
				/// </summary>
				public static StringResourceItem InactivateFacility()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.InactivateFacility") );
				}
			}
			/// <summary>
			/// UC008 class
			/// </summary>
			public sealed class UC008
			{
				/// <summary>
				/// ContinueWithDeactivatedProduct class
				/// </summary>
				public static StringResourceItem ContinueWithDeactivatedProduct()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.ContinueWithDeactivatedProduct") );
				}
			}
			/// <summary>
			/// UC011 class
			/// </summary>
			public sealed class UC011
			{
				/// <summary>
				/// CrossmatchedUnit class
				/// </summary>
				public static StringResourceItem CrossmatchedUnit(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.CrossmatchedUnit"), arg0 );
				}

				/// <summary>
				/// ExpiredUnit class
				/// </summary>
				public static StringResourceItem ExpiredUnit(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.ExpiredUnit"), arg0, arg1 );
				}

				/// <summary>
				/// QuarantinedUnit class
				/// </summary>
				public static StringResourceItem QuarantinedUnit(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.QuarantinedUnit"), arg0 );
				}

				/// <summary>
				/// RemoveAllUnits class
				/// </summary>
				public static StringResourceItem RemoveAllUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.RemoveAllUnits") );
				}

				/// <summary>
				/// RemoveUnit class
				/// </summary>
				public static StringResourceItem RemoveUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.RemoveUnit") );
				}

				/// <summary>
				/// Save class
				/// </summary>
				public static StringResourceItem Save()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.Save") );
				}
			}
			/// <summary>
			/// UC014 class
			/// </summary>
			public sealed class UC014
			{
				/// <summary>
				/// UpdateSpecialTestCost class
				/// </summary>
				public static StringResourceItem UpdateSpecialTestCost()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC014.UpdateSpecialTestCost") );
				}
			}
			/// <summary>
			/// UC016 class
			/// </summary>
			public sealed class UC016
			{
				/// <summary>
				/// FailedTests class
				/// </summary>
				public static StringResourceItem FailedTests(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.FailedTests"), arg0, arg1 );
				}
			}
			/// <summary>
			/// UC018 class
			/// </summary>
			public sealed class UC018
			{
				/// <summary>
				/// ConfirmClosingAllWindowsBeforeDivisionChange class
				/// </summary>
				public static StringResourceItem ConfirmClosingAllWindowsBeforeDivisionChange()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.ConfirmClosingAllWindowsBeforeDivisionChange") );
				}
			}
			/// <summary>
			/// UC019 class
			/// </summary>
			public sealed class UC019
			{
				/// <summary>
				/// OKToUpdateUserRoles class
				/// </summary>
				public static StringResourceItem OKToUpdateUserRoles(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC019.OKToUpdateUserRoles"), arg0 );
				}
			}
			/// <summary>
			/// UC020 class
			/// </summary>
			public sealed class UC020
			{
				/// <summary>
				/// NothingToSave class
				/// </summary>
				public static StringResourceItem NothingToSave()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC020.NothingToSave") );
				}
			}
			/// <summary>
			/// UC022 class
			/// </summary>
			public sealed class UC022
			{
				/// <summary>
				/// EquipmentChangesNotSaved class
				/// </summary>
				public static StringResourceItem EquipmentChangesNotSaved()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.EquipmentChangesNotSaved") );
				}

				/// <summary>
				/// MaintainExistingEquipment class
				/// </summary>
				public static StringResourceItem MaintainExistingEquipment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.MaintainExistingEquipment") );
				}
			}
			/// <summary>
			/// UC024 class
			/// </summary>
			public sealed class UC024
			{
				/// <summary>
				/// PrintNewLabel class
				/// </summary>
				public static StringResourceItem PrintNewLabel()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.PrintNewLabel") );
				}
			}
			/// <summary>
			/// UC026 class
			/// </summary>
			public sealed class UC026
			{
				/// <summary>
				/// OverrideExpiredSupply class
				/// </summary>
				public static StringResourceItem OverrideExpiredSupply(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.OverrideExpiredSupply"), arg0, arg1, arg2 );
				}
			}
			/// <summary>
			/// UC027 class
			/// </summary>
			public sealed class UC027
			{
				/// <summary>
				/// InvalidDateCanOverride class
				/// </summary>
				public static StringResourceItem InvalidDateCanOverride(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC027.InvalidDateCanOverride"), arg0, arg1 );
				}
			}
			/// <summary>
			/// UC028 class
			/// </summary>
			public sealed class UC028
			{
				/// <summary>
				/// CancelTestResults class
				/// </summary>
				public static StringResourceItem CancelTestResults()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC028.CancelTestResults") );
				}

				/// <summary>
				/// ClearTestResults class
				/// </summary>
				public static StringResourceItem ClearTestResults()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC028.ClearTestResults") );
				}

				/// <summary>
				/// DecreaseInReagentReactivity class
				/// </summary>
				public static StringResourceItem DecreaseInReagentReactivity()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC028.DecreaseInReagentReactivity") );
				}

				/// <summary>
				/// OverrideTestResult class
				/// </summary>
				public static StringResourceItem OverrideTestResult()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC028.OverrideTestResult") );
				}

				/// <summary>
				/// SavePartialTestResults class
				/// </summary>
				public static StringResourceItem SavePartialTestResults(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC028.SavePartialTestResults"), arg0 );
				}

				/// <summary>
				/// SaveTestResults class
				/// </summary>
				public static StringResourceItem SaveTestResults(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC028.SaveTestResults"), arg0 );
				}
			}
			/// <summary>
			/// UC035 class
			/// </summary>
			public sealed class UC035
			{
				/// <summary>
				/// AntibodyFormation class
				/// </summary>
				public static StringResourceItem AntibodyFormation()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC035.AntibodyFormation") );
				}

				/// <summary>
				/// ExpiredSpecimen class
				/// </summary>
				public static StringResourceItem ExpiredSpecimen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC035.ExpiredSpecimen") );
				}

				/// <summary>
				/// Transfusion class
				/// </summary>
				public static StringResourceItem Transfusion()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC035.Transfusion") );
				}
			}
			/// <summary>
			/// UC040 class
			/// </summary>
			public sealed class UC040
			{
				/// <summary>
				/// PrintBTRFandCautionTag class
				/// </summary>
				public static StringResourceItem PrintBTRFandCautionTag()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC040.PrintBTRFandCautionTag") );
				}
			}
			/// <summary>
			/// UC041 class
			/// </summary>
			public sealed class UC041
			{
				/// <summary>
				/// DeleteAntiseraWorklist class
				/// </summary>
				public static StringResourceItem DeleteAntiseraWorklist()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.DeleteAntiseraWorklist") );
				}

				/// <summary>
				/// IncorrectPhase class
				/// </summary>
				public static StringResourceItem IncorrectPhase()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.IncorrectPhase") );
				}
			}
			/// <summary>
			/// UC049 class
			/// </summary>
			public sealed class UC049
			{
				/// <summary>
				/// PageCountAlert class
				/// </summary>
				public static StringResourceItem PageCountAlert()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC049.PageCountAlert") );
				}
			}
			/// <summary>
			/// UC051 class
			/// </summary>
			public sealed class UC051
			{
				/// <summary>
				/// OverwriteQCTemplate class
				/// </summary>
				public static StringResourceItem OverwriteQCTemplate()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC051.OverwriteQCTemplate") );
				}
			}
			/// <summary>
			/// UC052 class
			/// </summary>
			public sealed class UC052
			{
				/// <summary>
				/// ABORhMismatch class
				/// </summary>
				public static StringResourceItem ABORhMismatch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC052.ABORhMismatch") );
				}
			}
			/// <summary>
			/// UC056 class
			/// </summary>
			public sealed class UC056
			{
				/// <summary>
				/// CancelTest class
				/// </summary>
				public static StringResourceItem CancelTest()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.CancelTest") );
				}

				/// <summary>
				/// ClearTestResults class
				/// </summary>
				public static StringResourceItem ClearTestResults()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.ClearTestResults") );
				}

				/// <summary>
				/// ExpiredTaskProcessed class
				/// </summary>
				public static StringResourceItem ExpiredTaskProcessed()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.ExpiredTaskProcessed") );
				}

				/// <summary>
				/// SaveAboRh class
				/// </summary>
				public static StringResourceItem SaveAboRh()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.SaveAboRh") );
				}

				/// <summary>
				/// UnitPosForAntibodyAntigenReq class
				/// </summary>
				public static StringResourceItem UnitPosForAntibodyAntigenReq(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.UnitPosForAntibodyAntigenReq"), arg0, arg1 );
				}
			}
			/// <summary>
			/// UC070 class
			/// </summary>
			public sealed class UC070
			{
				/// <summary>
				/// InactivateAboRhConfirmation class
				/// </summary>
				public static StringResourceItem InactivateAboRhConfirmation()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC070.InactivateAboRhConfirmation") );
				}

				/// <summary>
				/// InactivateAntigenTyping class
				/// </summary>
				public static StringResourceItem InactivateAntigenTyping()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC070.InactivateAntigenTyping") );
				}

				/// <summary>
				/// InactivateUnit class
				/// </summary>
				public static StringResourceItem InactivateUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC070.InactivateUnit") );
				}
			}
			/// <summary>
			/// UC071 class
			/// </summary>
			public sealed class UC071
			{
				/// <summary>
				/// RemoveRestriction class
				/// </summary>
				public static StringResourceItem RemoveRestriction()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC071.RemoveRestriction") );
				}
			}
			/// <summary>
			/// UC072 class
			/// </summary>
			public sealed class UC072
			{
				/// <summary>
				/// CancelActiveCompoentOrder class
				/// </summary>
				public static StringResourceItem CancelActiveCompoentOrder()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC072.CancelActiveCompoentOrder") );
				}
			}
			/// <summary>
			/// UC073 class
			/// </summary>
			public sealed class UC073
			{
				/// <summary>
				/// AboIncompatibleUnitIssued class
				/// </summary>
				public static StringResourceItem AboIncompatibleUnitIssued()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.AboIncompatibleUnitIssued") );
				}

				/// <summary>
				/// AboIncompatibleUnitIssuedSystemInterp class
				/// </summary>
				public static StringResourceItem AboIncompatibleUnitIssuedSystemInterp()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.AboIncompatibleUnitIssuedSystemInterp") );
				}

				/// <summary>
				/// AntibodyProblem class
				/// </summary>
				public static StringResourceItem AntibodyProblem(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.AntibodyProblem"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// AntigenProblem class
				/// </summary>
				public static StringResourceItem AntigenProblem(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.AntigenProblem"), arg0, arg1 );
				}

				/// <summary>
				/// Biohazardous class
				/// </summary>
				public static StringResourceItem Biohazardous()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.Biohazardous") );
				}

				/// <summary>
				/// EmergencyIssue class
				/// </summary>
				public static StringResourceItem EmergencyIssue()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.EmergencyIssue") );
				}

				/// <summary>
				/// NoError class
				/// </summary>
				public static StringResourceItem NoError()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.NoError") );
				}

				/// <summary>
				/// RestrictiveUnits class
				/// </summary>
				public static StringResourceItem RestrictiveUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.RestrictiveUnits") );
				}

				/// <summary>
				/// RhNegative class
				/// </summary>
				public static StringResourceItem RhNegative()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.RhNegative") );
				}

				/// <summary>
				/// RhNegativeFemale class
				/// </summary>
				public static StringResourceItem RhNegativeFemale()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.RhNegativeFemale") );
				}

				/// <summary>
				/// SpecimenExpired class
				/// </summary>
				public static StringResourceItem SpecimenExpired()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.SpecimenExpired") );
				}

				/// <summary>
				/// TRNotSatisfied class
				/// </summary>
				public static StringResourceItem TRNotSatisfied(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.TRNotSatisfied"), arg0 );
				}

				/// <summary>
				/// UnitExpired class
				/// </summary>
				public static StringResourceItem UnitExpired()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.UnitExpired") );
				}

				/// <summary>
				/// UnitsSatisfactory class
				/// </summary>
				public static StringResourceItem UnitsSatisfactory()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.UnitsSatisfactory") );
				}

				/// <summary>
				/// UnitUnsatisfactory class
				/// </summary>
				public static StringResourceItem UnitUnsatisfactory()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.UnitUnsatisfactory") );
				}
			}
			/// <summary>
			/// UC081 class
			/// </summary>
			public sealed class UC081
			{
				/// <summary>
				/// EditExistingSupply class
				/// </summary>
				public static StringResourceItem EditExistingSupply()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC081.EditExistingSupply") );
				}
			}
			/// <summary>
			/// UC098 class
			/// </summary>
			public sealed class UC098
			{
				/// <summary>
				/// HistoricalMismatch class
				/// </summary>
				public static StringResourceItem HistoricalMismatch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC098.HistoricalMismatch") );
				}
			}
			/// <summary>
			/// UC102 class
			/// </summary>
			public sealed class UC102
			{
				/// <summary>
				/// VistASignOnCancellation class
				/// </summary>
				public static StringResourceItem VistASignOnCancellation()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.VistASignOnCancellation") );
				}
			}
			/// <summary>
			/// UnitTest class
			/// </summary>
			public sealed class UnitTest
			{
				/// <summary>
				/// TestString class
				/// </summary>
				public static StringResourceItem TestString(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UnitTest.TestString"), arg0, arg1 );
				}
			}
		}

		/// <summary>
		/// InfoMsg class
		/// </summary>
		public sealed class InfoMsg
		{
			private const StringResourceType _classResType = StringResourceType.Information;
			private static readonly ResourceManager _resourceManager = CreateResourceManagerInstance("InformationMessages");

			private InfoMsg(){}
			static InfoMsg(){}	// get rid of "beforefieldinit" attribute (DON'T REMOVE!)


			/// <summary>
			/// Common class
			/// </summary>
			public sealed class Common
			{
				/// <summary>
				/// CannotAddBloodProduct class
				/// </summary>
				public static StringResourceItem CannotAddBloodProduct()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.CannotAddBloodProduct") );
				}

				/// <summary>
				/// DiscardUnits class
				/// </summary>
				public static StringResourceItem DiscardUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DiscardUnits") );
				}

				/// <summary>
				/// DSSConnectionLost class
				/// </summary>
				public static StringResourceItem DSSConnectionLost()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DSSConnectionLost") );
				}

				/// <summary>
				/// Dynamic class
				/// </summary>
				public static StringResourceItem Dynamic(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.Dynamic"), arg0 );
				}

				/// <summary>
				/// ExceptionDetailsWereCopiedToClipboard class
				/// </summary>
				public static StringResourceItem ExceptionDetailsWereCopiedToClipboard()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ExceptionDetailsWereCopiedToClipboard") );
				}

				/// <summary>
				/// ExpirationDateOutOfRange class
				/// </summary>
				public static StringResourceItem ExpirationDateOutOfRange(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ExpirationDateOutOfRange"), arg0, arg1 );
				}

				/// <summary>
				/// FunctionUnavailable class
				/// </summary>
				public static StringResourceItem FunctionUnavailable(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.FunctionUnavailable"), arg0 );
				}

				/// <summary>
				/// IncorrectBarcode class
				/// </summary>
				public static StringResourceItem IncorrectBarcode()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.IncorrectBarcode") );
				}

				/// <summary>
				/// InsufficientSecurityPrivileges class
				/// </summary>
				public static StringResourceItem InsufficientSecurityPrivileges(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InsufficientSecurityPrivileges"), arg0 );
				}

				/// <summary>
				/// LockTimeout class
				/// </summary>
				public static StringResourceItem LockTimeout()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.LockTimeout") );
				}

				/// <summary>
				/// NoABORhResults class
				/// </summary>
				public static StringResourceItem NoABORhResults()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.NoABORhResults") );
				}

				/// <summary>
				/// NoValidUnits class
				/// </summary>
				public static StringResourceItem NoValidUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.NoValidUnits") );
				}

				/// <summary>
				/// PatientDeceased class
				/// </summary>
				public static StringResourceItem PatientDeceased()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PatientDeceased") );
				}

				/// <summary>
				/// PatienteXMDisabledABORhDiscrepancy class
				/// </summary>
				public static StringResourceItem PatienteXMDisabledABORhDiscrepancy()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PatienteXMDisabledABORhDiscrepancy") );
				}

				/// <summary>
				/// PatienteXMDisabledAntibodyHistory class
				/// </summary>
				public static StringResourceItem PatienteXMDisabledAntibodyHistory()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PatienteXMDisabledAntibodyHistory") );
				}

				/// <summary>
				/// PatienteXMDisabledAntigenNegative class
				/// </summary>
				public static StringResourceItem PatienteXMDisabledAntigenNegative()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PatienteXMDisabledAntigenNegative") );
				}

				/// <summary>
				/// PatienteXMDisabledNeedTwoTypings class
				/// </summary>
				public static StringResourceItem PatienteXMDisabledNeedTwoTypings()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PatienteXMDisabledNeedTwoTypings") );
				}

				/// <summary>
				/// PatienteXMDisabledNoSpecimen class
				/// </summary>
				public static StringResourceItem PatienteXMDisabledNoSpecimen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PatienteXMDisabledNoSpecimen") );
				}

				/// <summary>
				/// PatienteXMDisabledNoSpecimenTesting class
				/// </summary>
				public static StringResourceItem PatienteXMDisabledNoSpecimenTesting()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PatienteXMDisabledNoSpecimenTesting") );
				}

				/// <summary>
				/// PatienteXMDisabledPositiveAntibody class
				/// </summary>
				public static StringResourceItem PatienteXMDisabledPositiveAntibody()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PatienteXMDisabledPositiveAntibody") );
				}

				/// <summary>
				/// PatienteXMDisabledTypingDifficulty class
				/// </summary>
				public static StringResourceItem PatienteXMDisabledTypingDifficulty()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PatienteXMDisabledTypingDifficulty") );
				}

				/// <summary>
				/// PatienteXMEnabled class
				/// </summary>
				public static StringResourceItem PatienteXMEnabled()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PatienteXMEnabled") );
				}

				/// <summary>
				/// QuarantineUnits class
				/// </summary>
				public static StringResourceItem QuarantineUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.QuarantineUnits") );
				}

				/// <summary>
				/// RemovefromQuarantineUnits class
				/// </summary>
				public static StringResourceItem RemovefromQuarantineUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.RemovefromQuarantineUnits") );
				}

				/// <summary>
				/// UnitEXMDisabled class
				/// </summary>
				public static StringResourceItem UnitEXMDisabled()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UnitEXMDisabled") );
				}

				/// <summary>
				/// UnitEXMDisabledABOConfirmNoMatch class
				/// </summary>
				public static StringResourceItem UnitEXMDisabledABOConfirmNoMatch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UnitEXMDisabledABOConfirmNoMatch") );
				}

				/// <summary>
				/// UnitEXMDisabledABOIncompatible class
				/// </summary>
				public static StringResourceItem UnitEXMDisabledABOIncompatible()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UnitEXMDisabledABOIncompatible") );
				}

				/// <summary>
				/// UnitEXMDisabledNoABORhConfirm class
				/// </summary>
				public static StringResourceItem UnitEXMDisabledNoABORhConfirm()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UnitEXMDisabledNoABORhConfirm") );
				}

				/// <summary>
				/// UnitEXMDisabledRhConfirmNoMatch class
				/// </summary>
				public static StringResourceItem UnitEXMDisabledRhConfirmNoMatch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UnitEXMDisabledRhConfirmNoMatch") );
				}

				/// <summary>
				/// UnitEXMEnabled class
				/// </summary>
				public static StringResourceItem UnitEXMEnabled()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UnitEXMEnabled") );
				}

				/// <summary>
				/// ValidUnits class
				/// </summary>
				public static StringResourceItem ValidUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ValidUnits") );
				}

				/// <summary>
				/// VistALinkIsNotSearchedForPatient class
				/// </summary>
				public static StringResourceItem VistALinkIsNotSearchedForPatient()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.VistALinkIsNotSearchedForPatient") );
				}
			}
			/// <summary>
			/// MUC01 class
			/// </summary>
			public sealed class MUC01
			{
				/// <summary>
				/// NoConfigFileFound class
				/// </summary>
				public static StringResourceItem NoConfigFileFound(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.NoConfigFileFound"), arg0, arg1 );
				}
			}
			/// <summary>
			/// MUC03 class
			/// </summary>
			public sealed class MUC03
			{
				/// <summary>
				/// CannotActivateDivision class
				/// </summary>
				public static StringResourceItem CannotActivateDivision()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC03.CannotActivateDivision") );
				}

				/// <summary>
				/// CannotInactivateDivision class
				/// </summary>
				public static StringResourceItem CannotInactivateDivision()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC03.CannotInactivateDivision") );
				}
			}
			/// <summary>
			/// UC003 class
			/// </summary>
			public sealed class UC003
			{
				/// <summary>
				/// CautionTagPrinterNotAvailable class
				/// </summary>
				public static StringResourceItem CautionTagPrinterNotAvailable()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.CautionTagPrinterNotAvailable") );
				}

				/// <summary>
				/// EmergencyIssueMessage class
				/// </summary>
				public static StringResourceItem EmergencyIssueMessage()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.EmergencyIssueMessage") );
				}

				/// <summary>
				/// IncorrectDivision class
				/// </summary>
				public static StringResourceItem IncorrectDivision(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.IncorrectDivision"), arg0 );
				}

				/// <summary>
				/// NoDeselect class
				/// </summary>
				public static StringResourceItem NoDeselect()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.NoDeselect") );
				}

				/// <summary>
				/// NoMatchingUnits class
				/// </summary>
				public static StringResourceItem NoMatchingUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.NoMatchingUnits") );
				}

				/// <summary>
				/// ReportPrinterNotAvailable class
				/// </summary>
				public static StringResourceItem ReportPrinterNotAvailable()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.ReportPrinterNotAvailable") );
				}
			}
			/// <summary>
			/// UC008 class
			/// </summary>
			public sealed class UC008
			{
				/// <summary>
				/// AProductSupplierMustBeActivated class
				/// </summary>
				public static StringResourceItem AProductSupplierMustBeActivated()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.AProductSupplierMustBeActivated") );
				}

				/// <summary>
				/// ProductSupplierNotFound class
				/// </summary>
				public static StringResourceItem ProductSupplierNotFound()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.ProductSupplierNotFound") );
				}
			}
			/// <summary>
			/// UC011 class
			/// </summary>
			public sealed class UC011
			{
				/// <summary>
				/// DivisionCheck class
				/// </summary>
				public static StringResourceItem DivisionCheck()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.DivisionCheck") );
				}

				/// <summary>
				/// DuplicateItem class
				/// </summary>
				public static StringResourceItem DuplicateItem(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.DuplicateItem"), arg0 );
				}

				/// <summary>
				/// InvoiceConfirmed class
				/// </summary>
				public static StringResourceItem InvoiceConfirmed()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.InvoiceConfirmed") );
				}

				/// <summary>
				/// NoItems class
				/// </summary>
				public static StringResourceItem NoItems()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.NoItems") );
				}

				/// <summary>
				/// RemoveUnitBeforeAdding class
				/// </summary>
				public static StringResourceItem RemoveUnitBeforeAdding(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.RemoveUnitBeforeAdding"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// UnitInUse class
				/// </summary>
				public static StringResourceItem UnitInUse(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.UnitInUse"), arg0 );
				}

				/// <summary>
				/// UnitInUseCannotBeModified class
				/// </summary>
				public static StringResourceItem UnitInUseCannotBeModified(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.UnitInUseCannotBeModified"), arg0 );
				}

				/// <summary>
				/// UnitInvalidForShipment class
				/// </summary>
				public static StringResourceItem UnitInvalidForShipment(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.UnitInvalidForShipment"), arg0 );
				}

				/// <summary>
				/// UnitNotValidForShipmentFacility class
				/// </summary>
				public static StringResourceItem UnitNotValidForShipmentFacility(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.UnitNotValidForShipmentFacility"), arg0, arg1 );
				}
			}
			/// <summary>
			/// UC013 class
			/// </summary>
			public sealed class UC013
			{
				/// <summary>
				/// WarningMessage class
				/// </summary>
				public static StringResourceItem WarningMessage()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC013.WarningMessage") );
				}
			}
			/// <summary>
			/// UC015 class
			/// </summary>
			public sealed class UC015
			{
				/// <summary>
				/// BR1502_NoWorkloadDefined class
				/// </summary>
				public static StringResourceItem BR1502_NoWorkloadDefined()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC015.BR1502.NoWorkloadDefined") );
				}
			}
			/// <summary>
			/// UC016 class
			/// </summary>
			public sealed class UC016
			{
				/// <summary>
				/// NoOrders class
				/// </summary>
				public static StringResourceItem NoOrders()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.NoOrders") );
				}

				/// <summary>
				/// OrderStatusChanged class
				/// </summary>
				public static StringResourceItem OrderStatusChanged(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.OrderStatusChanged"), arg0 );
				}

				/// <summary>
				/// OutdatedOrder class
				/// </summary>
				public static StringResourceItem OutdatedOrder()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.OutdatedOrder") );
				}

				/// <summary>
				/// SpecimenAlreadyExists class
				/// </summary>
				public static StringResourceItem SpecimenAlreadyExists()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.SpecimenAlreadyExists") );
				}

				/// <summary>
				/// SpecimenNeedsCorrection class
				/// </summary>
				public static StringResourceItem SpecimenNeedsCorrection()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.SpecimenNeedsCorrection") );
				}

				/// <summary>
				/// SpecimenNonMaintainable class
				/// </summary>
				public static StringResourceItem SpecimenNonMaintainable()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.SpecimenNonMaintainable") );
				}

				/// <summary>
				/// SpecimenNotInVbecs class
				/// </summary>
				public static StringResourceItem SpecimenNotInVbecs()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.SpecimenNotInVbecs") );
				}

				/// <summary>
				/// SpecimenUidInvalid class
				/// </summary>
				public static StringResourceItem SpecimenUidInvalid()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.SpecimenUidInvalid") );
				}

				/// <summary>
				/// WrongSpecimen class
				/// </summary>
				public static StringResourceItem WrongSpecimen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.WrongSpecimen") );
				}
			}
			/// <summary>
			/// UC018 class
			/// </summary>
			public sealed class UC018
			{
				/// <summary>
				/// ReportPrinterNotAvailable class
				/// </summary>
				public static StringResourceItem ReportPrinterNotAvailable()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.ReportPrinterNotAvailable") );
				}
			}
			/// <summary>
			/// UC020 class
			/// </summary>
			public sealed class UC020
			{
				/// <summary>
				/// NoMatchingEntries class
				/// </summary>
				public static StringResourceItem NoMatchingEntries()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC020.NoMatchingEntries") );
				}

				/// <summary>
				/// ReagentTypeStockLevelLow class
				/// </summary>
				public static StringResourceItem ReagentTypeStockLevelLow(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC020.ReagentTypeStockLevelLow"), arg0 );
				}
			}
			/// <summary>
			/// UC021 class
			/// </summary>
			public sealed class UC021
			{
				/// <summary>
				/// ContactPhysician class
				/// </summary>
				public static StringResourceItem ContactPhysician()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.ContactPhysician") );
				}

				/// <summary>
				/// PreAndPostSpecimen class
				/// </summary>
				public static StringResourceItem PreAndPostSpecimen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.PreAndPostSpecimen") );
				}

				/// <summary>
				/// SpecimenPatientMismatch class
				/// </summary>
				public static StringResourceItem SpecimenPatientMismatch(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.SpecimenPatientMismatch"), arg0 );
				}

				/// <summary>
				/// UnitNotTransfused class
				/// </summary>
				public static StringResourceItem UnitNotTransfused(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.UnitNotTransfused"), arg0, arg1 );
				}

				/// <summary>
				/// UnitPatientMismatch class
				/// </summary>
				public static StringResourceItem UnitPatientMismatch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.UnitPatientMismatch") );
				}
			}
			/// <summary>
			/// UC022 class
			/// </summary>
			public sealed class UC022
			{
				/// <summary>
				/// NoManufacturerAddresses class
				/// </summary>
				public static StringResourceItem NoManufacturerAddresses(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.NoManufacturerAddresses"), arg0 );
				}
			}
			/// <summary>
			/// UC024 class
			/// </summary>
			public sealed class UC024
			{
				/// <summary>
				/// EditPoolCommentRequired class
				/// </summary>
				public static StringResourceItem EditPoolCommentRequired()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.EditPoolCommentRequired") );
				}
			}
			/// <summary>
			/// UC025 class
			/// </summary>
			public sealed class UC025
			{
				/// <summary>
				/// RanOutOfAlphabet class
				/// </summary>
				public static StringResourceItem RanOutOfAlphabet()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC025.RanOutOfAlphabet") );
				}

				/// <summary>
				/// SplitNotAllowed class
				/// </summary>
				public static StringResourceItem SplitNotAllowed()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC025.SplitNotAllowed") );
				}
			}
			/// <summary>
			/// UC026 class
			/// </summary>
			public sealed class UC026
			{
				/// <summary>
				/// LabelVerificationComplete class
				/// </summary>
				public static StringResourceItem LabelVerificationComplete()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.LabelVerificationComplete") );
				}

				/// <summary>
				/// ProductNotActive class
				/// </summary>
				public static StringResourceItem ProductNotActive(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.ProductNotActive"), arg0 );
				}

				/// <summary>
				/// SelectAnotherUnit class
				/// </summary>
				public static StringResourceItem SelectAnotherUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.SelectAnotherUnit") );
				}

				/// <summary>
				/// SelectDifferentSupply class
				/// </summary>
				public static StringResourceItem SelectDifferentSupply()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.SelectDifferentSupply") );
				}

				/// <summary>
				/// VolumeToLow class
				/// </summary>
				public static StringResourceItem VolumeToLow()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.VolumeToLow") );
				}
			}
			/// <summary>
			/// UC027 class
			/// </summary>
			public sealed class UC027
			{
				/// <summary>
				/// InvalidDateNoOverride class
				/// </summary>
				public static StringResourceItem InvalidDateNoOverride(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC027.InvalidDateNoOverride"), arg0, arg1 );
				}

				/// <summary>
				/// UnitInFinalStatusCannotBeSelected class
				/// </summary>
				public static StringResourceItem UnitInFinalStatusCannotBeSelected(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC027.UnitInFinalStatusCannotBeSelected"), arg0 );
				}
			}
			/// <summary>
			/// UC029 class
			/// </summary>
			public sealed class UC029
			{
				/// <summary>
				/// InvalidInactivationDate class
				/// </summary>
				public static StringResourceItem InvalidInactivationDate()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC029.InvalidInactivationDate") );
				}
			}
			/// <summary>
			/// UC035 class
			/// </summary>
			public sealed class UC035
			{
				/// <summary>
				/// NonFutureSpecimenCollectionDate class
				/// </summary>
				public static StringResourceItem NonFutureSpecimenCollectionDate()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC035.NonFutureSpecimenCollectionDate") );
				}

				/// <summary>
				/// NonFutureSpecimenReceivedDate class
				/// </summary>
				public static StringResourceItem NonFutureSpecimenReceivedDate()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC035.NonFutureSpecimenReceivedDate") );
				}

				/// <summary>
				/// SpecimenCollectionAfterReceived class
				/// </summary>
				public static StringResourceItem SpecimenCollectionAfterReceived()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC035.SpecimenCollectionAfterReceived") );
				}

				/// <summary>
				/// SpecimenExpirationAfterCollection class
				/// </summary>
				public static StringResourceItem SpecimenExpirationAfterCollection()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC035.SpecimenExpirationAfterCollection") );
				}

				/// <summary>
				/// SpecimenExpirationAfterReceived class
				/// </summary>
				public static StringResourceItem SpecimenExpirationAfterReceived()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC035.SpecimenExpirationAfterReceived") );
				}

				/// <summary>
				/// SpecimenExpirationDateOutOfRange class
				/// </summary>
				public static StringResourceItem SpecimenExpirationDateOutOfRange(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC035.SpecimenExpirationDateOutOfRange"), arg0 );
				}

				/// <summary>
				/// SpecimenExpirationExtend class
				/// </summary>
				public static StringResourceItem SpecimenExpirationExtend()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC035.SpecimenExpirationExtend") );
				}

				/// <summary>
				/// UnacceptableSpecimenNotAllowed class
				/// </summary>
				public static StringResourceItem UnacceptableSpecimenNotAllowed()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC035.UnacceptableSpecimenNotAllowed") );
				}

				/// <summary>
				/// UnexpiredOrUnacceptableSpecimen class
				/// </summary>
				public static StringResourceItem UnexpiredOrUnacceptableSpecimen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC035.UnexpiredOrUnacceptableSpecimen") );
				}
			}
			/// <summary>
			/// UC041 class
			/// </summary>
			public sealed class UC041
			{
				/// <summary>
				/// AntigenTypingQuarantine class
				/// </summary>
				public static StringResourceItem AntigenTypingQuarantine()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.AntigenTypingQuarantine") );
				}

				/// <summary>
				/// WeakDQuarantine class
				/// </summary>
				public static StringResourceItem WeakDQuarantine()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.WeakDQuarantine") );
				}
			}
			/// <summary>
			/// UC043 class
			/// </summary>
			public sealed class UC043
			{
				/// <summary>
				/// AntibodyProblemCautionTag class
				/// </summary>
				public static StringResourceItem AntibodyProblemCautionTag(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.AntibodyProblemCautionTag"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// AntibodyProblemNoOverride class
				/// </summary>
				public static StringResourceItem AntibodyProblemNoOverride(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.AntibodyProblemNoOverride"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// AntigenProblemCautionTag class
				/// </summary>
				public static StringResourceItem AntigenProblemCautionTag(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.AntigenProblemCautionTag"), arg0, arg1 );
				}

				/// <summary>
				/// AntigenProblemNoOverride class
				/// </summary>
				public static StringResourceItem AntigenProblemNoOverride(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.AntigenProblemNoOverride"), arg0, arg1 );
				}

				/// <summary>
				/// BTRFGeneralPrintingProblem class
				/// </summary>
				public static StringResourceItem BTRFGeneralPrintingProblem()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.BTRFGeneralPrintingProblem") );
				}

				/// <summary>
				/// BTRFNoDefaultPrinter class
				/// </summary>
				public static StringResourceItem BTRFNoDefaultPrinter()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.BTRFNoDefaultPrinter") );
				}

				/// <summary>
				/// BTRFPrintingInterrupted class
				/// </summary>
				public static StringResourceItem BTRFPrintingInterrupted(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.BTRFPrintingInterrupted"), arg0 );
				}

				/// <summary>
				/// CTPrintingInterrupted class
				/// </summary>
				public static StringResourceItem CTPrintingInterrupted(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.CTPrintingInterrupted"), arg0 );
				}

				/// <summary>
				/// EmergencyIssue class
				/// </summary>
				public static StringResourceItem EmergencyIssue()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.EmergencyIssue") );
				}

				/// <summary>
				/// EmergencyIssueInvalid class
				/// </summary>
				public static StringResourceItem EmergencyIssueInvalid()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.EmergencyIssueInvalid") );
				}

				/// <summary>
				/// IncompatibleCrossmatchResults class
				/// </summary>
				public static StringResourceItem IncompatibleCrossmatchResults()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.IncompatibleCrossmatchResults") );
				}

				/// <summary>
				/// InconclusiveCrossmatch class
				/// </summary>
				public static StringResourceItem InconclusiveCrossmatch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.InconclusiveCrossmatch") );
				}

				/// <summary>
				/// Informational class
				/// </summary>
				public static StringResourceItem Informational(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.Informational"), arg0 );
				}

				/// <summary>
				/// InvalidUnit class
				/// </summary>
				public static StringResourceItem InvalidUnit(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.InvalidUnit"), arg0 );
				}

				/// <summary>
				/// NoAssignments class
				/// </summary>
				public static StringResourceItem NoAssignments()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.NoAssignments") );
				}

				/// <summary>
				/// NoPatient class
				/// </summary>
				public static StringResourceItem NoPatient()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.NoPatient") );
				}

				/// <summary>
				/// NotAntigenNegative class
				/// </summary>
				public static StringResourceItem NotAntigenNegative(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.NotAntigenNegative"), arg0 );
				}

				/// <summary>
				/// NoUnit class
				/// </summary>
				public static StringResourceItem NoUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.NoUnit") );
				}

				/// <summary>
				/// NoValidUnits class
				/// </summary>
				public static StringResourceItem NoValidUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.NoValidUnits") );
				}

				/// <summary>
				/// PrintFailure class
				/// </summary>
				public static StringResourceItem PrintFailure()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.PrintFailure") );
				}

				/// <summary>
				/// PrintSuccess class
				/// </summary>
				public static StringResourceItem PrintSuccess()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.PrintSuccess") );
				}

				/// <summary>
				/// SpecimenExpired class
				/// </summary>
				public static StringResourceItem SpecimenExpired()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.SpecimenExpired") );
				}

				/// <summary>
				/// SpecimenExpiredNoOverride class
				/// </summary>
				public static StringResourceItem SpecimenExpiredNoOverride()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.SpecimenExpiredNoOverride") );
				}

				/// <summary>
				/// TagsAlreadyPrinted class
				/// </summary>
				public static StringResourceItem TagsAlreadyPrinted()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.TagsAlreadyPrinted") );
				}

				/// <summary>
				/// TRNotSatisfied class
				/// </summary>
				public static StringResourceItem TRNotSatisfied(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.TRNotSatisfied"), arg0 );
				}

				/// <summary>
				/// TRNotSatisfiedNoOverride class
				/// </summary>
				public static StringResourceItem TRNotSatisfiedNoOverride(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.TRNotSatisfiedNoOverride"), arg0 );
				}

				/// <summary>
				/// UnitABORhDiscrepancy class
				/// </summary>
				public static StringResourceItem UnitABORhDiscrepancy()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.UnitABORhDiscrepancy") );
				}

				/// <summary>
				/// UnitExpired class
				/// </summary>
				public static StringResourceItem UnitExpired()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.UnitExpired") );
				}

				/// <summary>
				/// UnitExpiredNoOverride class
				/// </summary>
				public static StringResourceItem UnitExpiredNoOverride()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.UnitExpiredNoOverride") );
				}

				/// <summary>
				/// UnitFrozen class
				/// </summary>
				public static StringResourceItem UnitFrozen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.UnitFrozen") );
				}

				/// <summary>
				/// UnitQuarantined class
				/// </summary>
				public static StringResourceItem UnitQuarantined()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.UnitQuarantined") );
				}

				/// <summary>
				/// Warnings class
				/// </summary>
				public static StringResourceItem Warnings(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.Warnings"), arg0 );
				}
			}
			/// <summary>
			/// UC044 class
			/// </summary>
			public sealed class UC044
			{
				/// <summary>
				/// CompatibilityTestingNotFinished class
				/// </summary>
				public static StringResourceItem CompatibilityTestingNotFinished()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC044.CompatibilityTestingNotFinished") );
				}
			}
			/// <summary>
			/// UC045 class
			/// </summary>
			public sealed class UC045
			{
				/// <summary>
				/// NoCompleteTestsExist class
				/// </summary>
				public static StringResourceItem NoCompleteTestsExist()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC045.NoCompleteTestsExist") );
				}
			}
			/// <summary>
			/// UC047 class
			/// </summary>
			public sealed class UC047
			{
				/// <summary>
				/// BloodUnitNotFound class
				/// </summary>
				public static StringResourceItem BloodUnitNotFound()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC047.BloodUnitNotFound") );
				}

				/// <summary>
				/// MultipleUnitsExpired class
				/// </summary>
				public static StringResourceItem MultipleUnitsExpired()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC047.MultipleUnitsExpired") );
				}

				/// <summary>
				/// SingleUnitExpired class
				/// </summary>
				public static StringResourceItem SingleUnitExpired()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC047.SingleUnitExpired") );
				}
			}
			/// <summary>
			/// UC048 class
			/// </summary>
			public sealed class UC048
			{
				/// <summary>
				/// NoSpecimensForPatient class
				/// </summary>
				public static StringResourceItem NoSpecimensForPatient()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC048.NoSpecimensForPatient") );
				}
			}
			/// <summary>
			/// UC049 class
			/// </summary>
			public sealed class UC049
			{
				/// <summary>
				/// NoInfoReturned class
				/// </summary>
				public static StringResourceItem NoInfoReturned()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC049.NoInfoReturned") );
				}

				/// <summary>
				/// Warning class
				/// </summary>
				public static StringResourceItem Warning()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC049.Warning") );
				}
			}
			/// <summary>
			/// UC050 class
			/// </summary>
			public sealed class UC050
			{
				/// <summary>
				/// CannotConfigureComponent class
				/// </summary>
				public static StringResourceItem CannotConfigureComponent(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC050.CannotConfigureComponent"), arg0 );
				}

				/// <summary>
				/// CannotConfigureRbcComponents class
				/// </summary>
				public static StringResourceItem CannotConfigureRbcComponents(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC050.CannotConfigureRbcComponents"), arg0 );
				}
			}
			/// <summary>
			/// UC051 class
			/// </summary>
			public sealed class UC051
			{
				/// <summary>
				/// BR5121 class
				/// </summary>
				public static StringResourceItem BR5121()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC051.BR5121") );
				}

				/// <summary>
				/// BR5122 class
				/// </summary>
				public static StringResourceItem BR5122()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC051.BR5122") );
				}
			}
			/// <summary>
			/// UC055 class
			/// </summary>
			public sealed class UC055
			{
				/// <summary>
				/// CannotConfigureServiceType class
				/// </summary>
				public static StringResourceItem CannotConfigureServiceType(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC055.CannotConfigureServiceType"), arg0 );
				}

				/// <summary>
				/// CannotConfigureTesting class
				/// </summary>
				public static StringResourceItem CannotConfigureTesting(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC055.CannotConfigureTesting"), arg0 );
				}
			}

            /// <summary>
            /// UC056 class
            /// </summary>
            public sealed class UC056
            {
                /// <summary>
                /// RefreshABORh class
                /// </summary>
                public static StringResourceItem RefreshABORh()
                {
                    return GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.RefreshABORh"));
                }
            }

			/// <summary>
			/// UC059 class
			/// </summary>
			public sealed class UC059
			{
				/// <summary>
				/// NoUnitsForReturn class
				/// </summary>
				public static StringResourceItem NoUnitsForReturn()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC059.NoUnitsForReturn") );
				}
			}
			/// <summary>
			/// UC065 class
			/// </summary>
			public sealed class UC065
			{
				/// <summary>
				/// NoRecentIssuedTransfusedUnits class
				/// </summary>
				public static StringResourceItem NoRecentIssuedTransfusedUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC065.NoRecentIssuedTransfusedUnits") );
				}

				/// <summary>
				/// NoRecentOrders class
				/// </summary>
				public static StringResourceItem NoRecentOrders()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC065.NoRecentOrders") );
				}

				/// <summary>
				/// NoTransfusionReactions class
				/// </summary>
				public static StringResourceItem NoTransfusionReactions()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC065.NoTransfusionReactions") );
				}
			}
			/// <summary>
			/// UC068 class
			/// </summary>
			public sealed class UC068
			{
				/// <summary>
				/// ClearPatientMergeAlertWarning class
				/// </summary>
				public static StringResourceItem ClearPatientMergeAlertWarning()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC068.ClearPatientMergeAlertWarning") );
				}
			}
			/// <summary>
			/// UC069 class
			/// </summary>
			public sealed class UC069
			{
				/// <summary>
				/// DelayedTransfusion class
				/// </summary>
				public static StringResourceItem DelayedTransfusion()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC069.DelayedTransfusion") );
				}

				/// <summary>
				/// ProlongedTransfusion class
				/// </summary>
				public static StringResourceItem ProlongedTransfusion()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC069.ProlongedTransfusion") );
				}
			}
			/// <summary>
			/// UC070 class
			/// </summary>
			public sealed class UC070
			{
				/// <summary>
				/// InconsistentAntigenType class
				/// </summary>
				public static StringResourceItem InconsistentAntigenType()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC070.InconsistentAntigenType") );
				}
			}
			/// <summary>
			/// UC071 class
			/// </summary>
			public sealed class UC071
			{
				/// <summary>
				/// InFinalStatus class
				/// </summary>
				public static StringResourceItem InFinalStatus()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC071.InFinalStatus") );
				}

				/// <summary>
				/// InvalidDonationType class
				/// </summary>
				public static StringResourceItem InvalidDonationType()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC071.InvalidDonationType") );
				}

				/// <summary>
				/// IsAssigned class
				/// </summary>
				public static StringResourceItem IsAssigned()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC071.IsAssigned") );
				}

				/// <summary>
				/// IsAutologous class
				/// </summary>
				public static StringResourceItem IsAutologous()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC071.IsAutologous") );
				}

				/// <summary>
				/// NotDirected class
				/// </summary>
				public static StringResourceItem NotDirected()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC071.NotDirected") );
				}

				/// <summary>
				/// NotEligible class
				/// </summary>
				public static StringResourceItem NotEligible()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC071.NotEligible") );
				}
			}
			/// <summary>
			/// UC073 class
			/// </summary>
			public sealed class UC073
			{
				/// <summary>
				/// ABORhDiscrepancy class
				/// </summary>
				public static StringResourceItem ABORhDiscrepancy()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.ABORhDiscrepancy") );
				}

				/// <summary>
				/// ABORhRepeatDiscrepancy class
				/// </summary>
				public static StringResourceItem ABORhRepeatDiscrepancy()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.ABORhRepeatDiscrepancy") );
				}

				/// <summary>
				/// AlreadySelected class
				/// </summary>
				public static StringResourceItem AlreadySelected()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.AlreadySelected") );
				}

				/// <summary>
				/// AntibodyProblem class
				/// </summary>
				public static StringResourceItem AntibodyProblem(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.AntibodyProblem"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// AntigenProblem class
				/// </summary>
				public static StringResourceItem AntigenProblem(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.AntigenProblem"), arg0, arg1 );
				}

				/// <summary>
				/// EmergencyIssueSpecimenDiscrepancy class
				/// </summary>
				public static StringResourceItem EmergencyIssueSpecimenDiscrepancy()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.EmergencyIssueSpecimenDiscrepancy") );
				}

				/// <summary>
				/// InconclusiveCrossmatch class
				/// </summary>
				public static StringResourceItem InconclusiveCrossmatch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.InconclusiveCrossmatch") );
				}

				/// <summary>
				/// IncorrectDivision class
				/// </summary>
				public static StringResourceItem IncorrectDivision()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.IncorrectDivision") );
				}

				/// <summary>
				/// InvalidProductType class
				/// </summary>
				public static StringResourceItem InvalidProductType()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.InvalidProductType") );
				}

				/// <summary>
				/// NoABORhResultsOnSpecimen class
				/// </summary>
				public static StringResourceItem NoABORhResultsOnSpecimen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.NoABORhResultsOnSpecimen") );
				}

				/// <summary>
				/// NoCrossmatchResults class
				/// </summary>
				public static StringResourceItem NoCrossmatchResults()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.NoCrossmatchResults") );
				}

				/// <summary>
				/// NotIssueable class
				/// </summary>
				public static StringResourceItem NotIssueable()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.NotIssueable") );
				}

				/// <summary>
				/// NoUnitsAvailable class
				/// </summary>
				public static StringResourceItem NoUnitsAvailable()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.NoUnitsAvailable") );
				}

				/// <summary>
				/// NoValidUnits class
				/// </summary>
				public static StringResourceItem NoValidUnits(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.NoValidUnits"), arg0 );
				}

				/// <summary>
				/// SelectionOrderInvalid class
				/// </summary>
				public static StringResourceItem SelectionOrderInvalid()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.SelectionOrderInvalid") );
				}

				/// <summary>
				/// SpecimenExpired class
				/// </summary>
				public static StringResourceItem SpecimenExpired()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.SpecimenExpired") );
				}

				/// <summary>
				/// SpecimenTestingNotCompleted class
				/// </summary>
				public static StringResourceItem SpecimenTestingNotCompleted()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.SpecimenTestingNotCompleted") );
				}

				/// <summary>
				/// TRNotSatisfied class
				/// </summary>
				public static StringResourceItem TRNotSatisfied(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.TRNotSatisfied"), arg0 );
				}

				/// <summary>
				/// UnitABORhConfirmationsInconsistent class
				/// </summary>
				public static StringResourceItem UnitABORhConfirmationsInconsistent()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.UnitABORhConfirmationsInconsistent") );
				}

				/// <summary>
				/// UnitCrossmatchBad class
				/// </summary>
				public static StringResourceItem UnitCrossmatchBad()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.UnitCrossmatchBad") );
				}

				/// <summary>
				/// UnitExpired class
				/// </summary>
				public static StringResourceItem UnitExpired()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.UnitExpired") );
				}

				/// <summary>
				/// UnitFrozen class
				/// </summary>
				public static StringResourceItem UnitFrozen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.UnitFrozen") );
				}

				/// <summary>
				/// UnitIsAssigned class
				/// </summary>
				public static StringResourceItem UnitIsAssigned()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.UnitIsAssigned") );
				}

				/// <summary>
				/// UnitQuarantined class
				/// </summary>
				public static StringResourceItem UnitQuarantined()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.UnitQuarantined") );
				}

				/// <summary>
				/// UnitTypeInvalid class
				/// </summary>
				public static StringResourceItem UnitTypeInvalid()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.UnitTypeInvalid") );
				}

				/// <summary>
				/// UnsatisfactoryUnit class
				/// </summary>
				public static StringResourceItem UnsatisfactoryUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.UnsatisfactoryUnit") );
				}
			}
			/// <summary>
			/// UC077 class
			/// </summary>
			public sealed class UC077
			{
				/// <summary>
				/// NoRecordsFound class
				/// </summary>
				public static StringResourceItem NoRecordsFound()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC077.NoRecordsFound") );
				}
			}
			/// <summary>
			/// UC081 class
			/// </summary>
			public sealed class UC081
			{
				/// <summary>
				/// LotNumberNotFound class
				/// </summary>
				public static StringResourceItem LotNumberNotFound(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC081.LotNumberNotFound"), arg0 );
				}
			}
			/// <summary>
			/// UC082 class
			/// </summary>
			public sealed class UC082
			{
				/// <summary>
				/// NoExceptionsFound class
				/// </summary>
				public static StringResourceItem NoExceptionsFound()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC082.NoExceptionsFound") );
				}
			}
			/// <summary>
			/// UC092 class
			/// </summary>
			public sealed class UC092
			{
				/// <summary>
				/// TRWsMustBeSelectedAlone class
				/// </summary>
				public static StringResourceItem TRWsMustBeSelectedAlone()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC092.TRWsMustBeSelectedAlone") );
				}

                /// <summary>
                /// RefreshPTL class
                /// </summary>
                public static StringResourceItem RefreshPTL()
                {
                    return GetStringResourceItem(_classResType, _resourceManager.GetString("UC092.RefreshPTL"));
                }
			}
			/// <summary>
			/// UC094 class
			/// </summary>
			public sealed class UC094
			{
				/// <summary>
				/// AssociatedUnitsOnSpecimen class
				/// </summary>
				public static StringResourceItem AssociatedUnitsOnSpecimen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC094.AssociatedUnitsOnSpecimen") );
				}

				/// <summary>
				/// InvalidateTransfusionRequirement class
				/// </summary>
				public static StringResourceItem InvalidateTransfusionRequirement()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC094.InvalidateTransfusionRequirement") );
				}

				/// <summary>
				/// IssuedUnitCrossmatchResults class
				/// </summary>
				public static StringResourceItem IssuedUnitCrossmatchResults()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC094.IssuedUnitCrossmatchResults") );
				}

				/// <summary>
				/// JustifiedAboRh class
				/// </summary>
				public static StringResourceItem JustifiedAboRh()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC094.JustifiedAboRh") );
				}

				/// <summary>
				/// NoCompletedTests class
				/// </summary>
				public static StringResourceItem NoCompletedTests()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC094.NoCompletedTests") );
				}

				/// <summary>
				/// NonCurrentJustifiedAboRh class
				/// </summary>
				public static StringResourceItem NonCurrentJustifiedAboRh()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC094.NonCurrentJustifiedAboRh") );
				}

				/// <summary>
				/// TransfusedUnitsOnSpecimen class
				/// </summary>
				public static StringResourceItem TransfusedUnitsOnSpecimen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC094.TransfusedUnitsOnSpecimen") );
				}

				/// <summary>
				/// UnitAssignedAfterInvalidation class
				/// </summary>
				public static StringResourceItem UnitAssignedAfterInvalidation(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC094.UnitAssignedAfterInvalidation"), arg0 );
				}
			}
			/// <summary>
			/// UC100 class
			/// </summary>
			public sealed class UC100
			{
				/// <summary>
				/// NoJustificationRequired class
				/// </summary>
				public static StringResourceItem NoJustificationRequired()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC100.NoJustificationRequired") );
				}
			}
			/// <summary>
			/// UnitTest class
			/// </summary>
			public sealed class UnitTest
			{
				/// <summary>
				/// TestString class
				/// </summary>
				public static StringResourceItem TestString(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UnitTest.TestString"), arg0, arg1 );
				}
			}
			/// <summary>
			/// WorklistBuilder class
			/// </summary>
			public sealed class WorklistBuilder
			{
				/// <summary>
				/// UnitAlreadyAdded class
				/// </summary>
				public static StringResourceItem UnitAlreadyAdded(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("WorklistBuilder.UnitAlreadyAdded"), arg0, arg1 );
				}
			}
		}

		/// <summary>
		/// OtherMsg class
		/// </summary>
		public sealed class OtherMsg
		{
			private const StringResourceType _classResType = StringResourceType.Other;
			private static readonly ResourceManager _resourceManager = CreateResourceManagerInstance("OtherMessages");

			private OtherMsg(){}
			static OtherMsg(){}	// get rid of "beforefieldinit" attribute (DON'T REMOVE!)


			/// <summary>
			/// Common class
			/// </summary>
			public sealed class Common
			{
				/// <summary>
				/// DivisionServiceTypeFull class
				/// </summary>
				public static StringResourceItem DivisionServiceTypeFull()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DivisionServiceTypeFull") );
				}

				/// <summary>
				/// DivisionServiceTypeTransfusionOnly class
				/// </summary>
				public static StringResourceItem DivisionServiceTypeTransfusionOnly()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DivisionServiceTypeTransfusionOnly") );
				}

				/// <summary>
				/// DstTypeCustom class
				/// </summary>
				public static StringResourceItem DstTypeCustom()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DstTypeCustom") );
				}

				/// <summary>
				/// DstTypeDoNotObserve class
				/// </summary>
				public static StringResourceItem DstTypeDoNotObserve()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DstTypeDoNotObserve") );
				}

				/// <summary>
				/// DstTypeUnknown class
				/// </summary>
				public static StringResourceItem DstTypeUnknown()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DstTypeUnknown") );
				}

				/// <summary>
				/// DstTypeUsaStandard class
				/// </summary>
				public static StringResourceItem DstTypeUsaStandard()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DstTypeUsaStandard") );
				}

				/// <summary>
				/// ReportsDateRangeCriteriaSeparator class
				/// </summary>
				public static StringResourceItem ReportsDateRangeCriteriaSeparator()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ReportsDateRangeCriteriaSeparator") );
				}

				/// <summary>
				/// ReportsDateRangeCriteriaTitle class
				/// </summary>
				public static StringResourceItem ReportsDateRangeCriteriaTitle()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ReportsDateRangeCriteriaTitle") );
				}
			}
			/// <summary>
			/// MUC01 class
			/// </summary>
			public sealed class MUC01
			{
				/// <summary>
				/// TestResultFailed class
				/// </summary>
				public static StringResourceItem TestResultFailed()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.TestResultFailed") );
				}

				/// <summary>
				/// TestResultNotTested class
				/// </summary>
				public static StringResourceItem TestResultNotTested()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.TestResultNotTested") );
				}

				/// <summary>
				/// TestResultSuccessful class
				/// </summary>
				public static StringResourceItem TestResultSuccessful()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.TestResultSuccessful") );
				}

				/// <summary>
				/// TestResultTesting class
				/// </summary>
				public static StringResourceItem TestResultTesting()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.TestResultTesting") );
				}
			}
			/// <summary>
			/// MUC02 class
			/// </summary>
			public sealed class MUC02
			{
				/// <summary>
				/// DefaultDivisionInvoiceText class
				/// </summary>
				public static StringResourceItem DefaultDivisionInvoiceText()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.DefaultDivisionInvoiceText") );
				}

				/// <summary>
				/// NoActiveDivisionsToDisplay class
				/// </summary>
				public static StringResourceItem NoActiveDivisionsToDisplay()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.NoActiveDivisionsToDisplay") );
				}

				/// <summary>
				/// NoDivisionsDefinedInVbecs class
				/// </summary>
				public static StringResourceItem NoDivisionsDefinedInVbecs()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.NoDivisionsDefinedInVbecs") );
				}

				/// <summary>
				/// NoVbecsDivisionsFound class
				/// </summary>
				public static StringResourceItem NoVbecsDivisionsFound()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.NoVbecsDivisionsFound") );
				}

				/// <summary>
				/// NoVistADivisionsFound class
				/// </summary>
				public static StringResourceItem NoVistADivisionsFound()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.NoVistADivisionsFound") );
				}

				/// <summary>
				/// TestingCantBeConfiguredForDivision class
				/// </summary>
				public static StringResourceItem TestingCantBeConfiguredForDivision(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.TestingCantBeConfiguredForDivision"), arg0 );
				}
			}
			/// <summary>
			/// MUC03 class
			/// </summary>
			public sealed class MUC03
			{
				/// <summary>
				/// EnterSearchCriteria class
				/// </summary>
				public static StringResourceItem EnterSearchCriteria()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC03.EnterSearchCriteria") );
				}

				/// <summary>
				/// NoActiveUsersToDisplay class
				/// </summary>
				public static StringResourceItem NoActiveUsersToDisplay()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC03.NoActiveUsersToDisplay") );
				}

				/// <summary>
				/// NoUsersDefinedInVbecs class
				/// </summary>
				public static StringResourceItem NoUsersDefinedInVbecs()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC03.NoUsersDefinedInVbecs") );
				}

				/// <summary>
				/// NoVistAUsersFound class
				/// </summary>
				public static StringResourceItem NoVistAUsersFound()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC03.NoVistAUsersFound") );
				}
			}
			/// <summary>
			/// UC018 class
			/// </summary>
			public sealed class UC018
			{
				/// <summary>
				/// DivisionLoginMessagebtnOK class
				/// </summary>
				public static StringResourceItem DivisionLoginMessagebtnOK()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.DivisionLoginMessagebtnOK") );
				}

				/// <summary>
				/// DivisionLoginMessagetxtIntroText class
				/// </summary>
				public static StringResourceItem DivisionLoginMessagetxtIntroText()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.DivisionLoginMessagetxtIntroText") );
				}

				/// <summary>
				/// VistALinkSignOnErrorMessageHeader class
				/// </summary>
				public static StringResourceItem VistALinkSignOnErrorMessageHeader()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.VistALinkSignOnErrorMessageHeader") );
				}
			}
			/// <summary>
			/// UC02 class
			/// </summary>
			public sealed class UC02
			{
				/// <summary>
				/// UnitABORhMismatch class
				/// </summary>
				public static StringResourceItem UnitABORhMismatch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC02.UnitABORhMismatch") );
				}
			}
			/// <summary>
			/// UC043 class
			/// </summary>
			public sealed class UC043
			{
				/// <summary>
				/// Compatible class
				/// </summary>
				public static StringResourceItem Compatible()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.Compatible") );
				}

				/// <summary>
				/// MedicalDirectorApprovalOnly class
				/// </summary>
				public static StringResourceItem MedicalDirectorApprovalOnly()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.MedicalDirectorApprovalOnly") );
				}

				/// <summary>
				/// NoCrossmatchAtIssue class
				/// </summary>
				public static StringResourceItem NoCrossmatchAtIssue()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.NoCrossmatchAtIssue") );
				}

				/// <summary>
				/// NotApplicable class
				/// </summary>
				public static StringResourceItem NotApplicable()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.NotApplicable") );
				}

				/// <summary>
				/// NotRequired class
				/// </summary>
				public static StringResourceItem NotRequired()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.NotRequired") );
				}
			}
			/// <summary>
			/// UC102 class
			/// </summary>
			public sealed class UC102
			{
				/// <summary>
				/// AccessCodeLabel class
				/// </summary>
				public static StringResourceItem AccessCodeLabel()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.AccessCodeLabel") );
				}

				/// <summary>
				/// CombinedAccessAndVerifyLabel class
				/// </summary>
				public static StringResourceItem CombinedAccessAndVerifyLabel(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.CombinedAccessAndVerifyLabel"), arg0 );
				}

				/// <summary>
				/// CombinedValidationMessageTemplate class
				/// </summary>
				public static StringResourceItem CombinedValidationMessageTemplate(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.CombinedValidationMessageTemplate"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// OKPartOfCombinedValidationMessage class
				/// </summary>
				public static StringResourceItem OKPartOfCombinedValidationMessage()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.OKPartOfCombinedValidationMessage") );
				}

				/// <summary>
				/// SingleEntryModeVerifyCodeTextBoxCaption class
				/// </summary>
				public static StringResourceItem SingleEntryModeVerifyCodeTextBoxCaption()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.SingleEntryModeVerifyCodeTextBoxCaption") );
				}

				/// <summary>
				/// VerifyCodeLabel class
				/// </summary>
				public static StringResourceItem VerifyCodeLabel()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.VerifyCodeLabel") );
				}

				/// <summary>
				/// VistAVerifyCodeChangeCodeRequirements class
				/// </summary>
				public static StringResourceItem VistAVerifyCodeChangeCodeRequirements()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.VistAVerifyCodeChangeCodeRequirements") );
				}
			}
			/// <summary>
			/// UC103 class
			/// </summary>
			public sealed class UC103
			{
				/// <summary>
				/// RestoreVistALinkConnectionButtonCancelText class
				/// </summary>
				public static StringResourceItem RestoreVistALinkConnectionButtonCancelText()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC103.RestoreVistALinkConnectionButtonCancelText") );
				}

				/// <summary>
				/// RestoreVistALinkConnectionButtonCloseText class
				/// </summary>
				public static StringResourceItem RestoreVistALinkConnectionButtonCloseText()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC103.RestoreVistALinkConnectionButtonCloseText") );
				}

				/// <summary>
				/// RestoreVistALinkConnectionButtonTest class
				/// </summary>
				public static StringResourceItem RestoreVistALinkConnectionButtonTest()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC103.RestoreVistALinkConnectionButtonTest") );
				}

				/// <summary>
				/// VistALinkDetailedStatusConnecting class
				/// </summary>
				public static StringResourceItem VistALinkDetailedStatusConnecting()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC103.VistALinkDetailedStatusConnecting") );
				}

				/// <summary>
				/// VistALinkDetailedStatusFailedToRestore class
				/// </summary>
				public static StringResourceItem VistALinkDetailedStatusFailedToRestore()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC103.VistALinkDetailedStatusFailedToRestore") );
				}

				/// <summary>
				/// VistALinkDetailedStatusNotConnected class
				/// </summary>
				public static StringResourceItem VistALinkDetailedStatusNotConnected()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC103.VistALinkDetailedStatusNotConnected") );
				}

				/// <summary>
				/// VistALinkShortStatusConnecting class
				/// </summary>
				public static StringResourceItem VistALinkShortStatusConnecting()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC103.VistALinkShortStatusConnecting") );
				}

				/// <summary>
				/// VistALinkShortStatusFailedToRestore class
				/// </summary>
				public static StringResourceItem VistALinkShortStatusFailedToRestore()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC103.VistALinkShortStatusFailedToRestore") );
				}

				/// <summary>
				/// VistALinkShortStatusNotConnected class
				/// </summary>
				public static StringResourceItem VistALinkShortStatusNotConnected()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC103.VistALinkShortStatusNotConnected") );
				}
			}
			/// <summary>
			/// UC105 class
			/// </summary>
			public sealed class UC105
			{
				/// <summary>
				/// SortOrderNameIssueToLocation class
				/// </summary>
				public static StringResourceItem SortOrderNameIssueToLocation()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC105.SortOrderNameIssueToLocation") );
				}

				/// <summary>
				/// SortOrderNameReverseChronological class
				/// </summary>
				public static StringResourceItem SortOrderNameReverseChronological()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC105.SortOrderNameReverseChronological") );
				}

				/// <summary>
				/// SortOrderTitle class
				/// </summary>
				public static StringResourceItem SortOrderTitle()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC105.SortOrderTitle") );
				}
			}
			/// <summary>
			/// UC41 class
			/// </summary>
			public sealed class UC41
			{
				/// <summary>
				/// UnitAntigenTypeMismatch class
				/// </summary>
				public static StringResourceItem UnitAntigenTypeMismatch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC41.UnitAntigenTypeMismatch") );
				}
			}
			/// <summary>
			/// UnitTest class
			/// </summary>
			public sealed class UnitTest
			{
				/// <summary>
				/// TestString class
				/// </summary>
				public static StringResourceItem TestString(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UnitTest.TestString"), arg0, arg1 );
				}
			}
		}

		/// <summary>
		/// PromptMsg class
		/// </summary>
		public sealed class PromptMsg
		{
			private const StringResourceType _classResType = StringResourceType.Prompt;
			private static readonly ResourceManager _resourceManager = CreateResourceManagerInstance("PromptMessages");

			private PromptMsg(){}
			static PromptMsg(){}	// get rid of "beforefieldinit" attribute (DON'T REMOVE!)


			/// <summary>
			/// UnitTest class
			/// </summary>
			public sealed class UnitTest
			{
				/// <summary>
				/// TestString class
				/// </summary>
				public static StringResourceItem TestString(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UnitTest.TestString"), arg0, arg1 );
				}
			}
		}

		/// <summary>
		/// SysErrMsg class
		/// </summary>
		public sealed class SysErrMsg
		{
			private const StringResourceType _classResType = StringResourceType.SystemError;
			private static readonly ResourceManager _resourceManager = CreateResourceManagerInstance("SystemErrorMessages");

			private SysErrMsg(){}
			static SysErrMsg(){}	// get rid of "beforefieldinit" attribute (DON'T REMOVE!)

            /// <summary>
            /// Database class
            /// </summary>
            public sealed class Database
            {
                /// <summary>
                /// DbConnectivityFailureDescribed class
                /// </summary>
                public static StringResourceItem DbConnectivityFailureDescribed(object arg0)
                {
                    return GetStringResourceItem(_classResType, _resourceManager.GetString("Database.DbConnectivityFailureDescribed"), arg0);
                }

                /// <summary>
                /// DbConnectivityFailureGeneral class
                /// </summary>
                public static StringResourceItem DbConnectivityFailureGeneral()
                {
                    return GetStringResourceItem(_classResType, _resourceManager.GetString("Database.DbConnectivityFailureGeneral"));
                }

                /// <summary>
                /// DbNullCantBeConvertedToBoolean class
                /// </summary>
                public static StringResourceItem DbNullCantBeConvertedToBoolean()
                {
                    return GetStringResourceItem(_classResType, _resourceManager.GetString("Database.DbNullCantBeConvertedToBoolean"));
                }

                /// <summary>
                /// DbQueryTimeout class - CR2113
                /// </summary>
                public static StringResourceItem DbQueryTimeout()
                {
                    return GetStringResourceItem(_classResType, _resourceManager.GetString("Database.DbQueryTimeout"));
                }
            }

			/// <summary>
			/// Common class
			/// </summary>
			public sealed class Common
			{
				/// <summary>
				/// AddNewCollectionFacility class
				/// </summary>
				public static StringResourceItem AddNewCollectionFacility(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.AddNewCollectionFacility"), arg0 );
				}
                /// <summary>
                /// Mismatched Build CR 3454
                /// </summary>
                public static StringResourceItem MisMatchedBuild(object arg0, object arg1)
                {
                    return GetStringResourceItem(_classResType, _resourceManager.GetString("Common.MismatchedBuild"), arg0, arg1);
                }
				/// <summary>
				/// ADORHOrExpirationDatesDoNotMatch class
				/// </summary>
				public static StringResourceItem ADORHOrExpirationDatesDoNotMatch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ADORHOrExpirationDatesDoNotMatch") );
				}

				/// <summary>
				/// AlreadyLocked class
				/// </summary>
				public static StringResourceItem AlreadyLocked(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.AlreadyLocked"), arg0, arg1 );
				}

				/// <summary>
				/// AttemptToRunInDesignConfiguration class
				/// </summary>
				public static StringResourceItem AttemptToRunInDesignConfiguration()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.AttemptToRunInDesignConfiguration") );
				}

				/// <summary>
				/// CannotbeGreaterError class
				/// </summary>
				public static StringResourceItem CannotbeGreaterError(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.CannotbeGreaterError"), arg0, arg1 );
				}

				/// <summary>
				/// CannotbeLessError class
				/// </summary>
				public static StringResourceItem CannotbeLessError(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.CannotbeLessError"), arg0, arg1 );
				}

				/// <summary>
				/// CannotbeLocked class
				/// </summary>
				public static StringResourceItem CannotbeLocked(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.CannotbeLocked"), arg0 );
				}

				/// <summary>
				/// CannotChangeMSBOSToTypeAndScreen class
				/// </summary>
				public static StringResourceItem CannotChangeMSBOSToTypeAndScreen(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.CannotChangeMSBOSToTypeAndScreen"), arg0 );
				}

				/// <summary>
				/// CannotCreateSearchTool class
				/// </summary>
				public static StringResourceItem CannotCreateSearchTool(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.CannotCreateSearchTool"), arg0 );
				}

				/// <summary>
				/// CodabarProductCode class
				/// </summary>
				public static StringResourceItem CodabarProductCode()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.CodabarProductCode") );
				}

				/// <summary>
				/// ColumnNotFoundInDataRow class
				/// </summary>
				public static StringResourceItem ColumnNotFoundInDataRow(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ColumnNotFoundInDataRow"), arg0 );
				}

				/// <summary>
				/// ConfirmShipmentError class
				/// </summary>
				public static StringResourceItem ConfirmShipmentError()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ConfirmShipmentError") );
				}

				/// <summary>
				/// DataErrorInactivateTest class
				/// </summary>
				public static StringResourceItem DataErrorInactivateTest(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DataErrorInactivateTest"), arg0, arg1 );
				}

				/// <summary>
				/// DataErrorInactivateUnit class
				/// </summary>
				public static StringResourceItem DataErrorInactivateUnit(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DataErrorInactivateUnit"), arg0, arg1 );
				}

				/// <summary>
				/// DataErrorInactivateUser class
				/// </summary>
				public static StringResourceItem DataErrorInactivateUser(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DataErrorInactivateUser"), arg0, arg1 );
				}

				/// <summary>
				/// DataNotInvalidated class
				/// </summary>
				public static StringResourceItem DataNotInvalidated(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DataNotInvalidated"), arg0 );
				}

				/// <summary>
				/// DataNotSaved class
				/// </summary>
				public static StringResourceItem DataNotSaved(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DataNotSaved"), arg0 );
				}

				/// <summary>
				/// DataRetrieveError class
				/// </summary>
				public static StringResourceItem DataRetrieveError(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DataRetrieveError"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// DataSaveError class
				/// </summary>
				public static StringResourceItem DataSaveError(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DataSaveError"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// DataUpdateError class
				/// </summary>
				public static StringResourceItem DataUpdateError(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DataUpdateError"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// DataWasNotSavedBecauseOfRowversionViolation class
				/// </summary>
				public static StringResourceItem DataWasNotSavedBecauseOfRowversionViolation()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DataWasNotSavedBecauseOfRowversionViolation") );
				}

				/// <summary>
				/// DateSetToFuture class
				/// </summary>
				public static StringResourceItem DateSetToFuture(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DateSetToFuture"), arg0 );
				}

				/// <summary>
				/// DonationTypeListError class
				/// </summary>
				public static StringResourceItem DonationTypeListError(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DonationTypeListError"), arg0 );
				}

				/// <summary>
				/// DuplicateTransfusionRequirement class
				/// </summary>
				public static StringResourceItem DuplicateTransfusionRequirement()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DuplicateTransfusionRequirement") );
				}

				/// <summary>
				/// Dynamic class
				/// </summary>
				public static StringResourceItem Dynamic(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.Dynamic"), arg0 );
				}

				/// <summary>
				/// ExpirationDateExceedsMaximum class
				/// </summary>
				public static StringResourceItem ExpirationDateExceedsMaximum(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ExpirationDateExceedsMaximum"), arg0 );
				}

				/// <summary>
				/// FacilityTypeIndicatorRequired class
				/// </summary>
				public static StringResourceItem FacilityTypeIndicatorRequired()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.FacilityTypeIndicatorRequired") );
				}

				/// <summary>
				/// FailedToCreateSecurityDescriptorForWin32Mutex class
				/// </summary>
				public static StringResourceItem FailedToCreateSecurityDescriptorForWin32Mutex()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.FailedToCreateSecurityDescriptorForWin32Mutex") );
				}

				/// <summary>
				/// FieldLengthError class
				/// </summary>
				public static StringResourceItem FieldLengthError(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.FieldLengthError"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// FirstNameCannotBeBlank class
				/// </summary>
				public static StringResourceItem FirstNameCannotBeBlank()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.FirstNameCannotBeBlank") );
				}

				/// <summary>
				/// FreeTextCommentMustBeEntered class
				/// </summary>
				public static StringResourceItem FreeTextCommentMustBeEntered(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.FreeTextCommentMustBeEntered"), arg0 );
				}

				/// <summary>
				/// GeneralError class
				/// </summary>
				public static StringResourceItem GeneralError(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.GeneralError"), arg0 );
				}

				/// <summary>
				/// GenerateEyeReadableUnitIDError class
				/// </summary>
				public static StringResourceItem GenerateEyeReadableUnitIDError()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.GenerateEyeReadableUnitIDError") );
				}

				/// <summary>
				/// GlobalLogonUserDivisionCodeIsNotSaved class
				/// </summary>
				public static StringResourceItem GlobalLogonUserDivisionCodeIsNotSaved()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.GlobalLogonUserDivisionCodeIsNotSaved") );
				}

				/// <summary>
				/// InactiveBloodProduct class
				/// </summary>
				public static StringResourceItem InactiveBloodProduct()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InactiveBloodProduct") );
				}

				/// <summary>
				/// InactiveProductSupplier class
				/// </summary>
				public static StringResourceItem InactiveProductSupplier()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InactiveProductSupplier") );
				}

				/// <summary>
				/// InsertPatientFail class
				/// </summary>
				public static StringResourceItem InsertPatientFail()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InsertPatientFail") );
				}

				/// <summary>
				/// InsufficientColumns class
				/// </summary>
				public static StringResourceItem InsufficientColumns(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InsufficientColumns"), arg0 );
				}

				/// <summary>
				/// InsufficientNumberOfDataRowsFoundWhileExpectingSingleRow class
				/// </summary>
				public static StringResourceItem InsufficientNumberOfDataRowsFoundWhileExpectingSingleRow(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InsufficientNumberOfDataRowsFoundWhileExpectingSingleRow"), arg0, arg1 );
				}

				/// <summary>
				/// InsufficientSecurityPrivileges class
				/// </summary>
				public static StringResourceItem InsufficientSecurityPrivileges(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InsufficientSecurityPrivileges"), arg0 );
				}

				/// <summary>
				/// InternalErrorUnrecognizedException class
				/// </summary>
				public static StringResourceItem InternalErrorUnrecognizedException(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InternalErrorUnrecognizedException"), arg0 );
				}

				/// <summary>
				/// InvalidArgument class
				/// </summary>
				public static StringResourceItem InvalidArgument(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InvalidArgument"), arg0 );
				}

				/// <summary>
				/// InvalidCCTest class
				/// </summary>
				public static StringResourceItem InvalidCCTest()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InvalidCCTest") );
				}

				/// <summary>
				/// InvalidDataLoadedFromDataRowIntoBusinessObject class
				/// </summary>
				public static StringResourceItem InvalidDataLoadedFromDataRowIntoBusinessObject(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InvalidDataLoadedFromDataRowIntoBusinessObject"), arg0, arg1 );
				}

				/// <summary>
				/// InvalidDivisionCodeSupplied class
				/// </summary>
				public static StringResourceItem InvalidDivisionCodeSupplied()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InvalidDivisionCodeSupplied") );
				}

				/// <summary>
				/// InvalidDivisionNameSupplied class
				/// </summary>
				public static StringResourceItem InvalidDivisionNameSupplied()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InvalidDivisionNameSupplied") );
				}

				/// <summary>
				/// InvalidFormat class
				/// </summary>
				public static StringResourceItem InvalidFormat(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InvalidFormat"), arg0 );
				}

				/// <summary>
				/// InvalidKeyPressed class
				/// </summary>
				public static StringResourceItem InvalidKeyPressed()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InvalidKeyPressed") );
				}

				/// <summary>
				/// InvalidModificationType class
				/// </summary>
				public static StringResourceItem InvalidModificationType()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InvalidModificationType") );
				}

				/// <summary>
				/// InvalidProductTypeModification class
				/// </summary>
				public static StringResourceItem InvalidProductTypeModification()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InvalidProductTypeModification") );
				}

				/// <summary>
				/// InvalidPropertyOrMethod class
				/// </summary>
				public static StringResourceItem InvalidPropertyOrMethod(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InvalidPropertyOrMethod"), arg0, arg1 );
				}

				/// <summary>
				/// InvalidRhCode class
				/// </summary>
				public static StringResourceItem InvalidRhCode(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InvalidRhCode"), arg0 );
				}

				/// <summary>
				/// InvalidZipCodeLength class
				/// </summary>
				public static StringResourceItem InvalidZipCodeLength()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InvalidZipCodeLength") );
				}

				/// <summary>
				/// ISBTProductCode class
				/// </summary>
				public static StringResourceItem ISBTProductCode()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ISBTProductCode") );
				}

				/// <summary>
				/// KeyValuePairNotFoundInConfigFile class
				/// </summary>
				public static StringResourceItem KeyValuePairNotFoundInConfigFile(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.KeyValuePairNotFoundInConfigFile"), arg0 );
				}

				/// <summary>
				/// LastNameCannotBeBlank class
				/// </summary>
				public static StringResourceItem LastNameCannotBeBlank()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.LastNameCannotBeBlank") );
				}

				/// <summary>
				/// LockDecrementError class
				/// </summary>
				public static StringResourceItem LockDecrementError()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.LockDecrementError") );
				}

				/// <summary>
				/// LockTimeout class
				/// </summary>
				public static StringResourceItem LockTimeout()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.LockTimeout") );
				}

				/// <summary>
				/// LockUninitializedException class
				/// </summary>
				public static StringResourceItem LockUninitializedException(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.LockUninitializedException"), arg0 );
				}

				/// <summary>
				/// NewBusinessObjectCannotBeRestoredFromDb class
				/// </summary>
				public static StringResourceItem NewBusinessObjectCannotBeRestoredFromDb(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.NewBusinessObjectCannotBeRestoredFromDb"), arg0 );
				}

				/// <summary>
				/// NoCollectionFacilityFound class
				/// </summary>
				public static StringResourceItem NoCollectionFacilityFound(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.NoCollectionFacilityFound"), arg0 );
				}

				/// <summary>
				/// NoDataRowsFoundException class
				/// </summary>
				public static StringResourceItem NoDataRowsFoundException(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.NoDataRowsFoundException"), arg0 );
				}

				/// <summary>
				/// NoDuplicateBloodUnits class
				/// </summary>
				public static StringResourceItem NoDuplicateBloodUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.NoDuplicateBloodUnits") );
				}

				/// <summary>
				/// NoRecordsFoundException class
				/// </summary>
				public static StringResourceItem NoRecordsFoundException(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.NoRecordsFoundException"), arg0 );
				}

				/// <summary>
				/// NoRowsUpdated class
				/// </summary>
				public static StringResourceItem NoRowsUpdated()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.NoRowsUpdated") );
				}

				/// <summary>
				/// NoTablesFoundException class
				/// </summary>
				public static StringResourceItem NoTablesFoundException(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.NoTablesFoundException"), arg0 );
				}

				/// <summary>
				/// NotImplemented class
				/// </summary>
				public static StringResourceItem NotImplemented()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.NotImplemented") );
				}

				/// <summary>
				/// PatientDataIsIncorrect class
				/// </summary>
				public static StringResourceItem PatientDataIsIncorrect(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PatientDataIsIncorrect"), arg0 );
				}

				/// <summary>
				/// PatientNameTooLong class
				/// </summary>
				public static StringResourceItem PatientNameTooLong()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PatientNameTooLong") );
				}

				/// <summary>
				/// RangeError class
				/// </summary>
				public static StringResourceItem RangeError(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.RangeError"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// ReactivationError class
				/// </summary>
				public static StringResourceItem ReactivationError(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ReactivationError"), arg0 );
				}

				/// <summary>
				/// ReagentIsNotReactingWithinExpectedParameters class
				/// </summary>
				public static StringResourceItem ReagentIsNotReactingWithinExpectedParameters()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ReagentIsNotReactingWithinExpectedParameters") );
				}

				/// <summary>
				/// RecordIsLockedByAnotherUser class
				/// </summary>
				public static StringResourceItem RecordIsLockedByAnotherUser(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.RecordIsLockedByAnotherUser"), arg0, arg1 );
				}

				/// <summary>
				/// RecordIsLockedByCurrentUser class
				/// </summary>
				public static StringResourceItem RecordIsLockedByCurrentUser(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.RecordIsLockedByCurrentUser"), arg0 );
				}

				/// <summary>
				/// RecoverableExceptionOccuredWhenOnlyMainFormWasAvailable class
				/// </summary>
				public static StringResourceItem RecoverableExceptionOccuredWhenOnlyMainFormWasAvailable()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.RecoverableExceptionOccuredWhenOnlyMainFormWasAvailable") );
				}

				/// <summary>
				/// RecoverableExceptionOccuredWithoutMainForm class
				/// </summary>
				public static StringResourceItem RecoverableExceptionOccuredWithoutMainForm()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.RecoverableExceptionOccuredWithoutMainForm") );
				}

				/// <summary>
				/// ReportNotScheduled class
				/// </summary>
				public static StringResourceItem ReportNotScheduled()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ReportNotScheduled") );
				}

				/// <summary>
				/// RequiredDataNotPresentInSelectedItem class
				/// </summary>
				public static StringResourceItem RequiredDataNotPresentInSelectedItem()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.RequiredDataNotPresentInSelectedItem") );
				}

				/// <summary>
				/// RequiredFieldMissing class
				/// </summary>
				public static StringResourceItem RequiredFieldMissing(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.RequiredFieldMissing"), arg0 );
				}

				/// <summary>
				/// ScheduleReportFailed class
				/// </summary>
				public static StringResourceItem ScheduleReportFailed()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ScheduleReportFailed") );
				}

				/// <summary>
				/// SearchToolError class
				/// </summary>
				public static StringResourceItem SearchToolError(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SearchToolError"), arg0 );
				}

				/// <summary>
				/// SpecialTestingListError class
				/// </summary>
				public static StringResourceItem SpecialTestingListError(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SpecialTestingListError"), arg0 );
				}

				/// <summary>
				/// StateLength class
				/// </summary>
				public static StringResourceItem StateLength()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.StateLength") );
				}

				/// <summary>
				/// SystemConnectError class
				/// </summary>
				public static StringResourceItem SystemConnectError()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SystemConnectError") );
				}

				/// <summary>
				/// SystemErrorInactivateTest class
				/// </summary>
				public static StringResourceItem SystemErrorInactivateTest(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SystemErrorInactivateTest"), arg0, arg1 );
				}

				/// <summary>
				/// SystemErrorInactivateUnit class
				/// </summary>
				public static StringResourceItem SystemErrorInactivateUnit(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SystemErrorInactivateUnit"), arg0, arg1 );
				}

				/// <summary>
				/// SystemErrorInactivateUser class
				/// </summary>
				public static StringResourceItem SystemErrorInactivateUser(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SystemErrorInactivateUser"), arg0, arg1 );
				}

				/// <summary>
				/// SystemErrorWhileSaving class
				/// </summary>
				public static StringResourceItem SystemErrorWhileSaving(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SystemErrorWhileSaving"), arg0 );
				}

				/// <summary>
				/// SystemRetrieveError class
				/// </summary>
				public static StringResourceItem SystemRetrieveError(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SystemRetrieveError"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// SystemSaveError class
				/// </summary>
				public static StringResourceItem SystemSaveError(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SystemSaveError"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// SystemUpdateError class
				/// </summary>
				public static StringResourceItem SystemUpdateError(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SystemUpdateError"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// TableSchemaMismatch class
				/// </summary>
				public static StringResourceItem TableSchemaMismatch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.TableSchemaMismatch") );
				}

				/// <summary>
				/// TestingStatusListError class
				/// </summary>
				public static StringResourceItem TestingStatusListError(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.TestingStatusListError"), arg0 );
				}

				/// <summary>
				/// TimedOutWhileWaitingForGlobalSyncLock class
				/// </summary>
				public static StringResourceItem TimedOutWhileWaitingForGlobalSyncLock()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.TimedOutWhileWaitingForGlobalSyncLock") );
				}

				/// <summary>
				/// TooManyDataRowsFoundException class
				/// </summary>
				public static StringResourceItem TooManyDataRowsFoundException(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.TooManyDataRowsFoundException"), arg0 );
				}

				/// <summary>
				/// TooManyRecordsFoundException class
				/// </summary>
				public static StringResourceItem TooManyRecordsFoundException(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.TooManyRecordsFoundException"), arg0 );
				}

				/// <summary>
				/// TooManyTablesFoundException class
				/// </summary>
				public static StringResourceItem TooManyTablesFoundException(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.TooManyTablesFoundException"), arg0 );
				}

				/// <summary>
				/// UnableToConvertDSTCodeToEnum class
				/// </summary>
				public static StringResourceItem UnableToConvertDSTCodeToEnum(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UnableToConvertDSTCodeToEnum"), arg0 );
				}

				/// <summary>
				/// UnableToCreateOrOpenWin32Mutex class
				/// </summary>
				public static StringResourceItem UnableToCreateOrOpenWin32Mutex()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UnableToCreateOrOpenWin32Mutex") );
				}

				/// <summary>
				/// UnableToExportVistALinkConfigurationFromBO class
				/// </summary>
				public static StringResourceItem UnableToExportVistALinkConfigurationFromBO(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UnableToExportVistALinkConfigurationFromBO"), arg0 );
				}

				/// <summary>
				/// UnableToGenerateReportBecauseSomeRulesAreBroken class
				/// </summary>
				public static StringResourceItem UnableToGenerateReportBecauseSomeRulesAreBroken(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UnableToGenerateReportBecauseSomeRulesAreBroken"), arg0, arg1 );
				}

				/// <summary>
				/// UnableToReleaseWin32Mutex class
				/// </summary>
				public static StringResourceItem UnableToReleaseWin32Mutex()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UnableToReleaseWin32Mutex") );
				}

				/// <summary>
				/// UnableToSaveInvalidBusinessObject class
				/// </summary>
				public static StringResourceItem UnableToSaveInvalidBusinessObject(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UnableToSaveInvalidBusinessObject"), arg0 );
				}

				/// <summary>
				/// UnexpectedException class
				/// </summary>
				public static StringResourceItem UnexpectedException(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UnexpectedException"), arg0 );
				}

				/// <summary>
				/// UnexpectedNullValueFoundInDataRow class
				/// </summary>
				public static StringResourceItem UnexpectedNullValueFoundInDataRow(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UnexpectedNullValueFoundInDataRow"), arg0 );
				}

				/// <summary>
				/// UnitExistsinDatabase class
				/// </summary>
				public static StringResourceItem UnitExistsinDatabase()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UnitExistsinDatabase") );
				}

				/// <summary>
				/// UnitInFinalStatus class
				/// </summary>
				public static StringResourceItem UnitInFinalStatus()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UnitInFinalStatus") );
				}

				/// <summary>
				/// UnitNotFound class
				/// </summary>
				public static StringResourceItem UnitNotFound()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UnitNotFound") );
				}

				/// <summary>
				/// UnitStatusInvalidForModification class
				/// </summary>
				public static StringResourceItem UnitStatusInvalidForModification(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UnitStatusInvalidForModification"), arg0 );
				}

				/// <summary>
				/// UnsatisfactoryReagent class
				/// </summary>
				public static StringResourceItem UnsatisfactoryReagent(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UnsatisfactoryReagent"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// UpdateFailed class
				/// </summary>
				public static StringResourceItem UpdateFailed(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.UpdateFailed"), arg0 );
				}

				/// <summary>
				/// VbecsUserRoleIsAlreadyInTheCollection class
				/// </summary>
				public static StringResourceItem VbecsUserRoleIsAlreadyInTheCollection(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.VbecsUserRoleIsAlreadyInTheCollection"), arg0 );
				}

				/// <summary>
				/// VistaLinkDataAcessFailure class
				/// </summary>
				public static StringResourceItem VistaLinkDataAcessFailure(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.VistaLinkDataAcessFailure"), arg0 );
				}

				/// <summary>
				/// VistALinkNetworkFailure class
				/// </summary>
				public static StringResourceItem VistALinkNetworkFailure()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.VistALinkNetworkFailure") );
				}

				/// <summary>
				/// VistALinkPrimaryServerInfoWasNotSupplied class
				/// </summary>
				public static StringResourceItem VistALinkPrimaryServerInfoWasNotSupplied()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.VistALinkPrimaryServerInfoWasNotSupplied") );
				}

				/// <summary>
				/// WholeBloodAndRedBloodCellsOnly class
				/// </summary>
				public static StringResourceItem WholeBloodAndRedBloodCellsOnly()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.WholeBloodAndRedBloodCellsOnly") );
				}
			}
			/// <summary>
			/// FrmVbecs class
			/// </summary>
			public sealed class FrmVbecs
			{
				/// <summary>
				/// VistALinkClosed class
				/// </summary>
				public static StringResourceItem VistALinkClosed()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("FrmVbecs.VistALinkClosed") );
				}
            }
			/// <summary>
			/// Lock class
			/// </summary>
			public sealed class Lock
			{
				/// <summary>
				/// LockFunctionNotSet class
				/// </summary>
				public static StringResourceItem LockFunctionNotSet()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Lock.LockFunctionNotSet") );
				}

				/// <summary>
				/// RecordAlreadyLocked class
				/// </summary>
				public static StringResourceItem RecordAlreadyLocked(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Lock.RecordAlreadyLocked"), arg0, arg1 );
				}

				/// <summary>
				/// RecordLockedInDifferentArea class
				/// </summary>
				public static StringResourceItem RecordLockedInDifferentArea(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Lock.RecordLockedInDifferentArea"), arg0 );
				}
			}
			/// <summary>
			/// MUC01 class
			/// </summary>
			public sealed class MUC01
			{
				/// <summary>
				/// AnotherInstanceOfVbecsAdminIsRunning class
				/// </summary>
				public static StringResourceItem AnotherInstanceOfVbecsAdminIsRunning()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.AnotherInstanceOfVbecsAdminIsRunning") );
				}

				/// <summary>
				/// ConnectionTestFailedDueToCancelledLogon class
				/// </summary>
				public static StringResourceItem ConnectionTestFailedDueToCancelledLogon()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.ConnectionTestFailedDueToCancelledLogon") );
				}

				/// <summary>
				/// ConnectionTestFailedMultipleExceptionsHeader class
				/// </summary>
				public static StringResourceItem ConnectionTestFailedMultipleExceptionsHeader()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.ConnectionTestFailedMultipleExceptionsHeader") );
				}

				/// <summary>
				/// ConnectionTestFailedSingleExceptionHeader class
				/// </summary>
				public static StringResourceItem ConnectionTestFailedSingleExceptionHeader()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.ConnectionTestFailedSingleExceptionHeader") );
				}

				/// <summary>
				/// IncompatibleVistALinkProtocol class
				/// </summary>
				public static StringResourceItem IncompatibleVistALinkProtocol()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.IncompatibleVistALinkProtocol") );
				}

				/// <summary>
				/// UserIsNotAdminAndNotAuthorized class
				/// </summary>
				public static StringResourceItem UserIsNotAdminAndNotAuthorized()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.UserIsNotAdminAndNotAuthorized") );
				}

				/// <summary>
				/// VbecsAdministratorLogonError class
				/// </summary>
				public static StringResourceItem VbecsAdministratorLogonError(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.VbecsAdministratorLogonError"), arg0, arg1 );
				}

				/// <summary>
				/// VbecsIsRunningOnTheServer class
				/// </summary>
				public static StringResourceItem VbecsIsRunningOnTheServer()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.VbecsIsRunningOnTheServer") );
				}
			}
			/// <summary>
			/// MUC02 class
			/// </summary>
			public sealed class MUC02
			{
				/// <summary>
				/// DivisionBaseUpdateInvalidInputRowCount class
				/// </summary>
				public static StringResourceItem DivisionBaseUpdateInvalidInputRowCount(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.DivisionBaseUpdateInvalidInputRowCount"), arg0 );
				}

				/// <summary>
				/// FacilityDefinitionNotFoundInNationalTable class
				/// </summary>
				public static StringResourceItem FacilityDefinitionNotFoundInNationalTable(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.FacilityDefinitionNotFoundInNationalTable"), arg0 );
				}
			}
			/// <summary>
			/// MUC03 class
			/// </summary>
			public sealed class MUC03
			{
				/// <summary>
				/// UsersGroupDoesNotExist class
				/// </summary>
				public static StringResourceItem UsersGroupDoesNotExist(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC03.UsersGroupDoesNotExist"), arg0 );
				}
			}
			/// <summary>
			/// UC001 class
			/// </summary>
			public sealed class UC001
			{
				/// <summary>
				/// ABORhNotFound class
				/// </summary>
				public static StringResourceItem ABORhNotFound()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.ABORhNotFound") );
				}

				/// <summary>
				/// AddUnitToList class
				/// </summary>
				public static StringResourceItem AddUnitToList()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.AddUnitToList") );
				}

				/// <summary>
				/// EightCharactersRequiredForProductCode class
				/// </summary>
				public static StringResourceItem EightCharactersRequiredForProductCode()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.EightCharactersRequiredForProductCode") );
				}

				/// <summary>
				/// IncorrectABORH class
				/// </summary>
				public static StringResourceItem IncorrectABORH()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.IncorrectABORH") );
				}

				/// <summary>
				/// IncorrectUnitID class
				/// </summary>
				public static StringResourceItem IncorrectUnitID()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.IncorrectUnitID") );
				}

				/// <summary>
				/// InvalidExpirationDate class
				/// </summary>
				public static StringResourceItem InvalidExpirationDate()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.InvalidExpirationDate") );
				}

				/// <summary>
				/// InvalidExpirationDateMaxStorageTime class
				/// </summary>
				public static StringResourceItem InvalidExpirationDateMaxStorageTime()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.InvalidExpirationDateMaxStorageTime") );
				}

				/// <summary>
				/// InvalidProductCode class
				/// </summary>
				public static StringResourceItem InvalidProductCode()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.InvalidProductCode") );
				}

				/// <summary>
				/// NoAuthorityToAddNewProduct class
				/// </summary>
				public static StringResourceItem NoAuthorityToAddNewProduct()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.NoAuthorityToAddNewProduct") );
				}

				/// <summary>
				/// NoDiseaseMarkerTesting class
				/// </summary>
				public static StringResourceItem NoDiseaseMarkerTesting()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.NoDiseaseMarkerTesting") );
				}

				/// <summary>
				/// NoDonationType class
				/// </summary>
				public static StringResourceItem NoDonationType()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.NoDonationType") );
				}

				/// <summary>
				/// NoPatientFound class
				/// </summary>
				public static StringResourceItem NoPatientFound()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.NoPatientFound") );
				}

				/// <summary>
				/// ProductCodeNoMatchShipmentType class
				/// </summary>
				public static StringResourceItem ProductCodeNoMatchShipmentType()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.ProductCodeNoMatchShipmentType") );
				}

				/// <summary>
				/// ProductNotActive class
				/// </summary>
				public static StringResourceItem ProductNotActive()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.ProductNotActive") );
				}
			}
			/// <summary>
			/// UC003 class
			/// </summary>
			public sealed class UC003
			{
				/// <summary>
				/// ChosenOrder class
				/// </summary>
				public static StringResourceItem ChosenOrder()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.ChosenOrder") );
				}

				/// <summary>
				/// CrossmatchError class
				/// </summary>
				public static StringResourceItem CrossmatchError()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.CrossmatchError") );
				}

				/// <summary>
				/// DateEntryError class
				/// </summary>
				public static StringResourceItem DateEntryError()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.DateEntryError") );
				}

				/// <summary>
				/// InvalidUnitRemoval class
				/// </summary>
				public static StringResourceItem InvalidUnitRemoval()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.InvalidUnitRemoval") );
				}
			}
			/// <summary>
			/// UC006 class
			/// </summary>
			public sealed class UC006
			{
				/// <summary>
				/// FacilityObjUpdateFailedDueToInvalidRowCount class
				/// </summary>
				public static StringResourceItem FacilityObjUpdateFailedDueToInvalidRowCount(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.FacilityObjUpdateFailedDueToInvalidRowCount"), arg0 );
				}
			}
			/// <summary>
			/// UC008 class
			/// </summary>
			public sealed class UC008
			{
				/// <summary>
				/// SupplierError class
				/// </summary>
				public static StringResourceItem SupplierError(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.SupplierError"), arg0 );
				}
			}
			/// <summary>
			/// UC011 class
			/// </summary>
			public sealed class UC011
			{
				/// <summary>
				/// AddError class
				/// </summary>
				public static StringResourceItem AddError()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.AddError") );
				}

				/// <summary>
				/// AddErrorDebug class
				/// </summary>
				public static StringResourceItem AddErrorDebug(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.AddErrorDebug"), arg0 );
				}

				/// <summary>
				/// InvalidData class
				/// </summary>
				public static StringResourceItem InvalidData()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.InvalidData") );
				}

				/// <summary>
				/// InvoiceAlreadyOpen class
				/// </summary>
				public static StringResourceItem InvoiceAlreadyOpen(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.InvoiceAlreadyOpen"), arg0 );
				}

				/// <summary>
				/// UnitOnPendingShipment class
				/// </summary>
				public static StringResourceItem UnitOnPendingShipment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.UnitOnPendingShipment") );
				}

				/// <summary>
				/// UpdateError class
				/// </summary>
				public static StringResourceItem UpdateError()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.UpdateError") );
				}

				/// <summary>
				/// UserNotAuthorized class
				/// </summary>
				public static StringResourceItem UserNotAuthorized()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.UserNotAuthorized") );
				}
			}
			/// <summary>
			/// UC013 class
			/// </summary>
			public sealed class UC013
			{
				/// <summary>
				/// NoPreviousStatus class
				/// </summary>
				public static StringResourceItem NoPreviousStatus()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC013.NoPreviousStatus") );
				}

				/// <summary>
				/// TransfusionOnlyDivision class
				/// </summary>
				public static StringResourceItem TransfusionOnlyDivision()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC013.TransfusionOnlyDivision") );
				}

				/// <summary>
				/// UnitHasActiveChildren class
				/// </summary>
				public static StringResourceItem UnitHasActiveChildren(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC013.UnitHasActiveChildren"), arg0 );
				}

				/// <summary>
				/// UnitNotInFinalStatus class
				/// </summary>
				public static StringResourceItem UnitNotInFinalStatus()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC013.UnitNotInFinalStatus") );
				}
			}
			/// <summary>
			/// UC017 class
			/// </summary>
			public sealed class UC017
			{
				/// <summary>
				/// InvoiceTextUpdateError class
				/// </summary>
				public static StringResourceItem InvoiceTextUpdateError()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC017.InvoiceTextUpdateError") );
				}
			}
			/// <summary>
			/// UC018 class
			/// </summary>
			public sealed class UC018
			{
				/// <summary>
				/// DuzMismatchDetected class
				/// </summary>
				public static StringResourceItem DuzMismatchDetected(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.DuzMismatchDetected"), arg0, arg1 );
				}

				/// <summary>
				/// NoActiveDivisionRolesConfigured class
				/// </summary>
				public static StringResourceItem NoActiveDivisionRolesConfigured()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.NoActiveDivisionRolesConfigured") );
				}

				/// <summary>
				/// NoDivisionsConfigured class
				/// </summary>
				public static StringResourceItem NoDivisionsConfigured()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.NoDivisionsConfigured") );
				}

				/// <summary>
				/// UserDivisionRoleInactivated class
				/// </summary>
				public static StringResourceItem UserDivisionRoleInactivated(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.UserDivisionRoleInactivated"), arg0 );
				}

				/// <summary>
				/// UserIsNotAMemberVbecsGroup class
				/// </summary>
				public static StringResourceItem UserIsNotAMemberVbecsGroup(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.UserIsNotAMemberVbecsGroup"), arg0 );
				}

				/// <summary>
				/// UserIsNotAuthorizedToAccessDivisionOrItDoesNotExist class
				/// </summary>
				public static StringResourceItem UserIsNotAuthorizedToAccessDivisionOrItDoesNotExist(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.UserIsNotAuthorizedToAccessDivisionOrItDoesNotExist"), arg0 );
				}

				/// <summary>
				/// UserNotFound class
				/// </summary>
				public static StringResourceItem UserNotFound()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.UserNotFound") );
				}

				/// <summary>
				/// UserRecordInactivated class
				/// </summary>
				public static StringResourceItem UserRecordInactivated()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.UserRecordInactivated") );
				}

				/// <summary>
				/// VbecsAdministratorIsRunningInTheSingleUserMode class
				/// </summary>
				public static StringResourceItem VbecsAdministratorIsRunningInTheSingleUserMode()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.VbecsAdministratorIsRunningInTheSingleUserMode") );
				}

				/// <summary>
				/// VbecsIsAlreadyRunning class
				/// </summary>
				public static StringResourceItem VbecsIsAlreadyRunning()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.VbecsIsAlreadyRunning") );
				}

				/// <summary>
				/// VbecsLogonError class
				/// </summary>
				public static StringResourceItem VbecsLogonError(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.VbecsLogonError"), arg0, arg1 );
				}

				/// <summary>
				/// VbecsUserDivisionNotFoundAmongVistADivisions class
				/// </summary>
				public static StringResourceItem VbecsUserDivisionNotFoundAmongVistADivisions(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.VbecsUserDivisionNotFoundAmongVistADivisions"), arg0 );
				}

				/// <summary>
				/// VbecsWindowsGroupDoesNotExist class
				/// </summary>
				public static StringResourceItem VbecsWindowsGroupDoesNotExist(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.VbecsWindowsGroupDoesNotExist"), arg0 );
				}

				/// <summary>
				/// VistALinkIsDown class
				/// </summary>
				public static StringResourceItem VistALinkIsDown()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.VistALinkIsDown") );
				}

				/// <summary>
				/// VistAServerLockedDueToTooManyLogonAttempts class
				/// </summary>
				public static StringResourceItem VistAServerLockedDueToTooManyLogonAttempts(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.VistAServerLockedDueToTooManyLogonAttempts"), arg0 );
				}
			}
			/// <summary>
			/// UC019 class
			/// </summary>
			public sealed class UC019
			{
				/// <summary>
				/// RemoveLastAdminUser class
				/// </summary>
				public static StringResourceItem RemoveLastAdminUser()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC019.RemoveLastAdminUser") );
				}

				/// <summary>
				/// RemoveLastAdminUserDivisions class
				/// </summary>
				public static StringResourceItem RemoveLastAdminUserDivisions(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC019.RemoveLastAdminUserDivisions"), arg0 );
				}
			}
			/// <summary>
			/// UC024 class
			/// </summary>
			public sealed class UC024
			{
				/// <summary>
				/// CannotRemoveAllOriginalUnits class
				/// </summary>
				public static StringResourceItem CannotRemoveAllOriginalUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.CannotRemoveAllOriginalUnits") );
				}

				/// <summary>
				/// PooledUnitAlreadyEdited class
				/// </summary>
				public static StringResourceItem PooledUnitAlreadyEdited()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.PooledUnitAlreadyEdited") );
				}
			}
			/// <summary>
			/// UC025 class
			/// </summary>
			public sealed class UC025
			{
				/// <summary>
				/// NotEnoughVolumeToSplit class
				/// </summary>
				public static StringResourceItem NotEnoughVolumeToSplit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC025.NotEnoughVolumeToSplit") );
				}

				/// <summary>
				/// UnitAlreadySplit class
				/// </summary>
				public static StringResourceItem UnitAlreadySplit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC025.UnitAlreadySplit") );
				}
			}
			/// <summary>
			/// UC026 class
			/// </summary>
			public sealed class UC026
			{
				/// <summary>
				/// BloodUnitNotModifiable class
				/// </summary>
				public static StringResourceItem BloodUnitNotModifiable()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.BloodUnitNotModifiable") );
				}

				/// <summary>
				/// DivisionNotSetupWithLocalSupplier class
				/// </summary>
				public static StringResourceItem DivisionNotSetupWithLocalSupplier()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.DivisionNotSetupWithLocalSupplier") );
				}
			}
			/// <summary>
			/// UC027 class
			/// </summary>
			public sealed class UC027
			{
				/// <summary>
				/// InconsistentUnitAboRh class
				/// </summary>
				public static StringResourceItem InconsistentUnitAboRh(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC027.InconsistentUnitAboRh"), arg0 );
				}

				/// <summary>
				/// InconsistentUnitAntigenTyping class
				/// </summary>
				public static StringResourceItem InconsistentUnitAntigenTyping(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC027.InconsistentUnitAntigenTyping"), arg0 );
				}

				/// <summary>
				/// UnitAlreadyQuarantined class
				/// </summary>
				public static StringResourceItem UnitAlreadyQuarantined(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC027.UnitAlreadyQuarantined"), arg0 );
				}

				/// <summary>
				/// UnitInFinalStatus class
				/// </summary>
				public static StringResourceItem UnitInFinalStatus(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC027.UnitInFinalStatus"), arg0, arg1 );
				}

				/// <summary>
				/// UnitNotQuarantined class
				/// </summary>
				public static StringResourceItem UnitNotQuarantined(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC027.UnitNotQuarantined"), arg0 );
				}
			}
			/// <summary>
			/// UC028 class
			/// </summary>
			public sealed class UC028
			{
				/// <summary>
				/// RackLocked class
				/// </summary>
				public static StringResourceItem RackLocked(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC028.RackLocked"), arg0 );
				}
			}
			/// <summary>
			/// UC035 class
			/// </summary>
			public sealed class UC035
			{
				/// <summary>
				/// NonMaintainableSpecimen class
				/// </summary>
				public static StringResourceItem NonMaintainableSpecimen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC035.NonMaintainableSpecimen") );
				}

				/// <summary>
				/// SpecimenForDifferentPatient class
				/// </summary>
				public static StringResourceItem SpecimenForDifferentPatient(object arg0, object arg1, object arg2, object arg3)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC035.SpecimenForDifferentPatient"), arg0, arg1, arg2, arg3 );
				}
			}
			/// <summary>
			/// UC036 class
			/// </summary>
			public sealed class UC036
			{
				/// <summary>
				/// PatientInformationLockedByUser class
				/// </summary>
				public static StringResourceItem PatientInformationLockedByUser(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC036.PatientInformationLockedByUser"), arg0 );
				}
			}
			/// <summary>
			/// UC038 class
			/// </summary>
			public sealed class UC038
			{
				/// <summary>
				/// CannotInactivateInOtherDivision class
				/// </summary>
				public static StringResourceItem CannotInactivateInOtherDivision()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC038.CannotInactivateInOtherDivision") );
				}

				/// <summary>
				/// CannotInactivateTestResult class
				/// </summary>
				public static StringResourceItem CannotInactivateTestResult()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC038.CannotInactivateTestResult") );
				}
			}
			/// <summary>
			/// UC040 class
			/// </summary>
			public sealed class UC040
			{
				/// <summary>
				/// InvalidEntry class
				/// </summary>
				public static StringResourceItem InvalidEntry()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC040.InvalidEntry") );
				}

				/// <summary>
				/// NotEligibleForISOnlyXMatch class
				/// </summary>
				public static StringResourceItem NotEligibleForISOnlyXMatch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC040.NotEligibleForISOnlyXMatch") );
				}
			}
			/// <summary>
			/// UC041 class
			/// </summary>
			public sealed class UC041
			{
				/// <summary>
				/// ControlCellsMustBeCompleted class
				/// </summary>
				public static StringResourceItem ControlCellsMustBeCompleted()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.ControlCellsMustBeCompleted") );
				}

				/// <summary>
				/// IssuedUnitTypingMismatch class
				/// </summary>
				public static StringResourceItem IssuedUnitTypingMismatch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.IssuedUnitTypingMismatch") );
				}

				/// <summary>
				/// UnitOnPendingAntiseraWorklist class
				/// </summary>
				public static StringResourceItem UnitOnPendingAntiseraWorklist(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.UnitOnPendingAntiseraWorklist"), arg0 );
				}

				/// <summary>
				/// WeakDRhPositive class
				/// </summary>
				public static StringResourceItem WeakDRhPositive()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.WeakDRhPositive") );
				}
			}
			/// <summary>
			/// UC043 class
			/// </summary>
			public sealed class UC043
			{
				/// <summary>
				/// CannotEmergencyIssue class
				/// </summary>
				public static StringResourceItem CannotEmergencyIssue()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.CannotEmergencyIssue") );
				}

				/// <summary>
				/// LabelPrinterNotConfigured class
				/// </summary>
				public static StringResourceItem LabelPrinterNotConfigured()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.LabelPrinterNotConfigured") );
				}

				/// <summary>
				/// PrinterProblem class
				/// </summary>
				public static StringResourceItem PrinterProblem()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.PrinterProblem") );
				}
			}
			/// <summary>
			/// UC052 class
			/// </summary>
			public sealed class UC052
			{
				/// <summary>
				/// InconclusiveABORhTyping class
				/// </summary>
				public static StringResourceItem InconclusiveABORhTyping()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC052.InconclusiveABORhTyping") );
				}
			}
			/// <summary>
			/// UC053 class
			/// </summary>
			public sealed class UC053
			{
				/// <summary>
				/// InvalidAntibodyScreen class
				/// </summary>
				public static StringResourceItem InvalidAntibodyScreen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC053.InvalidAntibodyScreen") );
				}

				/// <summary>
				/// InvalidInterpretation class
				/// </summary>
				public static StringResourceItem InvalidInterpretation()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC053.InvalidInterpretation") );
				}

				/// <summary>
				/// InvalidReactionCombination class
				/// </summary>
				public static StringResourceItem InvalidReactionCombination()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC053.InvalidReactionCombination") );
				}
			}
			/// <summary>
			/// UC054 class
			/// </summary>
			public sealed class UC054
			{
				/// <summary>
				/// InvalidEntry class
				/// </summary>
				public static StringResourceItem InvalidEntry()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC054.InvalidEntry") );
				}
			}
			/// <summary>
			/// UC056 class
			/// </summary>
			public sealed class UC056
			{
				/// <summary>
				/// ABOAndRhMustBeEntered class
				/// </summary>
				public static StringResourceItem ABOAndRhMustBeEntered()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.ABOAndRhMustBeEntered") );
				}

				/// <summary>
				/// ABORhTestNotPerformed class
				/// </summary>
				public static StringResourceItem ABORhTestNotPerformed()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.ABORhTestNotPerformed") );
				}

				/// <summary>
				/// EmergencyUnitsIssued class
				/// </summary>
				public static StringResourceItem EmergencyUnitsIssued()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.EmergencyUnitsIssued") );
				}

				/// <summary>
				/// UnfulfilledComponentRequirements class
				/// </summary>
				public static StringResourceItem UnfulfilledComponentRequirements()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.UnfulfilledComponentRequirements") );
				}
			}
			/// <summary>
			/// UC069 class
			/// </summary>
			public sealed class UC069
			{
				/// <summary>
				/// TransfusedVolumeExceeded class
				/// </summary>
				public static StringResourceItem TransfusedVolumeExceeded(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC069.TransfusedVolumeExceeded"), arg0 );
				}

				/// <summary>
				/// TransfusedVolumeTooLow class
				/// </summary>
				public static StringResourceItem TransfusedVolumeTooLow()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC069.TransfusedVolumeTooLow") );
				}
			}
			/// <summary>
			/// UC070 class
			/// </summary>
			public sealed class UC070
			{
				/// <summary>
				/// CannotInactivateUnit class
				/// </summary>
				public static StringResourceItem CannotInactivateUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC070.CannotInactivateUnit") );
				}

				/// <summary>
				/// CannotModifyUnit class
				/// </summary>
				public static StringResourceItem CannotModifyUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC070.CannotModifyUnit") );
				}

				/// <summary>
				/// InactivationCommentRequired class
				/// </summary>
				public static StringResourceItem InactivationCommentRequired()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC070.InactivationCommentRequired") );
				}

				/// <summary>
				/// UnitHasActiveTests class
				/// </summary>
				public static StringResourceItem UnitHasActiveTests()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC070.UnitHasActiveTests") );
				}

				/// <summary>
				/// UnitIsInFinalStatus class
				/// </summary>
				public static StringResourceItem UnitIsInFinalStatus()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC070.UnitIsInFinalStatus") );
				}
			}
			/// <summary>
			/// UC078 class
			/// </summary>
			public sealed class UC078
			{
				/// <summary>
				/// MedicalDirectorUnknown class
				/// </summary>
				public static StringResourceItem MedicalDirectorUnknown()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC078.MedicalDirectorUnknown") );
				}
			}
			/// <summary>
			/// UC082 class
			/// </summary>
			public sealed class UC082
			{
				/// <summary>
				/// EndDateError class
				/// </summary>
				public static StringResourceItem EndDateError()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC082.EndDateError") );
				}

				/// <summary>
				/// StartDateError class
				/// </summary>
				public static StringResourceItem StartDateError()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC082.StartDateError") );
				}
			}
			/// <summary>
			/// UC092 class
			/// </summary>
			public sealed class UC092
			{
				/// <summary>
				/// ABORhMismatch class
				/// </summary>
				public static StringResourceItem ABORhMismatch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC092.ABORhMismatch") );
				}

				/// <summary>
				/// SameTasksForPatient class
				/// </summary>
				public static StringResourceItem SameTasksForPatient()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC092.SameTasksForPatient") );
				}

				/// <summary>
				/// TaskLocked class
				/// </summary>
				public static StringResourceItem TaskLocked(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC092.TaskLocked"), arg0, arg1 );
				}
			}
			/// <summary>
			/// UnitTest class
			/// </summary>
			public sealed class UnitTest
			{
				/// <summary>
				/// TestString class
				/// </summary>
				public static StringResourceItem TestString(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UnitTest.TestString"), arg0, arg1 );
				}
			}
			/// <summary>
			/// VAL class
			/// </summary>
			public sealed class VAL
			{
				/// <summary>
				/// DTUInvalidNumberOfDataTablesFoundAfterXmlConversion class
				/// </summary>
				public static StringResourceItem DTUInvalidNumberOfDataTablesFoundAfterXmlConversion(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("VAL.DTUInvalidNumberOfDataTablesFoundAfterXmlConversion"), arg0 );
				}

				/// <summary>
				/// DTUNamedDataTableNotFoundAfterXmlConversion class
				/// </summary>
				public static StringResourceItem DTUNamedDataTableNotFoundAfterXmlConversion(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("VAL.DTUNamedDataTableNotFoundAfterXmlConversion"), arg0 );
				}
			}
			/// <summary>
			/// VistALink class
			/// </summary>
			public sealed class VistALink
			{
				/// <summary>
				/// Interupted class
				/// </summary>
				public static StringResourceItem Interupted()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("VistALink.Interupted") );
				}

				/// <summary>
				/// VistaLinkIsAlreadyInitialized class
				/// </summary>
				public static StringResourceItem VistaLinkIsAlreadyInitialized()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("VistALink.VistaLinkIsAlreadyInitialized") );
				}

				/// <summary>
				/// VistaLinkIsNotInitialized class
				/// </summary>
				public static StringResourceItem VistaLinkIsNotInitialized()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("VistALink.VistaLinkIsNotInitialized") );
				}
			}
		}

		/// <summary>
		/// ValidMsg class
		/// </summary>
		public sealed class ValidMsg
		{
			private const StringResourceType _classResType = StringResourceType.Validation;
			private static readonly ResourceManager _resourceManager = CreateResourceManagerInstance("ValidationMessages");

			private ValidMsg(){}
			static ValidMsg(){}	// get rid of "beforefieldinit" attribute (DON'T REMOVE!)


			/// <summary>
			/// Common class
			/// </summary>
			public sealed class Common
			{
                
				/// <summary>
				/// BloodUnitList class
				/// </summary>
				public static StringResourceItem BloodUnitList(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.BloodUnitList"), arg0 );
				}

				/// <summary>
				/// BR811InactivateSupplier class
				/// </summary>
				public static StringResourceItem BR811InactivateSupplier()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.BR811InactivateSupplier") );
				}

				/// <summary>
				/// CMVNegative class
				/// </summary>
				public static StringResourceItem CMVNegative()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.CMVNegative") );
				}

				/// <summary>
				/// DataGridAboRh class
				/// </summary>
				public static StringResourceItem DataGridAboRh()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DataGridAboRh") );
				}

				/// <summary>
				/// DataGridInvalidKey class
				/// </summary>
				public static StringResourceItem DataGridInvalidKey()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DataGridInvalidKey") );
				}

				/// <summary>
				/// DataGridInvalidKeyLngMsg class
				/// </summary>
				public static StringResourceItem DataGridInvalidKeyLngMsg()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DataGridInvalidKeyLngMsg") );
				}

				/// <summary>
				/// DlgSelectProvider class
				/// </summary>
				public static StringResourceItem DlgSelectProvider()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DlgSelectProvider") );
				}

				/// <summary>
				/// EnterValidIPAddress class
				/// </summary>
				public static StringResourceItem EnterValidIPAddress()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.EnterValidIPAddress") );
				}

				/// <summary>
				/// InvalidateTestResults class
				/// </summary>
				public static StringResourceItem InvalidateTestResults()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InvalidateTestResults") );
				}

				/// <summary>
				/// InvalidByteEnteredPleaseProvideValid class
				/// </summary>
				public static StringResourceItem InvalidByteEnteredPleaseProvideValid(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InvalidByteEnteredPleaseProvideValid"), arg0, arg1 );
				}

				/// <summary>
				/// InvalidIntegerEnteredPleaseProvideValid class
				/// </summary>
				public static StringResourceItem InvalidIntegerEnteredPleaseProvideValid()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InvalidIntegerEnteredPleaseProvideValid") );
				}

				/// <summary>
				/// InvalidKeyPressed class
				/// </summary>
				public static StringResourceItem InvalidKeyPressed()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InvalidKeyPressed") );
				}

				/// <summary>
				/// InvalidProductCodeFormat class
				/// </summary>
				public static StringResourceItem InvalidProductCodeFormat()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InvalidProductCodeFormat") );
				}

				/// <summary>
				/// InvalidUnitIdFormat class
				/// </summary>
				public static StringResourceItem InvalidUnitIdFormat()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InvalidUnitIdFormat") );
				}

				/// <summary>
				/// NoIntegerEnteredPleaseProvide class
				/// </summary>
				public static StringResourceItem NoIntegerEnteredPleaseProvide()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.NoIntegerEnteredPleaseProvide") );
				}

				/// <summary>
				/// SickleCellNegative class
				/// </summary>
				public static StringResourceItem SickleCellNegative()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SickleCellNegative") );
				}
			}
			/// <summary>
			/// MUC01 class
			/// </summary>
			public sealed class MUC01
			{
				/// <summary>
				/// InvalidIpAddress class
				/// </summary>
				public static StringResourceItem InvalidIpAddress()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.InvalidIpAddress") );
				}

				/// <summary>
				/// InvalidPortNumber class
				/// </summary>
				public static StringResourceItem InvalidPortNumber(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.InvalidPortNumber"), arg0, arg1 );
				}
			}
			/// <summary>
			/// UC001 class
			/// </summary>
			public sealed class UC001
			{
				/// <summary>
				/// BR137_RestrictPatient class
				/// </summary>
				public static StringResourceItem BR137_RestrictPatient()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.BR137.RestrictPatient") );
				}

				/// <summary>
				/// BR40UnitAlreadyExists class
				/// </summary>
				public static StringResourceItem BR40UnitAlreadyExists(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.BR40UnitAlreadyExists"), arg0, arg1 );
				}

				/// <summary>
				/// CheckCharacterWrong class
				/// </summary>
				public static StringResourceItem CheckCharacterWrong()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.CheckCharacterWrong") );
				}

				/// <summary>
				/// NoAuthorityToAddFacility class
				/// </summary>
				public static StringResourceItem NoAuthorityToAddFacility()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.NoAuthorityToAddFacility") );
				}

				/// <summary>
				/// UnitBeforePatient class
				/// </summary>
				public static StringResourceItem UnitBeforePatient()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.UnitBeforePatient") );
				}
			}
			/// <summary>
			/// UC002 class
			/// </summary>
			public sealed class UC002
			{
				/// <summary>
				/// BR07AboConfirmationRequired class
				/// </summary>
				public static StringResourceItem BR07AboConfirmationRequired(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC002.BR07AboConfirmationRequired"), arg0 );
				}

				/// <summary>
				/// BR07RhConfirmationRequiredForRhNeg class
				/// </summary>
				public static StringResourceItem BR07RhConfirmationRequiredForRhNeg(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC002.BR07RhConfirmationRequiredForRhNeg"), arg0 );
				}

				/// <summary>
				/// InvalidResults class
				/// </summary>
				public static StringResourceItem InvalidResults(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC002.InvalidResults"), arg0 );
				}

				/// <summary>
				/// UnitNotCorrectProductType class
				/// </summary>
				public static StringResourceItem UnitNotCorrectProductType(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC002.UnitNotCorrectProductType"), arg0, arg1 );
				}
			}
			/// <summary>
			/// UC003 class
			/// </summary>
			public sealed class UC003
			{
				/// <summary>
				/// AlreadySelectedForThisPatient class
				/// </summary>
				public static StringResourceItem AlreadySelectedForThisPatient()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.AlreadySelectedForThisPatient") );
				}

				/// <summary>
				/// BadStatus class
				/// </summary>
				public static StringResourceItem BadStatus(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BadStatus"), arg0 );
				}

				/// <summary>
				/// BR301Specimen class
				/// </summary>
				public static StringResourceItem BR301Specimen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR301Specimen") );
				}

				/// <summary>
				/// BR305NoABORhResults class
				/// </summary>
				public static StringResourceItem BR305NoABORhResults()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR305NoABORhResults") );
				}

				/// <summary>
				/// BR305NoABORhResultsInSameDivision class
				/// </summary>
				public static StringResourceItem BR305NoABORhResultsInSameDivision()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR305NoABORhResultsInSameDivision") );
				}

				/// <summary>
				/// BR306Antibody class
				/// </summary>
				public static StringResourceItem BR306Antibody(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR306Antibody"), arg0, arg1 );
				}

				/// <summary>
				/// BR306AntibodyOverride class
				/// </summary>
				public static StringResourceItem BR306AntibodyOverride(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR306AntibodyOverride"), arg0, arg1 );
				}

				/// <summary>
				/// BR306Antigen class
				/// </summary>
				public static StringResourceItem BR306Antigen(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR306Antigen"), arg0, arg1 );
				}

				/// <summary>
				/// BR306AntigenOverride class
				/// </summary>
				public static StringResourceItem BR306AntigenOverride(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR306AntigenOverride"), arg0, arg1 );
				}

				/// <summary>
				/// BR310 class
				/// </summary>
				public static StringResourceItem BR310()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR310") );
				}

				/// <summary>
				/// BR310Override class
				/// </summary>
				public static StringResourceItem BR310Override()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR310Override") );
				}

				/// <summary>
				/// BR311NoABORhResults class
				/// </summary>
				public static StringResourceItem BR311NoABORhResults()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR311NoABORhResults") );
				}

				/// <summary>
				/// BR312UnitFrozen class
				/// </summary>
				public static StringResourceItem BR312UnitFrozen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR312UnitFrozen") );
				}

				/// <summary>
				/// BR312UnitFrozenEmergencyIssue class
				/// </summary>
				public static StringResourceItem BR312UnitFrozenEmergencyIssue()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR312UnitFrozenEmergencyIssue") );
				}

				/// <summary>
				/// BR313AlreadySelected class
				/// </summary>
				public static StringResourceItem BR313AlreadySelected()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR313AlreadySelected") );
				}

				/// <summary>
				/// BR314TransfusionRequirements class
				/// </summary>
				public static StringResourceItem BR314TransfusionRequirements(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR314TransfusionRequirements"), arg0 );
				}

				/// <summary>
				/// BR315UnitNotTyped class
				/// </summary>
				public static StringResourceItem BR315UnitNotTyped(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR315UnitNotTyped"), arg0 );
				}

				/// <summary>
				/// BR316ABORhConfirmation class
				/// </summary>
				public static StringResourceItem BR316ABORhConfirmation()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR316ABORhConfirmation") );
				}

				/// <summary>
				/// BR319UnitExpired class
				/// </summary>
				public static StringResourceItem BR319UnitExpired()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR319UnitExpired") );
				}

				/// <summary>
				/// BR319UnitExpiredOverride class
				/// </summary>
				public static StringResourceItem BR319UnitExpiredOverride()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR319UnitExpiredOverride") );
				}

				/// <summary>
				/// BR319UnitNotInSameDivision class
				/// </summary>
				public static StringResourceItem BR319UnitNotInSameDivision()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR319UnitNotInSameDivision") );
				}

				/// <summary>
				/// BR321 class
				/// </summary>
				public static StringResourceItem BR321()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR321") );
				}

				/// <summary>
				/// BR323UnitIncompatible class
				/// </summary>
				public static StringResourceItem BR323UnitIncompatible()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR323UnitIncompatible") );
				}

				/// <summary>
				/// BR324ABORhConfirmation class
				/// </summary>
				public static StringResourceItem BR324ABORhConfirmation(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR324ABORhConfirmation"), arg0 );
				}

				/// <summary>
				/// BR328AssignedToAnotherPatient class
				/// </summary>
				public static StringResourceItem BR328AssignedToAnotherPatient()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR328AssignedToAnotherPatient") );
				}

				/// <summary>
				/// BR330SpecimenResults class
				/// </summary>
				public static StringResourceItem BR330SpecimenResults()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR330SpecimenResults") );
				}

				/// <summary>
				/// BR332CMVNegRequired class
				/// </summary>
				public static StringResourceItem BR332CMVNegRequired()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR332CMVNegRequired") );
				}

				/// <summary>
				/// BR332CMVNegRequiredOverride class
				/// </summary>
				public static StringResourceItem BR332CMVNegRequiredOverride()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR332CMVNegRequiredOverride") );
				}

                /// <summary>
                /// BR332SickleCellAndCMVNegRequired class
                ///</summary>
                public static StringResourceItem BR332SickleCellAndCMVNegRequired()
                {
                    return GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR332SickleCellAndCMVNegRequired"));
                }
                
                /// <summary>
                /// BR332SickleCellAndCMVNegRequiredOverride class
                /// </summary>
                public static StringResourceItem BR332SickleCellAndCMVNegRequiredOverride()
                {
                    return GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR332SickleCellAndCMVNegRequiredOverride"));
                }

                /// <summary>
                /// BR332SickleCellNegRequired class
                /// </summary>
                public static StringResourceItem BR332SickleCellNegRequired()
                {
                    return GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR332SickleCellNegRequired"));
                }

                /// <summary>
                /// BR332SickleCellRequiredOverride class
                /// </summary>
                public static StringResourceItem BR332SickleCellNegRequiredOverride()
                {
                    return GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR332SickleCellNegRequiredOverride"));
                }

                /// <summary>
				/// BR333InvalidProductType class
				/// </summary>
				public static StringResourceItem BR333InvalidProductType()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR333InvalidProductType") );
				}

				/// <summary>
				/// BR334RestrictiveUnits class
				/// </summary>
				public static StringResourceItem BR334RestrictiveUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR334RestrictiveUnits") );
				}

				/// <summary>
				/// BR339BiohazardousWarningIndicator class
				/// </summary>
				public static StringResourceItem BR339BiohazardousWarningIndicator()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR339BiohazardousWarningIndicator") );
				}

				/// <summary>
				/// BR340SpecimenResults class
				/// </summary>
				public static StringResourceItem BR340SpecimenResults()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR340SpecimenResults") );
				}

				/// <summary>
				/// BR343UnitQuarantined class
				/// </summary>
				public static StringResourceItem BR343UnitQuarantined()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR343UnitQuarantined") );
				}

				/// <summary>
				/// BR344NotInBloodBank class
				/// </summary>
				public static StringResourceItem BR344NotInBloodBank()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR344NotInBloodBank") );
				}

				/// <summary>
				/// BR345OutgoingShipment class
				/// </summary>
				public static StringResourceItem BR345OutgoingShipment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR345OutgoingShipment") );
				}

				/// <summary>
				/// BR346UnitRestricted class
				/// </summary>
				public static StringResourceItem BR346UnitRestricted()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR346UnitRestricted") );
				}

				/// <summary>
				/// BR352JustifiedABORh class
				/// </summary>
				public static StringResourceItem BR352JustifiedABORh()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.BR352JustifiedABORh") );
				}

				/// <summary>
				/// MustEmergencyIssue class
				/// </summary>
				public static StringResourceItem MustEmergencyIssue()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.MustEmergencyIssue") );
				}

				/// <summary>
				/// UnitNotCompatible class
				/// </summary>
				public static StringResourceItem UnitNotCompatible()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.UnitNotCompatible") );
				}
			}
			/// <summary>
			/// UC005 class
			/// </summary>
			public sealed class UC005
			{
				/// <summary>
				/// InvalidSource class
				/// </summary>
				public static StringResourceItem InvalidSource()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC005.InvalidSource") );
				}

				/// <summary>
				/// InvalidSourceCol class
				/// </summary>
				public static StringResourceItem InvalidSourceCol()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC005.InvalidSourceCol") );
				}
			}
			/// <summary>
			/// UC018 class
			/// </summary>
			public sealed class UC018
			{
				/// <summary>
				/// SomeApplicationFormsAreOpen class
				/// </summary>
				public static StringResourceItem SomeApplicationFormsAreOpen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.SomeApplicationFormsAreOpen") );
				}
			}
			/// <summary>
			/// UC024 class
			/// </summary>
			public sealed class UC024
			{
				/// <summary>
				/// BR02ComponentType class
				/// </summary>
				public static StringResourceItem BR02ComponentType(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.BR02ComponentType"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// BR05CantPoolASplit class
				/// </summary>
				public static StringResourceItem BR05CantPoolASplit(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.BR05CantPoolASplit"), arg0, arg1 );
				}

				/// <summary>
				/// BR12PooledIdExists class
				/// </summary>
				public static StringResourceItem BR12PooledIdExists(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.BR12PooledIdExists"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// BR15DonationType class
				/// </summary>
				public static StringResourceItem BR15DonationType(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.BR15DonationType"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// BR16DifferentPatient class
				/// </summary>
				public static StringResourceItem BR16DifferentPatient(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.BR16DifferentPatient"), arg0, arg1 );
				}

				/// <summary>
				/// BR17Autologous class
				/// </summary>
				public static StringResourceItem BR17Autologous(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.BR17Autologous"), arg0, arg1 );
				}

				/// <summary>
				/// BR17NoDirectionPatients class
				/// </summary>
				public static StringResourceItem BR17NoDirectionPatients(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.BR17NoDirectionPatients"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// BR25ExpirationDate class
				/// </summary>
				public static StringResourceItem BR25ExpirationDate()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.BR25ExpirationDate") );
				}

				/// <summary>
				/// BR28AddingUnitWillChangeTarget class
				/// </summary>
				public static StringResourceItem BR28AddingUnitWillChangeTarget(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.BR28AddingUnitWillChangeTarget"), arg0, arg1 );
				}
			}
			/// <summary>
			/// UC026 class
			/// </summary>
			public sealed class UC026
			{
				/// <summary>
				/// BR1_40 class
				/// </summary>
				public static StringResourceItem BR1_40(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.BR1_40"), arg0, arg1 );
				}

				/// <summary>
				/// BR21TargetDateRange class
				/// </summary>
				public static StringResourceItem BR21TargetDateRange(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.BR21TargetDateRange"), arg0, arg1 );
				}

				/// <summary>
				/// BR25PatientAssignmentPool class
				/// </summary>
				public static StringResourceItem BR25PatientAssignmentPool()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.BR25PatientAssignmentPool") );
				}

				/// <summary>
				/// BR25PatientAssignmentSingle class
				/// </summary>
				public static StringResourceItem BR25PatientAssignmentSingle()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.BR25PatientAssignmentSingle") );
				}

				/// <summary>
				/// BR28ExpirationDateOutOfRange class
				/// </summary>
				public static StringResourceItem BR28ExpirationDateOutOfRange(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.BR28ExpirationDateOutOfRange"), arg0, arg1 );
				}

				/// <summary>
				/// BR29VerifyLabelElementFailed class
				/// </summary>
				public static StringResourceItem BR29VerifyLabelElementFailed(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.BR29VerifyLabelElementFailed"), arg0 );
				}

				/// <summary>
				/// BR29VerifyLabelElementNotEntered class
				/// </summary>
				public static StringResourceItem BR29VerifyLabelElementNotEntered(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.BR29VerifyLabelElementNotEntered"), arg0 );
				}

				/// <summary>
				/// BR29VerifyLabelInvalid class
				/// </summary>
				public static StringResourceItem BR29VerifyLabelInvalid()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.BR29VerifyLabelInvalid") );
				}

				/// <summary>
				/// BR33InvalidUnitStatus class
				/// </summary>
				public static StringResourceItem BR33InvalidUnitStatus(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.BR33InvalidUnitStatus"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// BR36InvalidUnit class
				/// </summary>
				public static StringResourceItem BR36InvalidUnit(object arg0, object arg1, object arg2)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.BR36InvalidUnit"), arg0, arg1, arg2 );
				}

				/// <summary>
				/// BR3ExpiredUnit class
				/// </summary>
				public static StringResourceItem BR3ExpiredUnit(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.BR3ExpiredUnit"), arg0, arg1 );
				}

				/// <summary>
				/// BR42Biohazard class
				/// </summary>
				public static StringResourceItem BR42Biohazard(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.BR42Biohazard"), arg0, arg1 );
				}

				/// <summary>
				/// BR45UnsatisfactorySupply class
				/// </summary>
				public static StringResourceItem BR45UnsatisfactorySupply()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.BR45UnsatisfactorySupply") );
				}

				/// <summary>
				/// BR4ExpiredUnit class
				/// </summary>
				public static StringResourceItem BR4ExpiredUnit(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.BR4ExpiredUnit"), arg0, arg1 );
				}

				/// <summary>
				/// BR5QuarantineUnit class
				/// </summary>
				public static StringResourceItem BR5QuarantineUnit(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.BR5QuarantineUnit"), arg0, arg1 );
				}

				/// <summary>
				/// BR6QuarantineUnit class
				/// </summary>
				public static StringResourceItem BR6QuarantineUnit(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.BR6QuarantineUnit"), arg0, arg1 );
				}

				/// <summary>
				/// BR7ABORh class
				/// </summary>
				public static StringResourceItem BR7ABORh(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.BR7ABORh"), arg0, arg1 );
				}

				/// <summary>
				/// BR8ModificationDate class
				/// </summary>
				public static StringResourceItem BR8ModificationDate()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.BR8ModificationDate") );
				}

				/// <summary>
				/// DivisionNotSetupToContinue class
				/// </summary>
				public static StringResourceItem DivisionNotSetupToContinue()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.DivisionNotSetupToContinue") );
				}
			}
			/// <summary>
			/// UC027 class
			/// </summary>
			public sealed class UC027
			{
				/// <summary>
				/// BR13UnitNotFound class
				/// </summary>
				public static StringResourceItem BR13UnitNotFound()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC027.BR13UnitNotFound") );
				}
			}
			/// <summary>
			/// UC041 class
			/// </summary>
			public sealed class UC041
			{
				/// <summary>
				/// AntigenTypingWeakD class
				/// </summary>
				public static StringResourceItem AntigenTypingWeakD()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.AntigenTypingWeakD") );
				}

				/// <summary>
				/// AntiseraExpire class
				/// </summary>
				public static StringResourceItem AntiseraExpire()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.AntiseraExpire") );
				}
			}
			/// <summary>
			/// UC045 class
			/// </summary>
			public sealed class UC045
			{
				/// <summary>
				/// BR10CrossmatchTestsAndSpecimen class
				/// </summary>
				public static StringResourceItem BR10CrossmatchTestsAndSpecimen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC045.BR10CrossmatchTestsAndSpecimen") );
				}

				/// <summary>
				/// BR12WeakDTestRHPositivePatient class
				/// </summary>
				public static StringResourceItem BR12WeakDTestRHPositivePatient()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC045.BR12WeakDTestRHPositivePatient") );
				}
			}
			/// <summary>
			/// UC046 class
			/// </summary>
			public sealed class UC046
			{
				/// <summary>
				/// StartDateMustBePriorToEndDate class
				/// </summary>
				public static StringResourceItem StartDateMustBePriorToEndDate()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC046.StartDateMustBePriorToEndDate") );
				}
			}
			/// <summary>
			/// UC059 class
			/// </summary>
			public sealed class UC059
			{
				/// <summary>
				/// UnitNotIssued class
				/// </summary>
				public static StringResourceItem UnitNotIssued()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC059.UnitNotIssued") );
				}

				/// <summary>
				/// UnitReturnedAfter30Minutes class
				/// </summary>
				public static StringResourceItem UnitReturnedAfter30Minutes()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC059.UnitReturnedAfter30Minutes") );
				}
			}
			/// <summary>
			/// UC1 class
			/// </summary>
			public sealed class UC1
			{
				/// <summary>
				/// BR101_ProductInactive class
				/// </summary>
				public static StringResourceItem BR101_ProductInactive()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC1.BR101.ProductInactive") );
				}
			}
			/// <summary>
			/// UC102 class
			/// </summary>
			public sealed class UC102
			{
				/// <summary>
				/// NewVerifyCodesDoNotMatch class
				/// </summary>
				public static StringResourceItem NewVerifyCodesDoNotMatch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.NewVerifyCodesDoNotMatch") );
				}

				/// <summary>
				/// OnlyOneDelimiterMayBeEntered class
				/// </summary>
				public static StringResourceItem OnlyOneDelimiterMayBeEntered(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.OnlyOneDelimiterMayBeEntered"), arg0 );
				}
			}
			/// <summary>
			/// UnitTest class
			/// </summary>
			public sealed class UnitTest
			{
				/// <summary>
				/// TestString class
				/// </summary>
				public static StringResourceItem TestString(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UnitTest.TestString"), arg0, arg1 );
				}
			}
		}

		/// <summary>
		/// Tooltips class
		/// </summary>
		public sealed class Tooltips
		{
			private const StringResourceType _classResType = StringResourceType.Tooltip;
			private static readonly ResourceManager _resourceManager = CreateResourceManagerInstance("Tooltips");

			private Tooltips(){}
			static Tooltips(){}	// get rid of "beforefieldinit" attribute (DON'T REMOVE!)


			/// <summary>
			/// Common class
			/// </summary>
			public sealed class Common
			{
				/// <summary>
				/// AddOrUpdate class
				/// </summary>
				public static StringResourceItem AddOrUpdate(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.AddOrUpdate"), arg0 );
				}

				/// <summary>
				/// AntiseraExpDate class
				/// </summary>
				public static StringResourceItem AntiseraExpDate()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.AntiseraExpDate") );
				}

				/// <summary>
				/// AntiseraLot class
				/// </summary>
				public static StringResourceItem AntiseraLot()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.AntiseraLot") );
				}

				/// <summary>
				/// AntiseraOverrideComment class
				/// </summary>
				public static StringResourceItem AntiseraOverrideComment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.AntiseraOverrideComment") );
				}

				/// <summary>
				/// AntiseraRack class
				/// </summary>
				public static StringResourceItem AntiseraRack()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.AntiseraRack") );
				}

				/// <summary>
				/// AntiseraReagent class
				/// </summary>
				public static StringResourceItem AntiseraReagent()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.AntiseraReagent") );
				}

				/// <summary>
				/// AntiseraRemove class
				/// </summary>
				public static StringResourceItem AntiseraRemove()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.AntiseraRemove") );
				}

				/// <summary>
				/// AntisersEnterComment class
				/// </summary>
				public static StringResourceItem AntisersEnterComment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.AntisersEnterComment") );
				}

				/// <summary>
				/// ButtonBloodAvailability class
				/// </summary>
				public static StringResourceItem ButtonBloodAvailability()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ButtonBloodAvailability") );
				}

				/// <summary>
				/// ButtonCurrentMeds class
				/// </summary>
				public static StringResourceItem ButtonCurrentMeds()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ButtonCurrentMeds") );
				}

				/// <summary>
				/// ButtonRecentOrders class
				/// </summary>
				public static StringResourceItem ButtonRecentOrders()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ButtonRecentOrders") );
				}

				/// <summary>
				/// ButtonRecentTransfusionsIssues class
				/// </summary>
				public static StringResourceItem ButtonRecentTransfusionsIssues()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ButtonRecentTransfusionsIssues") );
				}

				/// <summary>
				/// ButtonSpecialInstructions class
				/// </summary>
				public static StringResourceItem ButtonSpecialInstructions()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ButtonSpecialInstructions") );
				}

				/// <summary>
				/// ButtonTransfusionReactionHistory class
				/// </summary>
				public static StringResourceItem ButtonTransfusionReactionHistory()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ButtonTransfusionReactionHistory") );
				}

				/// <summary>
				/// Cancel class
				/// </summary>
				public static StringResourceItem Cancel()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.Cancel") );
				}

				/// <summary>
				/// CheckOneItem class
				/// </summary>
				public static StringResourceItem CheckOneItem(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.CheckOneItem"), arg0 );
				}

				/// <summary>
				/// ClearChangesAndResetScreen class
				/// </summary>
				public static StringResourceItem ClearChangesAndResetScreen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ClearChangesAndResetScreen") );
				}

				/// <summary>
				/// ClearEntries class
				/// </summary>
				public static StringResourceItem ClearEntries()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ClearEntries") );
				}

				/// <summary>
				/// ClearResults class
				/// </summary>
				public static StringResourceItem ClearResults()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ClearResults") );
				}

				/// <summary>
				/// ClickToDisregardChangesAndReturn class
				/// </summary>
				public static StringResourceItem ClickToDisregardChangesAndReturn()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ClickToDisregardChangesAndReturn") );
				}

				/// <summary>
				/// Close class
				/// </summary>
				public static StringResourceItem Close()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.Close") );
				}

				/// <summary>
				/// CommentRequired class
				/// </summary>
				public static StringResourceItem CommentRequired()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.CommentRequired") );
				}

				/// <summary>
				/// CommentRequiredWithOther class
				/// </summary>
				public static StringResourceItem CommentRequiredWithOther()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.CommentRequiredWithOther") );
				}

				/// <summary>
				/// DataWasNotChanged class
				/// </summary>
				public static StringResourceItem DataWasNotChanged()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DataWasNotChanged") );
				}

				/// <summary>
				/// DataWasNotSavedBecauseOfRowversionViolation class
				/// </summary>
				public static StringResourceItem DataWasNotSavedBecauseOfRowversionViolation()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DataWasNotSavedBecauseOfRowversionViolation") );
				}

				/// <summary>
				/// DeselectAll class
				/// </summary>
				public static StringResourceItem DeselectAll()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DeselectAll") );
				}

				/// <summary>
				/// EnterAComment class
				/// </summary>
				public static StringResourceItem EnterAComment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.EnterAComment") );
				}

				/// <summary>
				/// EnterRequiredData class
				/// </summary>
				public static StringResourceItem EnterRequiredData()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.EnterRequiredData") );
				}

				/// <summary>
				/// EnterSearchCriteria class
				/// </summary>
				public static StringResourceItem EnterSearchCriteria()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.EnterSearchCriteria") );
				}

				/// <summary>
				/// ExpiredLock class
				/// </summary>
				public static StringResourceItem ExpiredLock()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ExpiredLock") );
				}

				/// <summary>
				/// InterpretationNotMatch class
				/// </summary>
				public static StringResourceItem InterpretationNotMatch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InterpretationNotMatch") );
				}

				/// <summary>
				/// InvalidateTestResults class
				/// </summary>
				public static StringResourceItem InvalidateTestResults()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InvalidateTestResults") );
				}

				/// <summary>
				/// InvalidDControl class
				/// </summary>
				public static StringResourceItem InvalidDControl()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InvalidDControl") );
				}

				/// <summary>
				/// InvalidTestResults class
				/// </summary>
				public static StringResourceItem InvalidTestResults()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.InvalidTestResults") );
				}

				/// <summary>
				/// LostAccess class
				/// </summary>
				public static StringResourceItem LostAccess()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.LostAccess") );
				}

				/// <summary>
				/// ManufacturerAddress1 class
				/// </summary>
				public static StringResourceItem ManufacturerAddress1()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ManufacturerAddress1") );
				}

				/// <summary>
				/// ManufacturerAddress2 class
				/// </summary>
				public static StringResourceItem ManufacturerAddress2()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ManufacturerAddress2") );
				}

				/// <summary>
				/// ManufacturerCity class
				/// </summary>
				public static StringResourceItem ManufacturerCity()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ManufacturerCity") );
				}

				/// <summary>
				/// ManufacturerName class
				/// </summary>
				public static StringResourceItem ManufacturerName()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ManufacturerName") );
				}

				/// <summary>
				/// ManufacturerPhone class
				/// </summary>
				public static StringResourceItem ManufacturerPhone()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ManufacturerPhone") );
				}

				/// <summary>
				/// ManufacturerState class
				/// </summary>
				public static StringResourceItem ManufacturerState()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ManufacturerState") );
				}

				/// <summary>
				/// ManufacturerZip class
				/// </summary>
				public static StringResourceItem ManufacturerZip()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ManufacturerZip") );
				}

				/// <summary>
				/// NextPatient class
				/// </summary>
				public static StringResourceItem NextPatient()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.NextPatient") );
				}

				/// <summary>
				/// NoChangesToAddOrUpdate class
				/// </summary>
				public static StringResourceItem NoChangesToAddOrUpdate()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.NoChangesToAddOrUpdate") );
				}

				/// <summary>
				/// NoChangesToSave class
				/// </summary>
				public static StringResourceItem NoChangesToSave()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.NoChangesToSave") );
				}

				/// <summary>
				/// NoUnitsSelected class
				/// </summary>
				public static StringResourceItem NoUnitsSelected()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.NoUnitsSelected") );
				}

				/// <summary>
				/// OKToContinue class
				/// </summary>
				public static StringResourceItem OKToContinue()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.OKToContinue") );
				}

				/// <summary>
				/// OKToProceed class
				/// </summary>
				public static StringResourceItem OKToProceed()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.OKToProceed") );
				}

				/// <summary>
				/// OKToSave class
				/// </summary>
				public static StringResourceItem OKToSave()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.OKToSave") );
				}

				/// <summary>
				/// PatientBood class
				/// </summary>
				public static StringResourceItem PatientBood()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PatientBood") );
				}

				/// <summary>
				/// PatientDOB class
				/// </summary>
				public static StringResourceItem PatientDOB()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PatientDOB") );
				}

				/// <summary>
				/// PatientGender class
				/// </summary>
				public static StringResourceItem PatientGender()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PatientGender") );
				}

				/// <summary>
				/// PatientName class
				/// </summary>
				public static StringResourceItem PatientName()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PatientName") );
				}

				/// <summary>
				/// PatientSearch class
				/// </summary>
				public static StringResourceItem PatientSearch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PatientSearch") );
				}

				/// <summary>
				/// PatientSelect class
				/// </summary>
				public static StringResourceItem PatientSelect()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PatientSelect") );
				}

				/// <summary>
				/// PatientSpecimenSearch class
				/// </summary>
				public static StringResourceItem PatientSpecimenSearch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PatientSpecimenSearch") );
				}

				/// <summary>
				/// PatientSsn class
				/// </summary>
				public static StringResourceItem PatientSsn()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PatientSsn") );
				}

				/// <summary>
				/// PreviousPatient class
				/// </summary>
				public static StringResourceItem PreviousPatient()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PreviousPatient") );
				}

				/// <summary>
				/// Print class
				/// </summary>
				public static StringResourceItem Print()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.Print") );
				}

				/// <summary>
				/// PrinterName class
				/// </summary>
				public static StringResourceItem PrinterName(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PrinterName"), arg0 );
				}

				/// <summary>
				/// RackNotConfigured class
				/// </summary>
				public static StringResourceItem RackNotConfigured()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.RackNotConfigured") );
				}

				/// <summary>
				/// SchedulePrint class
				/// </summary>
				public static StringResourceItem SchedulePrint()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SchedulePrint") );
				}

				/// <summary>
				/// SearchFor class
				/// </summary>
				public static StringResourceItem SearchFor()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SearchFor") );
				}

				/// <summary>
				/// SearchResults class
				/// </summary>
				public static StringResourceItem SearchResults(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SearchResults"), arg0 );
				}

				/// <summary>
				/// SelectAll class
				/// </summary>
				public static StringResourceItem SelectAll()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SelectAll") );
				}

				/// <summary>
				/// SelectBloodProduct class
				/// </summary>
				public static StringResourceItem SelectBloodProduct()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SelectBloodProduct") );
				}

				/// <summary>
				/// SelectBloodUnit class
				/// </summary>
				public static StringResourceItem SelectBloodUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SelectBloodUnit") );
				}

				/// <summary>
				/// SelectOneItem class
				/// </summary>
				public static StringResourceItem SelectOneItem(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SelectOneItem"), arg0 );
				}

				/// <summary>
				/// SelectPatient class
				/// </summary>
				public static StringResourceItem SelectPatient()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SelectPatient") );
				}

				/// <summary>
				/// SelectPrinter class
				/// </summary>
				public static StringResourceItem SelectPrinter()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SelectPrinter") );
				}

				/// <summary>
				/// SelectSpecimen class
				/// </summary>
				public static StringResourceItem SelectSpecimen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SelectSpecimen") );
				}

				/// <summary>
				/// SelectUnit class
				/// </summary>
				public static StringResourceItem SelectUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SelectUnit") );
				}

				/// <summary>
				/// ShowInactive class
				/// </summary>
				public static StringResourceItem ShowInactive(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.ShowInactive"), arg0 );
				}
			}
			/// <summary>
			/// MUC01 class
			/// </summary>
			public sealed class MUC01
			{
				/// <summary>
				/// ClickToSaveConfig class
				/// </summary>
				public static StringResourceItem ClickToSaveConfig()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.ClickToSaveConfig") );
				}

				/// <summary>
				/// ClickToTestConfig class
				/// </summary>
				public static StringResourceItem ClickToTestConfig()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.ClickToTestConfig") );
				}

				/// <summary>
				/// ConfigWasNotChanged class
				/// </summary>
				public static StringResourceItem ConfigWasNotChanged()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.ConfigWasNotChanged") );
				}

				/// <summary>
				/// ConfigWasNotTestedAfterChange class
				/// </summary>
				public static StringResourceItem ConfigWasNotTestedAfterChange()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.ConfigWasNotTestedAfterChange") );
				}

				/// <summary>
				/// ConnectionTestFailed class
				/// </summary>
				public static StringResourceItem ConnectionTestFailed()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.ConnectionTestFailed") );
				}

				/// <summary>
				/// UnableToTestSinceConfigIsInvalid class
				/// </summary>
				public static StringResourceItem UnableToTestSinceConfigIsInvalid()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.UnableToTestSinceConfigIsInvalid") );
				}

				/// <summary>
				/// VistALinkConfigIsBeingTested class
				/// </summary>
				public static StringResourceItem VistALinkConfigIsBeingTested()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.VistALinkConfigIsBeingTested") );
				}

				/// <summary>
				/// VistALinkConfigTestSucceeded class
				/// </summary>
				public static StringResourceItem VistALinkConfigTestSucceeded()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.VistALinkConfigTestSucceeded") );
				}

				/// <summary>
				/// VistALinkConfigWasNotTested class
				/// </summary>
				public static StringResourceItem VistALinkConfigWasNotTested()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC01.VistALinkConfigWasNotTested") );
				}
			}
			/// <summary>
			/// MUC02 class
			/// </summary>
			public sealed class MUC02
			{
				/// <summary>
				/// CheckToDisplayInactive class
				/// </summary>
				public static StringResourceItem CheckToDisplayInactive()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.CheckToDisplayInactive") );
				}

				/// <summary>
				/// CheckUsesLabelPrinter class
				/// </summary>
				public static StringResourceItem CheckUsesLabelPrinter()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.CheckUsesLabelPrinter") );
				}

				/// <summary>
				/// ClickToCancel class
				/// </summary>
				public static StringResourceItem ClickToCancel()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.ClickToCancel") );
				}

				/// <summary>
				/// ClickToCancelVistaDivisionSelection class
				/// </summary>
				public static StringResourceItem ClickToCancelVistaDivisionSelection()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.ClickToCancelVistaDivisionSelection") );
				}

				/// <summary>
				/// ClickToSearchDivision class
				/// </summary>
				public static StringResourceItem ClickToSearchDivision()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.ClickToSearchDivision") );
				}

				/// <summary>
				/// ClickToSearchFacility class
				/// </summary>
				public static StringResourceItem ClickToSearchFacility()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.ClickToSearchFacility") );
				}

				/// <summary>
				/// ClickToSelectVistaDivision class
				/// </summary>
				public static StringResourceItem ClickToSelectVistaDivision()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.ClickToSelectVistaDivision") );
				}

				/// <summary>
				/// EnterCustomDstEnd class
				/// </summary>
				public static StringResourceItem EnterCustomDstEnd()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.EnterCustomDstEnd") );
				}

				/// <summary>
				/// EnterCustomDstStart class
				/// </summary>
				public static StringResourceItem EnterCustomDstStart()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.EnterCustomDstStart") );
				}

				/// <summary>
				/// EnterLabelPrinterComPortNumber class
				/// </summary>
				public static StringResourceItem EnterLabelPrinterComPortNumber()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.EnterLabelPrinterComPortNumber") );
				}

				/// <summary>
				/// EnterLabelPrinterIPAddress class
				/// </summary>
				public static StringResourceItem EnterLabelPrinterIPAddress()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.EnterLabelPrinterIPAddress") );
				}

				/// <summary>
				/// EnterLabelPrinterTcpPortNumber class
				/// </summary>
				public static StringResourceItem EnterLabelPrinterTcpPortNumber()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.EnterLabelPrinterTcpPortNumber") );
				}

				/// <summary>
				/// EnterLockInactivityTimeout class
				/// </summary>
				public static StringResourceItem EnterLockInactivityTimeout()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.EnterLockInactivityTimeout") );
				}

				/// <summary>
				/// NoVistaDivisionsFound class
				/// </summary>
				public static StringResourceItem NoVistaDivisionsFound()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.NoVistaDivisionsFound") );
				}

				/// <summary>
				/// PleaseSelectVistaDivision class
				/// </summary>
				public static StringResourceItem PleaseSelectVistaDivision()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.PleaseSelectVistaDivision") );
				}

				/// <summary>
				/// SaveDivisionData class
				/// </summary>
				public static StringResourceItem SaveDivisionData()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.SaveDivisionData") );
				}

				/// <summary>
				/// SelectAccessionArea class
				/// </summary>
				public static StringResourceItem SelectAccessionArea()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.SelectAccessionArea") );
				}

				/// <summary>
				/// SelectDaylightSavingsType class
				/// </summary>
				public static StringResourceItem SelectDaylightSavingsType()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.SelectDaylightSavingsType") );
				}

				/// <summary>
				/// SelectDivisionCode class
				/// </summary>
				public static StringResourceItem SelectDivisionCode()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.SelectDivisionCode") );
				}

				/// <summary>
				/// SelectDivisionName class
				/// </summary>
				public static StringResourceItem SelectDivisionName()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.SelectDivisionName") );
				}

				/// <summary>
				/// SelectFacility class
				/// </summary>
				public static StringResourceItem SelectFacility()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.SelectFacility") );
				}

				/// <summary>
				/// SelectTimeZone class
				/// </summary>
				public static StringResourceItem SelectTimeZone()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC02.SelectTimeZone") );
				}
			}
			/// <summary>
			/// MUC03 class
			/// </summary>
			public sealed class MUC03
			{
				/// <summary>
				/// ClickToCancelVistaUserSelection class
				/// </summary>
				public static StringResourceItem ClickToCancelVistaUserSelection()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC03.ClickToCancelVistaUserSelection") );
				}

				/// <summary>
				/// ClickToCancelWindowsUserSelection class
				/// </summary>
				public static StringResourceItem ClickToCancelWindowsUserSelection()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC03.ClickToCancelWindowsUserSelection") );
				}

				/// <summary>
				/// ClickToSearchVista class
				/// </summary>
				public static StringResourceItem ClickToSearchVista()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC03.ClickToSearchVista") );
				}

				/// <summary>
				/// ClickToSelectVistaUser class
				/// </summary>
				public static StringResourceItem ClickToSelectVistaUser()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC03.ClickToSelectVistaUser") );
				}

				/// <summary>
				/// ClickToSelectWindowsUser class
				/// </summary>
				public static StringResourceItem ClickToSelectWindowsUser()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC03.ClickToSelectWindowsUser") );
				}

				/// <summary>
				/// EnterSearchCriteria class
				/// </summary>
				public static StringResourceItem EnterSearchCriteria()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC03.EnterSearchCriteria") );
				}

				/// <summary>
				/// PleaseSelectVistaUser class
				/// </summary>
				public static StringResourceItem PleaseSelectVistaUser()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC03.PleaseSelectVistaUser") );
				}

				/// <summary>
				/// PleaseSelectWindowsUser class
				/// </summary>
				public static StringResourceItem PleaseSelectWindowsUser()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC03.PleaseSelectWindowsUser") );
				}
			}
			/// <summary>
			/// MUC04 class
			/// </summary>
			public sealed class MUC04
			{
				/// <summary>
				/// ClickToSaveInterfaceConfig class
				/// </summary>
				public static StringResourceItem ClickToSaveInterfaceConfig()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC04.ClickToSaveInterfaceConfig") );
				}

				/// <summary>
				/// ClickToTestInterfaceConfig class
				/// </summary>
				public static StringResourceItem ClickToTestInterfaceConfig()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC04.ClickToTestInterfaceConfig") );
				}

				/// <summary>
				/// EmailMustBeSpecified class
				/// </summary>
				public static StringResourceItem EmailMustBeSpecified()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC04.EmailMustBeSpecified") );
				}

				/// <summary>
				/// FacilitiesCannotMatch class
				/// </summary>
				public static StringResourceItem FacilitiesCannotMatch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC04.FacilitiesCannotMatch") );
				}

				/// <summary>
				/// InterfaceConfigIsBeingTested class
				/// </summary>
				public static StringResourceItem InterfaceConfigIsBeingTested()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC04.InterfaceConfigIsBeingTested") );
				}

				/// <summary>
				/// InterfaceConfigTestSucceeded class
				/// </summary>
				public static StringResourceItem InterfaceConfigTestSucceeded()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC04.InterfaceConfigTestSucceeded") );
				}

				/// <summary>
				/// InterfaceConfigWasNotChanged class
				/// </summary>
				public static StringResourceItem InterfaceConfigWasNotChanged()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC04.InterfaceConfigWasNotChanged") );
				}

				/// <summary>
				/// InterfaceConfigWasNotTested class
				/// </summary>
				public static StringResourceItem InterfaceConfigWasNotTested()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC04.InterfaceConfigWasNotTested") );
				}

				/// <summary>
				/// InterfaceConfigWasNotTestedAfterChange class
				/// </summary>
				public static StringResourceItem InterfaceConfigWasNotTestedAfterChange()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC04.InterfaceConfigWasNotTestedAfterChange") );
				}

				/// <summary>
				/// InterfaceConnectionTestFailed class
				/// </summary>
				public static StringResourceItem InterfaceConnectionTestFailed()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC04.InterfaceConnectionTestFailed") );
				}

				/// <summary>
				/// InterfaceIPAddressMustBeSpecified class
				/// </summary>
				public static StringResourceItem InterfaceIPAddressMustBeSpecified()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC04.InterfaceIPAddressMustBeSpecified") );
				}

				/// <summary>
				/// NoChangesInConfig class
				/// </summary>
				public static StringResourceItem NoChangesInConfig()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC04.NoChangesInConfig") );
				}

				/// <summary>
				/// PortNumberMustBeSpecified class
				/// </summary>
				public static StringResourceItem PortNumberMustBeSpecified()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC04.PortNumberMustBeSpecified") );
				}

				/// <summary>
				/// SomeDataInvalid class
				/// </summary>
				public static StringResourceItem SomeDataInvalid()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC04.SomeDataInvalid") );
				}

				/// <summary>
				/// UnableToTestSinceInterfaceConfigIsInvalid class
				/// </summary>
				public static StringResourceItem UnableToTestSinceInterfaceConfigIsInvalid()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC04.UnableToTestSinceInterfaceConfigIsInvalid") );
				}

				/// <summary>
				/// VBECSIPAddressMustBeSpecified class
				/// </summary>
				public static StringResourceItem VBECSIPAddressMustBeSpecified()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("MUC04.VBECSIPAddressMustBeSpecified") );
				}
			}
			/// <summary>
			/// UC001 class
			/// </summary>
			public sealed class UC001
			{
				/// <summary>
				/// BR137_RestrictPatient class
				/// </summary>
				public static StringResourceItem BR137_RestrictPatient()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.BR137.RestrictPatient") );
				}

				/// <summary>
				/// ClicktoAddUnitstoShipment class
				/// </summary>
				public static StringResourceItem ClicktoAddUnitstoShipment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.ClicktoAddUnitstoShipment") );
				}

				/// <summary>
				/// ClicktoSaveShipment class
				/// </summary>
				public static StringResourceItem ClicktoSaveShipment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.ClicktoSaveShipment") );
				}

				/// <summary>
				/// MustbeUnitinIncomingShipmentTable class
				/// </summary>
				public static StringResourceItem MustbeUnitinIncomingShipmentTable()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.MustbeUnitinIncomingShipmentTable") );
				}

				/// <summary>
				/// NoCodabarUnitsInISBTShipment class
				/// </summary>
				public static StringResourceItem NoCodabarUnitsInISBTShipment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.NoCodabarUnitsInISBTShipment") );
				}

				/// <summary>
				/// NoISBTUnitsInCodabarShipment class
				/// </summary>
				public static StringResourceItem NoISBTUnitsInCodabarShipment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.NoISBTUnitsInCodabarShipment") );
				}

				/// <summary>
				/// NoUnitInstance class
				/// </summary>
				public static StringResourceItem NoUnitInstance()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.NoUnitInstance") );
				}
			}
			/// <summary>
			/// UC002 class
			/// </summary>
			public sealed class UC002
			{
				/// <summary>
				/// SelectUnit class
				/// </summary>
				public static StringResourceItem SelectUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC002.SelectUnit") );
				}
			}
			/// <summary>
			/// UC005 class
			/// </summary>
			public sealed class UC005
			{
				/// <summary>
				/// DeselectAllABORh class
				/// </summary>
				public static StringResourceItem DeselectAllABORh()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC005.DeselectAllABORh") );
				}

				/// <summary>
				/// DeselectAllProducts class
				/// </summary>
				public static StringResourceItem DeselectAllProducts()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC005.DeselectAllProducts") );
				}

				/// <summary>
				/// DeselectAllSpecialTesting class
				/// </summary>
				public static StringResourceItem DeselectAllSpecialTesting()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC005.DeselectAllSpecialTesting") );
				}
			}
			/// <summary>
			/// UC006 class
			/// </summary>
			public sealed class UC006
			{
				/// <summary>
				/// btnClear class
				/// </summary>
				public static StringResourceItem btnClear()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.btnClear") );
				}

				/// <summary>
				/// btnSearch class
				/// </summary>
				public static StringResourceItem btnSearch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.btnSearch") );
				}

				/// <summary>
				/// cbActive class
				/// </summary>
				public static StringResourceItem cbActive()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.cbActive") );
				}

				/// <summary>
				/// cbAlpha class
				/// </summary>
				public static StringResourceItem cbAlpha()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.cbAlpha") );
				}

				/// <summary>
				/// cbCollectionFacility class
				/// </summary>
				public static StringResourceItem cbCollectionFacility()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.cbCollectionFacility") );
				}

				/// <summary>
				/// cbTestingFacility class
				/// </summary>
				public static StringResourceItem cbTestingFacility()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.cbTestingFacility") );
				}

				/// <summary>
				/// cmbState class
				/// </summary>
				public static StringResourceItem cmbState()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.cmbState") );
				}

				/// <summary>
				/// edtPrefix class
				/// </summary>
				public static StringResourceItem edtPrefix()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.edtPrefix") );
				}

				/// <summary>
				/// IccbbaRegistrationNumber class
				/// </summary>
				public static StringResourceItem IccbbaRegistrationNumber()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.IccbbaRegistrationNumber") );
				}

				/// <summary>
				/// mtxtFax class
				/// </summary>
				public static StringResourceItem mtxtFax()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.mtxtFax") );
				}

				/// <summary>
				/// mtxtPhone class
				/// </summary>
				public static StringResourceItem mtxtPhone()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.mtxtPhone") );
				}

				/// <summary>
				/// mtxtZip class
				/// </summary>
				public static StringResourceItem mtxtZip()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.mtxtZip") );
				}

				/// <summary>
				/// txtAddress1 class
				/// </summary>
				public static StringResourceItem txtAddress1()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.txtAddress1") );
				}

				/// <summary>
				/// txtAddress2 class
				/// </summary>
				public static StringResourceItem txtAddress2()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.txtAddress2") );
				}

				/// <summary>
				/// txtAddress3 class
				/// </summary>
				public static StringResourceItem txtAddress3()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.txtAddress3") );
				}

				/// <summary>
				/// txtCity class
				/// </summary>
				public static StringResourceItem txtCity()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.txtCity") );
				}

				/// <summary>
				/// txtFacilityName class
				/// </summary>
				public static StringResourceItem txtFacilityName()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.txtFacilityName") );
				}

				/// <summary>
				/// txtFDAReg class
				/// </summary>
				public static StringResourceItem txtFDAReg()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.txtFDAReg") );
				}
			}
			/// <summary>
			/// UC008 class
			/// </summary>
			public sealed class UC008
			{
				/// <summary>
				/// btnAdd class
				/// </summary>
				public static StringResourceItem btnAdd()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.btnAdd") );
				}

				/// <summary>
				/// btnClear class
				/// </summary>
				public static StringResourceItem btnClear()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.btnClear") );
				}

				/// <summary>
				/// btnHistory class
				/// </summary>
				public static StringResourceItem btnHistory()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.btnHistory") );
				}

				/// <summary>
				/// btnSearch class
				/// </summary>
				public static StringResourceItem btnSearch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.btnSearch") );
				}

				/// <summary>
				/// cmbFDARegNum class
				/// </summary>
				public static StringResourceItem cmbFDARegNum()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.cmbFDARegNum") );
				}

				/// <summary>
				/// cmbHCPCSCode class
				/// </summary>
				public static StringResourceItem cmbHCPCSCode()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.cmbHCPCSCode") );
				}

				/// <summary>
				/// cmbHCPCSText class
				/// </summary>
				public static StringResourceItem cmbHCPCSText()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.cmbHCPCSText") );
				}

				/// <summary>
				/// cmbSupplier class
				/// </summary>
				public static StringResourceItem cmbSupplier()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.cmbSupplier") );
				}

				/// <summary>
				/// lvSuppliers class
				/// </summary>
				public static StringResourceItem lvSuppliers()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.lvSuppliers") );
				}

				/// <summary>
				/// ProductMustBeActive class
				/// </summary>
				public static StringResourceItem ProductMustBeActive()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.ProductMustBeActive") );
				}

				/// <summary>
				/// SupplierMustBeActive class
				/// </summary>
				public static StringResourceItem SupplierMustBeActive()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.SupplierMustBeActive") );
				}

				/// <summary>
				/// txtCode class
				/// </summary>
				public static StringResourceItem txtCode()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.txtCode") );
				}

				/// <summary>
				/// txtDays class
				/// </summary>
				public static StringResourceItem txtDays()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.txtDays") );
				}

				/// <summary>
				/// txtHours class
				/// </summary>
				public static StringResourceItem txtHours()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.txtHours") );
				}

				/// <summary>
				/// txtName class
				/// </summary>
				public static StringResourceItem txtName()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.txtName") );
				}

				/// <summary>
				/// txtShortName class
				/// </summary>
				public static StringResourceItem txtShortName()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.txtShortName") );
				}

				/// <summary>
				/// txtType class
				/// </summary>
				public static StringResourceItem txtType()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.txtType") );
				}

				/// <summary>
				/// txtVolume class
				/// </summary>
				public static StringResourceItem txtVolume()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.txtVolume") );
				}

				/// <summary>
				/// updCost class
				/// </summary>
				public static StringResourceItem updCost()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.updCost") );
				}

				/// <summary>
				/// updReturnCredit class
				/// </summary>
				public static StringResourceItem updReturnCredit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.updReturnCredit") );
				}
			}
			/// <summary>
			/// UC009 class
			/// </summary>
			public sealed class UC009
			{
				/// <summary>
				/// AntibodyScreen class
				/// </summary>
				public static StringResourceItem AntibodyScreen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC009.AntibodyScreen") );
				}

				/// <summary>
				/// CrossmatchEnabled class
				/// </summary>
				public static StringResourceItem CrossmatchEnabled()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC009.CrossmatchEnabled") );
				}

				/// <summary>
				/// IccbaRegistrationNumber class
				/// </summary>
				public static StringResourceItem IccbaRegistrationNumber()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC009.IccbaRegistrationNumber") );
				}

				/// <summary>
				/// MaximumSpecimenExpiration class
				/// </summary>
				public static StringResourceItem MaximumSpecimenExpiration()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC009.MaximumSpecimenExpiration") );
				}

				/// <summary>
				/// MedicalDirectorName class
				/// </summary>
				public static StringResourceItem MedicalDirectorName()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC009.MedicalDirectorName") );
				}
			}
			/// <summary>
			/// UC01 class
			/// </summary>
			public sealed class UC01
			{
				/// <summary>
				/// CodabarNoUnitInstance class
				/// </summary>
				public static StringResourceItem CodabarNoUnitInstance()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC01.CodabarNoUnitInstance") );
				}
			}
			/// <summary>
			/// UC010 class
			/// </summary>
			public sealed class UC010
			{
				/// <summary>
				/// EnableModification class
				/// </summary>
				public static StringResourceItem EnableModification(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC010.EnableModification"), arg0 );
				}

				/// <summary>
				/// ModificationCost class
				/// </summary>
				public static StringResourceItem ModificationCost(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC010.ModificationCost"), arg0 );
				}
			}
			/// <summary>
			/// UC013 class
			/// </summary>
			public sealed class UC013
			{
				/// <summary>
				/// ClickOKTORemoveStatus class
				/// </summary>
				public static StringResourceItem ClickOKTORemoveStatus()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC013.ClickOKTORemoveStatus") );
				}

				/// <summary>
				/// CurrentUnitStatus class
				/// </summary>
				public static StringResourceItem CurrentUnitStatus()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC013.CurrentUnitStatus") );
				}

				/// <summary>
				/// PreviousUnitStatus class
				/// </summary>
				public static StringResourceItem PreviousUnitStatus()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC013.PreviousUnitStatus") );
				}

				/// <summary>
				/// SelectUserRole class
				/// </summary>
				public static StringResourceItem SelectUserRole()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC013.SelectUserRole") );
				}
			}
			/// <summary>
			/// UC014 class
			/// </summary>
			public sealed class UC014
			{
				/// <summary>
				/// updBaseCost class
				/// </summary>
				public static StringResourceItem updBaseCost()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC014.updBaseCost") );
				}

				/// <summary>
				/// updReturnCredit class
				/// </summary>
				public static StringResourceItem updReturnCredit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC014.updReturnCredit") );
				}

				/// <summary>
				/// updSpecialTestingCost class
				/// </summary>
				public static StringResourceItem updSpecialTestingCost()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC014.updSpecialTestingCost") );
				}
			}
			/// <summary>
			/// UC016 class
			/// </summary>
			public sealed class UC016
			{
				/// <summary>
				/// AlreadyAccepted class
				/// </summary>
				public static StringResourceItem AlreadyAccepted()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.AlreadyAccepted") );
				}

				/// <summary>
				/// MismatchedSpecimen class
				/// </summary>
				public static StringResourceItem MismatchedSpecimen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.MismatchedSpecimen") );
				}

				/// <summary>
				/// NoLabData class
				/// </summary>
				public static StringResourceItem NoLabData()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.NoLabData") );
				}

				/// <summary>
				/// SearchCriteria class
				/// </summary>
				public static StringResourceItem SearchCriteria()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.SearchCriteria") );
				}

				/// <summary>
				/// SelectOrder class
				/// </summary>
				public static StringResourceItem SelectOrder()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.SelectOrder") );
				}

				/// <summary>
				/// SpecimenDetailsRequired class
				/// </summary>
				public static StringResourceItem SpecimenDetailsRequired()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.SpecimenDetailsRequired") );
				}

				/// <summary>
				/// SpecimenInconsistent class
				/// </summary>
				public static StringResourceItem SpecimenInconsistent()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.SpecimenInconsistent") );
				}

				/// <summary>
				/// SpecimenUIDLength class
				/// </summary>
				public static StringResourceItem SpecimenUIDLength()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.SpecimenUIDLength") );
				}

				/// <summary>
				/// SpecimenUIDRequired class
				/// </summary>
				public static StringResourceItem SpecimenUIDRequired()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.SpecimenUIDRequired") );
				}

				/// <summary>
				/// SpecimenUnacceptable class
				/// </summary>
				public static StringResourceItem SpecimenUnacceptable()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.SpecimenUnacceptable") );
				}
			}
			/// <summary>
			/// UC017 class
			/// </summary>
			public sealed class UC017
			{
				/// <summary>
				/// btnOK class
				/// </summary>
				public static StringResourceItem btnOK()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC017.btnOK") );
				}

				/// <summary>
				/// btnOKNoText class
				/// </summary>
				public static StringResourceItem btnOKNoText()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC017.btnOKNoText") );
				}
			}
			/// <summary>
			/// UC018 class
			/// </summary>
			public sealed class UC018
			{
				/// <summary>
				/// SelectDivisionbtnCancel class
				/// </summary>
				public static StringResourceItem SelectDivisionbtnCancel()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.SelectDivisionbtnCancel") );
				}

				/// <summary>
				/// SelectDivisionbtnOkDisabled class
				/// </summary>
				public static StringResourceItem SelectDivisionbtnOkDisabled()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.SelectDivisionbtnOkDisabled") );
				}

				/// <summary>
				/// SelectDivisionbtnOkEnabled class
				/// </summary>
				public static StringResourceItem SelectDivisionbtnOkEnabled()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.SelectDivisionbtnOkEnabled") );
				}

				/// <summary>
				/// SelectDivisionclstDivisions class
				/// </summary>
				public static StringResourceItem SelectDivisionclstDivisions()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.SelectDivisionclstDivisions") );
				}
			}
			/// <summary>
			/// UC019 class
			/// </summary>
			public sealed class UC019
			{
				/// <summary>
				/// ActiveUserList class
				/// </summary>
				public static StringResourceItem ActiveUserList()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC019.ActiveUserList") );
				}

				/// <summary>
				/// SelectUserRole class
				/// </summary>
				public static StringResourceItem SelectUserRole()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC019.SelectUserRole") );
				}

				/// <summary>
				/// SelectUsers class
				/// </summary>
				public static StringResourceItem SelectUsers()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC019.SelectUsers") );
				}
			}
			/// <summary>
			/// UC020 class
			/// </summary>
			public sealed class UC020
			{
				/// <summary>
				/// AddAtLeastOne class
				/// </summary>
				public static StringResourceItem AddAtLeastOne()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC020.AddAtLeastOne") );
				}

				/// <summary>
				/// Comment class
				/// </summary>
				public static StringResourceItem Comment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC020.Comment") );
				}

				/// <summary>
				/// DateTime class
				/// </summary>
				public static StringResourceItem DateTime()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC020.DateTime") );
				}

				/// <summary>
				/// LotSearch class
				/// </summary>
				public static StringResourceItem LotSearch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC020.LotSearch") );
				}

				/// <summary>
				/// ReasonForChange class
				/// </summary>
				public static StringResourceItem ReasonForChange()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC020.ReasonForChange") );
				}

				/// <summary>
				/// Search class
				/// </summary>
				public static StringResourceItem Search()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC020.Search") );
				}
			}
			/// <summary>
			/// UC021 class
			/// </summary>
			public sealed class UC021
			{
				/// <summary>
				/// BagClericalCheckFailComment class
				/// </summary>
				public static StringResourceItem BagClericalCheckFailComment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.BagClericalCheckFailComment") );
				}

				/// <summary>
				/// DateTested class
				/// </summary>
				public static StringResourceItem DateTested()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.DateTested") );
				}

				/// <summary>
				/// FreeTextSymptom class
				/// </summary>
				public static StringResourceItem FreeTextSymptom()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.FreeTextSymptom") );
				}

				/// <summary>
				/// ImplicatedUnitBagReturned class
				/// </summary>
				public static StringResourceItem ImplicatedUnitBagReturned()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.ImplicatedUnitBagReturned") );
				}

				/// <summary>
				/// ImplicatedUnitClericalChecks class
				/// </summary>
				public static StringResourceItem ImplicatedUnitClericalChecks()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.ImplicatedUnitClericalChecks") );
				}

				/// <summary>
				/// ImplicatedUnitHemolysis class
				/// </summary>
				public static StringResourceItem ImplicatedUnitHemolysis()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.ImplicatedUnitHemolysis") );
				}

				/// <summary>
				/// ImplicatedUnitID class
				/// </summary>
				public static StringResourceItem ImplicatedUnitID()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.ImplicatedUnitID") );
				}

				/// <summary>
				/// ImplicatedUnitNoBagComment class
				/// </summary>
				public static StringResourceItem ImplicatedUnitNoBagComment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.ImplicatedUnitNoBagComment") );
				}

				/// <summary>
				/// ImplicatedUnits class
				/// </summary>
				public static StringResourceItem ImplicatedUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.ImplicatedUnits") );
				}

				/// <summary>
				/// IndicateImplicatedUnit class
				/// </summary>
				public static StringResourceItem IndicateImplicatedUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.IndicateImplicatedUnit") );
				}

				/// <summary>
				/// IndicateSymptoms class
				/// </summary>
				public static StringResourceItem IndicateSymptoms()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.IndicateSymptoms") );
				}

				/// <summary>
				/// NoPostSpecimenComment class
				/// </summary>
				public static StringResourceItem NoPostSpecimenComment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.NoPostSpecimenComment") );
				}

				/// <summary>
				/// NoPreSpecimenComment class
				/// </summary>
				public static StringResourceItem NoPreSpecimenComment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.NoPreSpecimenComment") );
				}

				/// <summary>
				/// PostSpecimenClericalCheckFailComment class
				/// </summary>
				public static StringResourceItem PostSpecimenClericalCheckFailComment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.PostSpecimenClericalCheckFailComment") );
				}

				/// <summary>
				/// PostSpecimenClericalChecks class
				/// </summary>
				public static StringResourceItem PostSpecimenClericalChecks()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.PostSpecimenClericalChecks") );
				}

				/// <summary>
				/// PostSpecimenPatientMismatch class
				/// </summary>
				public static StringResourceItem PostSpecimenPatientMismatch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.PostSpecimenPatientMismatch") );
				}

				/// <summary>
				/// PostTransfusionSpecimenAvailable class
				/// </summary>
				public static StringResourceItem PostTransfusionSpecimenAvailable()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.PostTransfusionSpecimenAvailable") );
				}

				/// <summary>
				/// PreSpecimenClericalCheckFailComment class
				/// </summary>
				public static StringResourceItem PreSpecimenClericalCheckFailComment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.PreSpecimenClericalCheckFailComment") );
				}

				/// <summary>
				/// PreSpecimenClericalChecks class
				/// </summary>
				public static StringResourceItem PreSpecimenClericalChecks()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.PreSpecimenClericalChecks") );
				}

				/// <summary>
				/// PreSpecimenPatientMismatch class
				/// </summary>
				public static StringResourceItem PreSpecimenPatientMismatch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.PreSpecimenPatientMismatch") );
				}

				/// <summary>
				/// PreTransfusionSpecimenAvailable class
				/// </summary>
				public static StringResourceItem PreTransfusionSpecimenAvailable()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.PreTransfusionSpecimenAvailable") );
				}

				/// <summary>
				/// Rack class
				/// </summary>
				public static StringResourceItem Rack()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.Rack") );
				}

				/// <summary>
				/// Symptoms class
				/// </summary>
				public static StringResourceItem Symptoms()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.Symptoms") );
				}

				/// <summary>
				/// TestedBy class
				/// </summary>
				public static StringResourceItem TestedBy()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.TestedBy") );
				}

				/// <summary>
				/// TestingMethod class
				/// </summary>
				public static StringResourceItem TestingMethod()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.TestingMethod") );
				}

				/// <summary>
				/// UnitPatientMismatch class
				/// </summary>
				public static StringResourceItem UnitPatientMismatch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.UnitPatientMismatch") );
				}

				/// <summary>
				/// ValidAboInterps class
				/// </summary>
				public static StringResourceItem ValidAboInterps()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.ValidAboInterps") );
				}

				/// <summary>
				/// ValidAbsInterps class
				/// </summary>
				public static StringResourceItem ValidAbsInterps()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.ValidAbsInterps") );
				}

				/// <summary>
				/// ValidDatInterps class
				/// </summary>
				public static StringResourceItem ValidDatInterps()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.ValidDatInterps") );
				}

				/// <summary>
				/// ValidRHInterps class
				/// </summary>
				public static StringResourceItem ValidRHInterps()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.ValidRHInterps") );
				}

				/// <summary>
				/// ValidXMInterps class
				/// </summary>
				public static StringResourceItem ValidXMInterps()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.ValidXMInterps") );
				}
			}
			/// <summary>
			/// UC022 class
			/// </summary>
			public sealed class UC022
			{
				/// <summary>
				/// AddEquipment class
				/// </summary>
				public static StringResourceItem AddEquipment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.AddEquipment") );
				}

				/// <summary>
				/// AddEquipmentMaintenance class
				/// </summary>
				public static StringResourceItem AddEquipmentMaintenance()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.AddEquipmentMaintenance") );
				}

				/// <summary>
				/// AddressList class
				/// </summary>
				public static StringResourceItem AddressList()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.AddressList") );
				}

				/// <summary>
				/// AddressSelect class
				/// </summary>
				public static StringResourceItem AddressSelect()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.AddressSelect") );
				}

				/// <summary>
				/// DateReceivedInstalled class
				/// </summary>
				public static StringResourceItem DateReceivedInstalled()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.DateReceivedInstalled") );
				}

				/// <summary>
				/// EnterNewAddress class
				/// </summary>
				public static StringResourceItem EnterNewAddress()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.EnterNewAddress") );
				}

				/// <summary>
				/// EquipmentInventory class
				/// </summary>
				public static StringResourceItem EquipmentInventory()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.EquipmentInventory") );
				}

				/// <summary>
				/// EquipmentLoggedIn class
				/// </summary>
				public static StringResourceItem EquipmentLoggedIn()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.EquipmentLoggedIn") );
				}

				/// <summary>
				/// EquipmentName class
				/// </summary>
				public static StringResourceItem EquipmentName()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.EquipmentName") );
				}

				/// <summary>
				/// EquipmentType class
				/// </summary>
				public static StringResourceItem EquipmentType()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.EquipmentType") );
				}

				/// <summary>
				/// ExpirationRenewalDate class
				/// </summary>
				public static StringResourceItem ExpirationRenewalDate()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.ExpirationRenewalDate") );
				}

				/// <summary>
				/// ExpirationRenewalDateOnOff class
				/// </summary>
				public static StringResourceItem ExpirationRenewalDateOnOff()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.ExpirationRenewalDateOnOff") );
				}

				/// <summary>
				/// IncludeOutOfService class
				/// </summary>
				public static StringResourceItem IncludeOutOfService()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.IncludeOutOfService") );
				}

				/// <summary>
				/// LocalEquipmentId class
				/// </summary>
				public static StringResourceItem LocalEquipmentId()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.LocalEquipmentId") );
				}

				/// <summary>
				/// MaintenanceDate class
				/// </summary>
				public static StringResourceItem MaintenanceDate()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.MaintenanceDate") );
				}

				/// <summary>
				/// MaintenanceEvents class
				/// </summary>
				public static StringResourceItem MaintenanceEvents()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.MaintenanceEvents") );
				}

				/// <summary>
				/// MaintenanceResults class
				/// </summary>
				public static StringResourceItem MaintenanceResults()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.MaintenanceResults") );
				}

				/// <summary>
				/// MaintenanceType class
				/// </summary>
				public static StringResourceItem MaintenanceType()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.MaintenanceType") );
				}

				/// <summary>
				/// NextScheduledEvent class
				/// </summary>
				public static StringResourceItem NextScheduledEvent()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.NextScheduledEvent") );
				}

				/// <summary>
				/// OutOfService class
				/// </summary>
				public static StringResourceItem OutOfService()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.OutOfService") );
				}

				/// <summary>
				/// PendingIssues class
				/// </summary>
				public static StringResourceItem PendingIssues()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.PendingIssues") );
				}

				/// <summary>
				/// SelectAddressOrNewAddress class
				/// </summary>
				public static StringResourceItem SelectAddressOrNewAddress()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.SelectAddressOrNewAddress") );
				}

				/// <summary>
				/// SerialNumber class
				/// </summary>
				public static StringResourceItem SerialNumber()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.SerialNumber") );
				}

				/// <summary>
				/// SerialNumberSearch class
				/// </summary>
				public static StringResourceItem SerialNumberSearch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.SerialNumberSearch") );
				}

				/// <summary>
				/// SerialNumberSearchButton class
				/// </summary>
				public static StringResourceItem SerialNumberSearchButton()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.SerialNumberSearchButton") );
				}

				/// <summary>
				/// UpdateEquipment class
				/// </summary>
				public static StringResourceItem UpdateEquipment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.UpdateEquipment") );
				}

				/// <summary>
				/// UpdateEquipmentMaintenance class
				/// </summary>
				public static StringResourceItem UpdateEquipmentMaintenance()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.UpdateEquipmentMaintenance") );
				}

				/// <summary>
				/// ViewEquipmentName class
				/// </summary>
				public static StringResourceItem ViewEquipmentName()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.ViewEquipmentName") );
				}

				/// <summary>
				/// ViewEquipmentType class
				/// </summary>
				public static StringResourceItem ViewEquipmentType()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.ViewEquipmentType") );
				}

				/// <summary>
				/// WarrantyServiceContractNumber class
				/// </summary>
				public static StringResourceItem WarrantyServiceContractNumber()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.WarrantyServiceContractNumber") );
				}
			}
			/// <summary>
			/// UC023 class
			/// </summary>
			public sealed class UC023
			{
				/// <summary>
				/// AntibodiesList class
				/// </summary>
				public static StringResourceItem AntibodiesList()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC023.AntibodiesList") );
				}

				/// <summary>
				/// AntibodyName class
				/// </summary>
				public static StringResourceItem AntibodyName()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC023.AntibodyName") );
				}

				/// <summary>
				/// AntibodyPercentage class
				/// </summary>
				public static StringResourceItem AntibodyPercentage()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC023.AntibodyPercentage") );
				}

				/// <summary>
				/// HigherLevel class
				/// </summary>
				public static StringResourceItem HigherLevel()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC023.HigherLevel") );
				}
			}
			/// <summary>
			/// UC026 class
			/// </summary>
			public sealed class UC026
			{
				/// <summary>
				/// AddContainer class
				/// </summary>
				public static StringResourceItem AddContainer()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.AddContainer") );
				}

				/// <summary>
				/// AddEquipment class
				/// </summary>
				public static StringResourceItem AddEquipment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.AddEquipment") );
				}

				/// <summary>
				/// AddSupplies class
				/// </summary>
				public static StringResourceItem AddSupplies()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.AddSupplies") );
				}

				/// <summary>
				/// AddWafer class
				/// </summary>
				public static StringResourceItem AddWafer()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.AddWafer") );
				}

				/// <summary>
				/// CancelBatchTab class
				/// </summary>
				public static StringResourceItem CancelBatchTab(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.CancelBatchTab"), arg0 );
				}

				/// <summary>
				/// CancelVerification class
				/// </summary>
				public static StringResourceItem CancelVerification()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.CancelVerification") );
				}

				/// <summary>
				/// CompleteWeld class
				/// </summary>
				public static StringResourceItem CompleteWeld()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.CompleteWeld") );
				}

				/// <summary>
				/// ContainerList class
				/// </summary>
				public static StringResourceItem ContainerList()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.ContainerList") );
				}

				/// <summary>
				/// EnterAComment class
				/// </summary>
				public static StringResourceItem EnterAComment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.EnterAComment") );
				}

				/// <summary>
				/// EquipmentList class
				/// </summary>
				public static StringResourceItem EquipmentList()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.EquipmentList") );
				}

				/// <summary>
				/// IncompleteWeld class
				/// </summary>
				public static StringResourceItem IncompleteWeld()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.IncompleteWeld") );
				}

				/// <summary>
				/// MustSelectXUnitsToContinue class
				/// </summary>
				public static StringResourceItem MustSelectXUnitsToContinue(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.MustSelectXUnitsToContinue"), arg0, arg1 );
				}

				/// <summary>
				/// NoTargetProducts class
				/// </summary>
				public static StringResourceItem NoTargetProducts()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.NoTargetProducts") );
				}

				/// <summary>
				/// OKToSave class
				/// </summary>
				public static StringResourceItem OKToSave()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.OKToSave") );
				}

				/// <summary>
				/// OriginalAboRH class
				/// </summary>
				public static StringResourceItem OriginalAboRH()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.OriginalAboRH") );
				}

				/// <summary>
				/// OriginalAntigens class
				/// </summary>
				public static StringResourceItem OriginalAntigens()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.OriginalAntigens") );
				}

				/// <summary>
				/// OriginalCMVNegative class
				/// </summary>
				public static StringResourceItem OriginalCMVNegative()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.OriginalCMVNegative") );
				}

				/// <summary>
				/// OriginalDonationType class
				/// </summary>
				public static StringResourceItem OriginalDonationType()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.OriginalDonationType") );
				}

				/// <summary>
				/// OriginalExpirationDate class
				/// </summary>
				public static StringResourceItem OriginalExpirationDate()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.OriginalExpirationDate") );
				}

				/// <summary>
				/// OriginalRestrictedName class
				/// </summary>
				public static StringResourceItem OriginalRestrictedName()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.OriginalRestrictedName") );
				}

				/// <summary>
				/// OriginalRestrictedSSN class
				/// </summary>
				public static StringResourceItem OriginalRestrictedSSN()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.OriginalRestrictedSSN") );
				}

				/// <summary>
				/// OriginalRestrictedStatus class
				/// </summary>
				public static StringResourceItem OriginalRestrictedStatus()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.OriginalRestrictedStatus") );
				}

				/// <summary>
				/// OriginalSickleCellNeg class
				/// </summary>
				public static StringResourceItem OriginalSickleCellNeg()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.OriginalSickleCellNeg") );
				}

				/// <summary>
				/// OriginalUnitId class
				/// </summary>
				public static StringResourceItem OriginalUnitId()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.OriginalUnitId") );
				}

				/// <summary>
				/// OriginalUnitStatus class
				/// </summary>
				public static StringResourceItem OriginalUnitStatus()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.OriginalUnitStatus") );
				}

				/// <summary>
				/// OriginalVolume class
				/// </summary>
				public static StringResourceItem OriginalVolume()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.OriginalVolume") );
				}

				/// <summary>
				/// PatientAssignmentCancel class
				/// </summary>
				public static StringResourceItem PatientAssignmentCancel()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.PatientAssignmentCancel") );
				}

				/// <summary>
				/// PatientAssignmentListview class
				/// </summary>
				public static StringResourceItem PatientAssignmentListview()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.PatientAssignmentListview") );
				}

				/// <summary>
				/// PatientAssignmentOK class
				/// </summary>
				public static StringResourceItem PatientAssignmentOK()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.PatientAssignmentOK") );
				}

				/// <summary>
				/// ProductModificationRequired class
				/// </summary>
				public static StringResourceItem ProductModificationRequired()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.ProductModificationRequired") );
				}

				/// <summary>
				/// SelectModificationDate class
				/// </summary>
				public static StringResourceItem SelectModificationDate()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.SelectModificationDate") );
				}

				/// <summary>
				/// SelectModificationMethod class
				/// </summary>
				public static StringResourceItem SelectModificationMethod()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.SelectModificationMethod") );
				}

				/// <summary>
				/// SelectProductModification class
				/// </summary>
				public static StringResourceItem SelectProductModification()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.SelectProductModification") );
				}

				/// <summary>
				/// SelectTargetProduct class
				/// </summary>
				public static StringResourceItem SelectTargetProduct()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.SelectTargetProduct") );
				}

				/// <summary>
				/// SupplyList class
				/// </summary>
				public static StringResourceItem SupplyList()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.SupplyList") );
				}

				/// <summary>
				/// TargetAboRH class
				/// </summary>
				public static StringResourceItem TargetAboRH()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.TargetAboRH") );
				}

				/// <summary>
				/// TargetAntigens class
				/// </summary>
				public static StringResourceItem TargetAntigens()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.TargetAntigens") );
				}

				/// <summary>
				/// TargetCMVNegative class
				/// </summary>
				public static StringResourceItem TargetCMVNegative()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.TargetCMVNegative") );
				}

				/// <summary>
				/// TargetDonationType class
				/// </summary>
				public static StringResourceItem TargetDonationType()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.TargetDonationType") );
				}

				/// <summary>
				/// TargetExpirationDate class
				/// </summary>
				public static StringResourceItem TargetExpirationDate()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.TargetExpirationDate") );
				}

				/// <summary>
				/// TargetRestrictedName class
				/// </summary>
				public static StringResourceItem TargetRestrictedName()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.TargetRestrictedName") );
				}

				/// <summary>
				/// TargetRestrictedSSN class
				/// </summary>
				public static StringResourceItem TargetRestrictedSSN()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.TargetRestrictedSSN") );
				}

				/// <summary>
				/// TargetRestrictedStatus class
				/// </summary>
				public static StringResourceItem TargetRestrictedStatus()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.TargetRestrictedStatus") );
				}

				/// <summary>
				/// TargetSickleCellNegative class
				/// </summary>
				public static StringResourceItem TargetSickleCellNegative()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.TargetSickleCellNegative") );
				}

				/// <summary>
				/// TargetUnitId class
				/// </summary>
				public static StringResourceItem TargetUnitId()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.TargetUnitId") );
				}

				/// <summary>
				/// TargetUnitStatus class
				/// </summary>
				public static StringResourceItem TargetUnitStatus()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.TargetUnitStatus") );
				}

				/// <summary>
				/// TargetVolume class
				/// </summary>
				public static StringResourceItem TargetVolume()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.TargetVolume") );
				}

				/// <summary>
				/// VerifyLabel class
				/// </summary>
				public static StringResourceItem VerifyLabel()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.VerifyLabel") );
				}

				/// <summary>
				/// WaferList class
				/// </summary>
				public static StringResourceItem WaferList()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.WaferList") );
				}
			}
			/// <summary>
			/// UC028 class
			/// </summary>
			public sealed class UC028
			{
				/// <summary>
				/// EnterDailyQuality class
				/// </summary>
				public static StringResourceItem EnterDailyQuality()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC028.EnterDailyQuality") );
				}

				/// <summary>
				/// RackNotUsed class
				/// </summary>
				public static StringResourceItem RackNotUsed()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC028.RackNotUsed") );
				}

				/// <summary>
				/// RecordLotAndExpDate class
				/// </summary>
				public static StringResourceItem RecordLotAndExpDate()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC028.RecordLotAndExpDate") );
				}

				/// <summary>
				/// SelectRackForRetesting class
				/// </summary>
				public static StringResourceItem SelectRackForRetesting()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC028.SelectRackForRetesting") );
				}

				/// <summary>
				/// SelectRackForTesting class
				/// </summary>
				public static StringResourceItem SelectRackForTesting()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC028.SelectRackForTesting") );
				}

				/// <summary>
				/// SelectRackToFinishTesting class
				/// </summary>
				public static StringResourceItem SelectRackToFinishTesting()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC028.SelectRackToFinishTesting") );
				}
			}
			/// <summary>
			/// UC031 class
			/// </summary>
			public sealed class UC031
			{
				/// <summary>
				/// AddComment class
				/// </summary>
				public static StringResourceItem AddComment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC031.AddComment") );
				}

				/// <summary>
				/// CannedCommentList class
				/// </summary>
				public static StringResourceItem CannedCommentList()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC031.CannedCommentList") );
				}

				/// <summary>
				/// CommentCategory class
				/// </summary>
				public static StringResourceItem CommentCategory()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC031.CommentCategory") );
				}

				/// <summary>
				/// CommentText class
				/// </summary>
				public static StringResourceItem CommentText()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC031.CommentText") );
				}

				/// <summary>
				/// MoveCommentDown class
				/// </summary>
				public static StringResourceItem MoveCommentDown()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC031.MoveCommentDown") );
				}

				/// <summary>
				/// MoveCommentUp class
				/// </summary>
				public static StringResourceItem MoveCommentUp()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC031.MoveCommentUp") );
				}
			}
			/// <summary>
			/// UC032 class
			/// </summary>
			public sealed class UC032
			{
				/// <summary>
				/// ActivateComponent class
				/// </summary>
				public static StringResourceItem ActivateComponent()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC032.ActivateComponent") );
				}

				/// <summary>
				/// ActivateSurgery class
				/// </summary>
				public static StringResourceItem ActivateSurgery()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC032.ActivateSurgery") );
				}

				/// <summary>
				/// AddSurgeryItem class
				/// </summary>
				public static StringResourceItem AddSurgeryItem()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC032.AddSurgeryItem") );
				}

				/// <summary>
				/// ComponentClass class
				/// </summary>
				public static StringResourceItem ComponentClass()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC032.ComponentClass") );
				}

				/// <summary>
				/// EnterSurgeryName class
				/// </summary>
				public static StringResourceItem EnterSurgeryName()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC032.EnterSurgeryName") );
				}

				/// <summary>
				/// ExistingSurgeryName class
				/// </summary>
				public static StringResourceItem ExistingSurgeryName()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC032.ExistingSurgeryName") );
				}

				/// <summary>
				/// ListMSBOSDetails class
				/// </summary>
				public static StringResourceItem ListMSBOSDetails()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC032.ListMSBOSDetails") );
				}

				/// <summary>
				/// NoBloodRecommended class
				/// </summary>
				public static StringResourceItem NoBloodRecommended()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC032.NoBloodRecommended") );
				}

				/// <summary>
				/// SelectComponentClass class
				/// </summary>
				public static StringResourceItem SelectComponentClass()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC032.SelectComponentClass") );
				}

				/// <summary>
				/// SelectUnits class
				/// </summary>
				public static StringResourceItem SelectUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC032.SelectUnits") );
				}

				/// <summary>
				/// SurgeryExists class
				/// </summary>
				public static StringResourceItem SurgeryExists()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC032.SurgeryExists") );
				}

				/// <summary>
				/// TypeAndScreen class
				/// </summary>
				public static StringResourceItem TypeAndScreen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC032.TypeAndScreen") );
				}
			}
			/// <summary>
			/// UC033 class
			/// </summary>
			public sealed class UC033
			{
				/// <summary>
				/// ClearTest class
				/// </summary>
				public static StringResourceItem ClearTest()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC033.ClearTest") );
				}

				/// <summary>
				/// ClickSearch class
				/// </summary>
				public static StringResourceItem ClickSearch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC033.ClickSearch") );
				}

				/// <summary>
				/// ClickToSearch class
				/// </summary>
				public static StringResourceItem ClickToSearch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC033.ClickToSearch") );
				}

				/// <summary>
				/// EnterSearchString class
				/// </summary>
				public static StringResourceItem EnterSearchString()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC033.EnterSearchString") );
				}

				/// <summary>
				/// LabTestList class
				/// </summary>
				public static StringResourceItem LabTestList()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC033.LabTestList") );
				}

				/// <summary>
				/// LabTestName class
				/// </summary>
				public static StringResourceItem LabTestName(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC033.LabTestName"), arg0 );
				}

				/// <summary>
				/// LabTestSearch class
				/// </summary>
				public static StringResourceItem LabTestSearch(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC033.LabTestSearch"), arg0 );
				}

				/// <summary>
				/// NoThreshold class
				/// </summary>
				public static StringResourceItem NoThreshold()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC033.NoThreshold") );
				}

				/// <summary>
				/// NumericThreshold class
				/// </summary>
				public static StringResourceItem NumericThreshold()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC033.NumericThreshold") );
				}

				/// <summary>
				/// OKToSave class
				/// </summary>
				public static StringResourceItem OKToSave()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC033.OKToSave") );
				}

				/// <summary>
				/// PartialLabTestName class
				/// </summary>
				public static StringResourceItem PartialLabTestName()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC033.PartialLabTestName") );
				}

				/// <summary>
				/// PositiveThreshold class
				/// </summary>
				public static StringResourceItem PositiveThreshold()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC033.PositiveThreshold") );
				}

				/// <summary>
				/// SelectLabTest class
				/// </summary>
				public static StringResourceItem SelectLabTest()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC033.SelectLabTest") );
				}

				/// <summary>
				/// SpecimenType class
				/// </summary>
				public static StringResourceItem SpecimenType()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC033.SpecimenType") );
				}
			}
			/// <summary>
			/// UC034 class
			/// </summary>
			public sealed class UC034
			{
				/// <summary>
				/// EnterThresholdResult class
				/// </summary>
				public static StringResourceItem EnterThresholdResult()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC034.EnterThresholdResult") );
				}

				/// <summary>
				/// SaveTransfusionCompliance class
				/// </summary>
				public static StringResourceItem SaveTransfusionCompliance()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC034.SaveTransfusionCompliance") );
				}

				/// <summary>
				/// SaveTransfusionEffectiveness class
				/// </summary>
				public static StringResourceItem SaveTransfusionEffectiveness()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC034.SaveTransfusionEffectiveness") );
				}

				/// <summary>
				/// TextThreshold class
				/// </summary>
				public static StringResourceItem TextThreshold()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC034.TextThreshold") );
				}

				/// <summary>
				/// TransfusionComplications class
				/// </summary>
				public static StringResourceItem TransfusionComplications()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC034.TransfusionComplications") );
				}

				/// <summary>
				/// TransfusionEffectiveness class
				/// </summary>
				public static StringResourceItem TransfusionEffectiveness()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC034.TransfusionEffectiveness") );
				}
			}
			/// <summary>
			/// UC038 class
			/// </summary>
			public sealed class UC038
			{
				/// <summary>
				/// EnterAntibody class
				/// </summary>
				public static StringResourceItem EnterAntibody()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC038.EnterAntibody") );
				}

				/// <summary>
				/// EnterAntigen class
				/// </summary>
				public static StringResourceItem EnterAntigen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC038.EnterAntigen") );
				}

				/// <summary>
				/// EnterComponentRequirement class
				/// </summary>
				public static StringResourceItem EnterComponentRequirement()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC038.EnterComponentRequirement") );
				}

				/// <summary>
				/// EnterSpecialInstruction class
				/// </summary>
				public static StringResourceItem EnterSpecialInstruction()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC038.EnterSpecialInstruction") );
				}
			}
			/// <summary>
			/// UC041 class
			/// </summary>
			public sealed class UC041
			{
				/// <summary>
				/// AddUpdateAntiseraSpecificity class
				/// </summary>
				public static StringResourceItem AddUpdateAntiseraSpecificity()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.AddUpdateAntiseraSpecificity") );
				}

				/// <summary>
				/// ClickToDeleteWorklist class
				/// </summary>
				public static StringResourceItem ClickToDeleteWorklist()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.ClickToDeleteWorklist") );
				}

				/// <summary>
				/// DefineAntiseraSpecificity class
				/// </summary>
				public static StringResourceItem DefineAntiseraSpecificity()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.DefineAntiseraSpecificity") );
				}

				/// <summary>
				/// EnterLotNumbers class
				/// </summary>
				public static StringResourceItem EnterLotNumbers()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.EnterLotNumbers") );
				}

				/// <summary>
				/// EnterVialIdentifiers class
				/// </summary>
				public static StringResourceItem EnterVialIdentifiers()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.EnterVialIdentifiers") );
				}

				/// <summary>
				/// ExpiredAntiserum class
				/// </summary>
				public static StringResourceItem ExpiredAntiserum(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.ExpiredAntiserum"), arg0 );
				}

				/// <summary>
				/// InvalidAntigenTyping class
				/// </summary>
				public static StringResourceItem InvalidAntigenTyping()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.InvalidAntigenTyping") );
				}

				/// <summary>
				/// InvalidNegControlInterp class
				/// </summary>
				public static StringResourceItem InvalidNegControlInterp()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.InvalidNegControlInterp") );
				}

				/// <summary>
				/// InvalidPosControlInterp class
				/// </summary>
				public static StringResourceItem InvalidPosControlInterp()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.InvalidPosControlInterp") );
				}

				/// <summary>
				/// InvalidQCResults class
				/// </summary>
				public static StringResourceItem InvalidQCResults()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.InvalidQCResults") );
				}

				/// <summary>
				/// InvalidWeakDTyping class
				/// </summary>
				public static StringResourceItem InvalidWeakDTyping()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.InvalidWeakDTyping") );
				}

				/// <summary>
				/// SelectAntigenTypingWorklist class
				/// </summary>
				public static StringResourceItem SelectAntigenTypingWorklist()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.SelectAntigenTypingWorklist") );
				}
			}
			/// <summary>
			/// UC043 class
			/// </summary>
			public sealed class UC043
			{
				/// <summary>
				/// ChooseUnit class
				/// </summary>
				public static StringResourceItem ChooseUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.ChooseUnit") );
				}

				/// <summary>
				/// NoPatient class
				/// </summary>
				public static StringResourceItem NoPatient()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.NoPatient") );
				}

				/// <summary>
				/// NoTags class
				/// </summary>
				public static StringResourceItem NoTags()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.NoTags") );
				}

				/// <summary>
				/// NoUnits class
				/// </summary>
				public static StringResourceItem NoUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.NoUnits") );
				}
			}
			/// <summary>
			/// UC045 class
			/// </summary>
			public sealed class UC045
			{
				/// <summary>
				/// EnableOKOrderPanel class
				/// </summary>
				public static StringResourceItem EnableOKOrderPanel()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC045.EnableOKOrderPanel") );
				}

				/// <summary>
				/// EnableOKSearchPanel class
				/// </summary>
				public static StringResourceItem EnableOKSearchPanel()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC045.EnableOKSearchPanel") );
				}
			}
			/// <summary>
			/// UC047 class
			/// </summary>
			public sealed class UC047
			{
				/// <summary>
				/// SelectUnit class
				/// </summary>
				public static StringResourceItem SelectUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC047.SelectUnit") );
				}
			}
			/// <summary>
			/// UC048 class
			/// </summary>
			public sealed class UC048
			{
				/// <summary>
				/// SelectReportSection class
				/// </summary>
				public static StringResourceItem SelectReportSection()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC048.SelectReportSection") );
				}
			}
			/// <summary>
			/// UC049 class
			/// </summary>
			public sealed class UC049
			{
				/// <summary>
				/// SelectReportType class
				/// </summary>
				public static StringResourceItem SelectReportType()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC049.SelectReportType") );
				}
			}
			/// <summary>
			/// UC050 class
			/// </summary>
			public sealed class UC050
			{
				/// <summary>
				/// AddUpdateInappropriateRequestIndicator class
				/// </summary>
				public static StringResourceItem AddUpdateInappropriateRequestIndicator()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC050.AddUpdateInappropriateRequestIndicator") );
				}

				/// <summary>
				/// ClickToSave class
				/// </summary>
				public static StringResourceItem ClickToSave()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC050.ClickToSave") );
				}

				/// <summary>
				/// ComponentClass class
				/// </summary>
				public static StringResourceItem ComponentClass()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC050.ComponentClass") );
				}

				/// <summary>
				/// InappropriateTransfusionRequests class
				/// </summary>
				public static StringResourceItem InappropriateTransfusionRequests()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC050.InappropriateTransfusionRequests") );
				}

				/// <summary>
				/// LabTestName class
				/// </summary>
				public static StringResourceItem LabTestName()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC050.LabTestName") );
				}

				/// <summary>
				/// LabTestSerach class
				/// </summary>
				public static StringResourceItem LabTestSerach()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC050.LabTestSerach") );
				}

				/// <summary>
				/// MaxSpecimenTransfusionTime class
				/// </summary>
				public static StringResourceItem MaxSpecimenTransfusionTime()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC050.MaxSpecimenTransfusionTime") );
				}

				/// <summary>
				/// NumericThreshold class
				/// </summary>
				public static StringResourceItem NumericThreshold()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC050.NumericThreshold") );
				}

				/// <summary>
				/// SpecimemRequired class
				/// </summary>
				public static StringResourceItem SpecimemRequired()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC050.SpecimemRequired") );
				}
			}
			/// <summary>
			/// UC051 class
			/// </summary>
			public sealed class UC051
			{
				/// <summary>
				/// AlertTime class
				/// </summary>
				public static StringResourceItem AlertTime()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC051.AlertTime") );
				}

				/// <summary>
				/// CannotChangeMinimumReaction class
				/// </summary>
				public static StringResourceItem CannotChangeMinimumReaction()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC051.CannotChangeMinimumReaction") );
				}

				/// <summary>
				/// Commercial class
				/// </summary>
				public static StringResourceItem Commercial()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC051.Commercial") );
				}

				/// <summary>
				/// EditMinimumReaction class
				/// </summary>
				public static StringResourceItem EditMinimumReaction()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC051.EditMinimumReaction") );
				}

				/// <summary>
				/// NonCommercial class
				/// </summary>
				public static StringResourceItem NonCommercial()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC051.NonCommercial") );
				}

				/// <summary>
				/// NumberOfRacks class
				/// </summary>
				public static StringResourceItem NumberOfRacks()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC051.NumberOfRacks") );
				}

				/// <summary>
				/// PrimaryEnhancement class
				/// </summary>
				public static StringResourceItem PrimaryEnhancement()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC051.PrimaryEnhancement") );
				}

				/// <summary>
				/// SecondaryEnhancement class
				/// </summary>
				public static StringResourceItem SecondaryEnhancement()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC051.SecondaryEnhancement") );
				}

				/// <summary>
				/// SelectReagentType class
				/// </summary>
				public static StringResourceItem SelectReagentType()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC051.SelectReagentType") );
				}
			}
			/// <summary>
			/// UC056 class
			/// </summary>
			public sealed class UC056
			{
				/// <summary>
				/// ABORhError class
				/// </summary>
				public static StringResourceItem ABORhError()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.ABORhError") );
				}

				/// <summary>
				/// ABSError class
				/// </summary>
				public static StringResourceItem ABSError()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.ABSError") );
				}

				/// <summary>
				/// AntibodyIDError class
				/// </summary>
				public static StringResourceItem AntibodyIDError()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.AntibodyIDError") );
				}

				/// <summary>
				/// AntigenTypingError class
				/// </summary>
				public static StringResourceItem AntigenTypingError()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.AntigenTypingError") );
				}

				/// <summary>
				/// ChooseComment class
				/// </summary>
				public static StringResourceItem ChooseComment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.ChooseComment") );
				}

				/// <summary>
				/// ChooseLotNumber class
				/// </summary>
				public static StringResourceItem ChooseLotNumber()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.ChooseLotNumber") );
				}

				/// <summary>
				/// ChoosePhase class
				/// </summary>
				public static StringResourceItem ChoosePhase()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.ChoosePhase") );
				}

				/// <summary>
				/// ChooseRack class
				/// </summary>
				public static StringResourceItem ChooseRack()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.ChooseRack") );
				}

				/// <summary>
				/// ChooseTestedBy class
				/// </summary>
				public static StringResourceItem ChooseTestedBy()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.ChooseTestedBy") );
				}

				/// <summary>
				/// DATCompError class
				/// </summary>
				public static StringResourceItem DATCompError()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.DATCompError") );
				}

				/// <summary>
				/// DATError class
				/// </summary>
				public static StringResourceItem DATError()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.DATError") );
				}

				/// <summary>
				/// DATIgGError class
				/// </summary>
				public static StringResourceItem DATIgGError()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.DATIgGError") );
				}

				/// <summary>
				/// EnterAutoInstrument class
				/// </summary>
				public static StringResourceItem EnterAutoInstrument()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.EnterAutoInstrument") );
				}

				/// <summary>
				/// XMError class
				/// </summary>
				public static StringResourceItem XMError()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.XMError") );
				}
			}
			/// <summary>
			/// UC058 class
			/// </summary>
			public sealed class UC058
			{
				/// <summary>
				/// UpdateReagentType class
				/// </summary>
				public static StringResourceItem UpdateReagentType()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC058.UpdateReagentType") );
				}
			}
			/// <summary>
			/// UC068 class
			/// </summary>
			public sealed class UC068
			{
				/// <summary>
				/// AlertCleared class
				/// </summary>
				public static StringResourceItem AlertCleared()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC068.AlertCleared") );
				}

				/// <summary>
				/// SelectMergePatient class
				/// </summary>
				public static StringResourceItem SelectMergePatient()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC068.SelectMergePatient") );
				}
			}
			/// <summary>
			/// UC070 class
			/// </summary>
			public sealed class UC070
			{
				/// <summary>
				/// SelectTest class
				/// </summary>
				public static StringResourceItem SelectTest()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC070.SelectTest") );
				}
			}
			/// <summary>
			/// UC071 class
			/// </summary>
			public sealed class UC071
			{
				/// <summary>
				/// RemoveRestriction class
				/// </summary>
				public static StringResourceItem RemoveRestriction()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC071.RemoveRestriction") );
				}
			}
			/// <summary>
			/// UC078 class
			/// </summary>
			public sealed class UC078
			{
				/// <summary>
				/// CommentRequired class
				/// </summary>
				public static StringResourceItem CommentRequired()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC078.CommentRequired") );
				}

				/// <summary>
				/// OKToFinalize class
				/// </summary>
				public static StringResourceItem OKToFinalize()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC078.OKToFinalize") );
				}
			}
			/// <summary>
			/// UC081 class
			/// </summary>
			public sealed class UC081
			{
				/// <summary>
				/// AddOneSupply class
				/// </summary>
				public static StringResourceItem AddOneSupply()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC081.AddOneSupply") );
				}

				/// <summary>
				/// AddSupplyToList class
				/// </summary>
				public static StringResourceItem AddSupplyToList()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC081.AddSupplyToList") );
				}

				/// <summary>
				/// CriteriaOkButton class
				/// </summary>
				public static StringResourceItem CriteriaOkButton()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC081.CriteriaOkButton") );
				}

				/// <summary>
				/// CriteriaSupplyListView class
				/// </summary>
				public static StringResourceItem CriteriaSupplyListView()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC081.CriteriaSupplyListView") );
				}

				/// <summary>
				/// SearchForLotNumber class
				/// </summary>
				public static StringResourceItem SearchForLotNumber()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC081.SearchForLotNumber") );
				}
			}
			/// <summary>
			/// UC084 class
			/// </summary>
			public sealed class UC084
			{
				/// <summary>
				/// OrderUpdates class
				/// </summary>
				public static StringResourceItem OrderUpdates(object arg0)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC084.OrderUpdates"), arg0 );
				}

				/// <summary>
				/// PatientDeaths class
				/// </summary>
				public static StringResourceItem PatientDeaths()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC084.PatientDeaths") );
				}

				/// <summary>
				/// PatientMerges class
				/// </summary>
				public static StringResourceItem PatientMerges()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC084.PatientMerges") );
				}

				/// <summary>
				/// PatientUpdates class
				/// </summary>
				public static StringResourceItem PatientUpdates()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC084.PatientUpdates") );
				}
			}
			/// <summary>
			/// UC092 class
			/// </summary>
			public sealed class UC092
			{
				/// <summary>
				/// SelectAtLeastOne class
				/// </summary>
				public static StringResourceItem SelectAtLeastOne()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC092.SelectAtLeastOne") );
				}

				/// <summary>
				/// SelectAtLeastOneNotStarted class
				/// </summary>
				public static StringResourceItem SelectAtLeastOneNotStarted()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC092.SelectAtLeastOneNotStarted") );
				}

				/// <summary>
				/// TooManyNotStartedSelected class
				/// </summary>
				public static StringResourceItem TooManyNotStartedSelected()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC092.TooManyNotStartedSelected") );
				}

				/// <summary>
				/// TooManySelected class
				/// </summary>
				public static StringResourceItem TooManySelected()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC092.TooManySelected") );
				}
			}
			/// <summary>
			/// UC095 class
			/// </summary>
			public sealed class UC095
			{
				/// <summary>
				/// IconAlerts class
				/// </summary>
				public static StringResourceItem IconAlerts()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC095.IconAlerts") );
				}

				/// <summary>
				/// LoginMessage class
				/// </summary>
				public static StringResourceItem LoginMessage()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC095.LoginMessage") );
				}

				/// <summary>
				/// OrderAlertType class
				/// </summary>
				public static StringResourceItem OrderAlertType()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC095.OrderAlertType") );
				}

				/// <summary>
				/// OrdersNeededIn class
				/// </summary>
				public static StringResourceItem OrdersNeededIn()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC095.OrdersNeededIn") );
				}

				/// <summary>
				/// PrinterAlerts class
				/// </summary>
				public static StringResourceItem PrinterAlerts()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC095.PrinterAlerts") );
				}

				/// <summary>
				/// RefreshRate class
				/// </summary>
				public static StringResourceItem RefreshRate()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC095.RefreshRate") );
				}
			}
			/// <summary>
			/// UC098 class
			/// </summary>
			public sealed class UC098
			{
				/// <summary>
				/// HistoricalMismatch class
				/// </summary>
				public static StringResourceItem HistoricalMismatch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC098.HistoricalMismatch") );
				}

				/// <summary>
				/// ISOnlyResults class
				/// </summary>
				public static StringResourceItem ISOnlyResults()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC098.ISOnlyResults") );
				}
			}
			/// <summary>
			/// UC100 class
			/// </summary>
			public sealed class UC100
			{
				/// <summary>
				/// JustifiedABORh class
				/// </summary>
				public static StringResourceItem JustifiedABORh()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC100.JustifiedABORh") );
				}
			}
			/// <summary>
			/// UC102 class
			/// </summary>
			public sealed class UC102
			{
				/// <summary>
				/// VistAChangeVerifyCodebtnCancel class
				/// </summary>
				public static StringResourceItem VistAChangeVerifyCodebtnCancel()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.VistAChangeVerifyCodebtnCancel") );
				}

				/// <summary>
				/// VistAChangeVerifyCodebtnContinue class
				/// </summary>
				public static StringResourceItem VistAChangeVerifyCodebtnContinue()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.VistAChangeVerifyCodebtnContinue") );
				}

				/// <summary>
				/// VistAChangeVerifyCodetxtNewCheckVerifyCode class
				/// </summary>
				public static StringResourceItem VistAChangeVerifyCodetxtNewCheckVerifyCode()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.VistAChangeVerifyCodetxtNewCheckVerifyCode") );
				}

				/// <summary>
				/// VistAChangeVerifyCodetxtNewVerifyCode class
				/// </summary>
				public static StringResourceItem VistAChangeVerifyCodetxtNewVerifyCode()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.VistAChangeVerifyCodetxtNewVerifyCode") );
				}

				/// <summary>
				/// VistAChangeVerifyCodetxtOldVerifyCode class
				/// </summary>
				public static StringResourceItem VistAChangeVerifyCodetxtOldVerifyCode()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.VistAChangeVerifyCodetxtOldVerifyCode") );
				}

				/// <summary>
				/// VistASignOnbtnCancel class
				/// </summary>
				public static StringResourceItem VistASignOnbtnCancel()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.VistASignOnbtnCancel") );
				}

				/// <summary>
				/// VistASignOnbtnSignOn class
				/// </summary>
				public static StringResourceItem VistASignOnbtnSignOn()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.VistASignOnbtnSignOn") );
				}

				/// <summary>
				/// VistASignOnchbChangeVerifyCode class
				/// </summary>
				public static StringResourceItem VistASignOnchbChangeVerifyCode()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.VistASignOnchbChangeVerifyCode") );
				}

				/// <summary>
				/// VistASignOntxtAccessCode class
				/// </summary>
				public static StringResourceItem VistASignOntxtAccessCode()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.VistASignOntxtAccessCode") );
				}

				/// <summary>
				/// VistASignOntxtIntroText class
				/// </summary>
				public static StringResourceItem VistASignOntxtIntroText()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.VistASignOntxtIntroText") );
				}

				/// <summary>
				/// VistASignOntxtVerifyCode class
				/// </summary>
				public static StringResourceItem VistASignOntxtVerifyCode()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.VistASignOntxtVerifyCode") );
				}
			}
			/// <summary>
			/// UC103 class
			/// </summary>
			public sealed class UC103
			{
				/// <summary>
				/// RestoreVistALinkConnectionbtnCancelCloseFailure class
				/// </summary>
				public static StringResourceItem RestoreVistALinkConnectionbtnCancelCloseFailure()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC103.RestoreVistALinkConnectionbtnCancelCloseFailure") );
				}

				/// <summary>
				/// RestoreVistALinkConnectionbtnCancelCloseWhileRestoring class
				/// </summary>
				public static StringResourceItem RestoreVistALinkConnectionbtnCancelCloseWhileRestoring()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC103.RestoreVistALinkConnectionbtnCancelCloseWhileRestoring") );
				}

				/// <summary>
				/// RestoreVistALinkConnectionbtnCancelDefault class
				/// </summary>
				public static StringResourceItem RestoreVistALinkConnectionbtnCancelDefault()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC103.RestoreVistALinkConnectionbtnCancelDefault") );
				}

				/// <summary>
				/// RestoreVistALinkConnectionbtnRestoreDefault class
				/// </summary>
				public static StringResourceItem RestoreVistALinkConnectionbtnRestoreDefault()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC103.RestoreVistALinkConnectionbtnRestoreDefault") );
				}

				/// <summary>
				/// RestoreVistALinkConnectionbtnRestoreEndState class
				/// </summary>
				public static StringResourceItem RestoreVistALinkConnectionbtnRestoreEndState()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC103.RestoreVistALinkConnectionbtnRestoreEndState") );
				}

				/// <summary>
				/// RestoreVistALinkConnectionbtnRestoreIsInProgress class
				/// </summary>
				public static StringResourceItem RestoreVistALinkConnectionbtnRestoreIsInProgress()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC103.RestoreVistALinkConnectionbtnRestoreIsInProgress") );
				}
			}
			/// <summary>
			/// UnitTest class
			/// </summary>
			public sealed class UnitTest
			{
				/// <summary>
				/// TestString class
				/// </summary>
				public static StringResourceItem TestString(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UnitTest.TestString"), arg0, arg1 );
				}
			}
		}

		/// <summary>
		/// MessageTitles class
		/// </summary>
		public sealed class MessageTitles
		{
			private const StringResourceType _classResType = StringResourceType.MessageTitle;
			private static readonly ResourceManager _resourceManager = CreateResourceManagerInstance("MessageTitles");

			private MessageTitles(){}
			static MessageTitles(){}	// get rid of "beforefieldinit" attribute (DON'T REMOVE!)


			/// <summary>
			/// GuiMessageTitle class
			/// </summary>
			public sealed class GuiMessageTitle
			{
				/// <summary>
				/// Confirmation class
				/// </summary>
				public static StringResourceItem Confirmation()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("GuiMessageTitle.Confirmation") );
				}

				/// <summary>
				/// Information class
				/// </summary>
				public static StringResourceItem Information()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("GuiMessageTitle.Information") );
				}

				/// <summary>
				/// Other class
				/// </summary>
				public static StringResourceItem Other()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("GuiMessageTitle.Other") );
				}

				/// <summary>
				/// Prompt class
				/// </summary>
				public static StringResourceItem Prompt()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("GuiMessageTitle.Prompt") );
				}

				/// <summary>
				/// SystemError class
				/// </summary>
				public static StringResourceItem SystemError()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("GuiMessageTitle.SystemError") );
				}

				/// <summary>
				/// Tooltip class
				/// </summary>
				public static StringResourceItem Tooltip()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("GuiMessageTitle.Tooltip") );
				}

				/// <summary>
				/// Validation class
				/// </summary>
				public static StringResourceItem Validation()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("GuiMessageTitle.Validation") );
				}
			}
			/// <summary>
			/// UnitTest class
			/// </summary>
			public sealed class UnitTest
			{
				/// <summary>
				/// TestString class
				/// </summary>
				public static StringResourceItem TestString(object arg0, object arg1)
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UnitTest.TestString"), arg0, arg1 );
				}
			}
		}

		/// <summary>
		/// Help Mappings class
		/// </summary>
		public sealed class HelpFiles
		{
			private const StringResourceType _classResType = StringResourceType.HelpFileMappings;
			private static readonly ResourceManager _resourceManager = CreateResourceManagerInstance("HelpFileMappings");

			private HelpFiles(){}
			static HelpFiles(){}	// get rid of "beforefieldinit" attribute (DON'T REMOVE!)


			/// <summary>
			/// Common class
			/// </summary>
			public sealed class Common
			{
				/// <summary>
				/// DlgSelectBloodProduct class
				/// </summary>
				public static StringResourceItem DlgSelectBloodProduct()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DlgSelectBloodProduct") );
				}

				/// <summary>
				/// DlgSelectBloodUnits class
				/// </summary>
				public static StringResourceItem DlgSelectBloodUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.DlgSelectBloodUnits") );
				}

				/// <summary>
				/// FrmPatientSelect class
				/// </summary>
				public static StringResourceItem FrmPatientSelect()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.FrmPatientSelect") );
				}

				/// <summary>
				/// PatientInfoToolbar class
				/// </summary>
				public static StringResourceItem PatientInfoToolbar()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PatientInfoToolbar") );
				}

				/// <summary>
				/// PatientSelectTool class
				/// </summary>
				public static StringResourceItem PatientSelectTool()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.PatientSelectTool") );
				}

				/// <summary>
				/// SpecialInstructionsDisplayPanel class
				/// </summary>
				public static StringResourceItem SpecialInstructionsDisplayPanel()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("Common.SpecialInstructionsDisplayPanel") );
				}
			}
			/// <summary>
			/// UC001 class
			/// </summary>
			public sealed class UC001
			{
				/// <summary>
				/// DlgSelectIncomingShipment class
				/// </summary>
				public static StringResourceItem DlgSelectIncomingShipment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.DlgSelectIncomingShipment") );
				}

				/// <summary>
				/// FrmProcessShipmentIn class
				/// </summary>
				public static StringResourceItem FrmProcessShipmentIn()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.FrmProcessShipmentIn") );
				}

				/// <summary>
				/// FrmShipmentIn class
				/// </summary>
				public static StringResourceItem FrmShipmentIn()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC001.FrmShipmentIn") );
				}
			}
			/// <summary>
			/// UC002 class
			/// </summary>
			public sealed class UC002
			{
				/// <summary>
				/// FrmAboRHConfirmProcess class
				/// </summary>
				public static StringResourceItem FrmAboRHConfirmProcess()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC002.FrmAboRHConfirmProcess") );
				}

				/// <summary>
				/// FrmAboRHConfirmProcess_Units class
				/// </summary>
				public static StringResourceItem FrmAboRHConfirmProcess_Units()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC002.FrmAboRHConfirmProcess_Units") );
				}

				/// <summary>
				/// FrmAboRHConfirmProcess_Worksheet class
				/// </summary>
				public static StringResourceItem FrmAboRHConfirmProcess_Worksheet()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC002.FrmAboRHConfirmProcess_Worksheet") );
				}

				/// <summary>
				/// FrmAboRHSelectInvoice class
				/// </summary>
				public static StringResourceItem FrmAboRHSelectInvoice()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC002.FrmAboRHSelectInvoice") );
				}

				/// <summary>
				/// FrmAboRHSelectInvoice_Rack class
				/// </summary>
				public static StringResourceItem FrmAboRHSelectInvoice_Rack()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC002.FrmAboRHSelectInvoice_Rack") );
				}
			}
			/// <summary>
			/// UC003 class
			/// </summary>
			public sealed class UC003
			{
				/// <summary>
				/// DlgSelectDirectedUnits class
				/// </summary>
				public static StringResourceItem DlgSelectDirectedUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.DlgSelectDirectedUnits") );
				}

				/// <summary>
				/// DlgSelectUnitOverride class
				/// </summary>
				public static StringResourceItem DlgSelectUnitOverride()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.DlgSelectUnitOverride") );
				}

				/// <summary>
				/// FrmSelectUnitsForPatient class
				/// </summary>
				public static StringResourceItem FrmSelectUnitsForPatient()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.FrmSelectUnitsForPatient") );
				}

				/// <summary>
				/// FrmSelectUnitsForPatient_SelectUnits class
				/// </summary>
				public static StringResourceItem FrmSelectUnitsForPatient_SelectUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC003.FrmSelectUnitsForPatient_SelectUnits") );
				}
			}
			/// <summary>
			/// UC006 class
			/// </summary>
			public sealed class UC006
			{
				/// <summary>
				/// DlgFacilitySearch class
				/// </summary>
				public static StringResourceItem DlgFacilitySearch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.DlgFacilitySearch") );
				}

				/// <summary>
				/// FrmCollectionFacilityMaintain class
				/// </summary>
				public static StringResourceItem FrmCollectionFacilityMaintain()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC006.FrmCollectionFacilityMaintain") );
				}
			}
			/// <summary>
			/// UC008 class
			/// </summary>
			public sealed class UC008
			{
				/// <summary>
				/// DlgBloodProductSelect class
				/// </summary>
				public static StringResourceItem DlgBloodProductSelect()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.DlgBloodProductSelect") );
				}

				/// <summary>
				/// DlgHcpcsHistory class
				/// </summary>
				public static StringResourceItem DlgHcpcsHistory()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.DlgHcpcsHistory") );
				}

				/// <summary>
				/// FrmBloodProductEdit class
				/// </summary>
				public static StringResourceItem FrmBloodProductEdit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC008.FrmBloodProductEdit") );
				}
			}
			/// <summary>
			/// UC009 class
			/// </summary>
			public sealed class UC009
			{
				/// <summary>
				/// DlgMaintainDivision class
				/// </summary>
				public static StringResourceItem DlgMaintainDivision()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC009.DlgMaintainDivision") );
				}
			}
			/// <summary>
			/// UC010 class
			/// </summary>
			public sealed class UC010
			{
				/// <summary>
				/// DlgMaintainDivision class
				/// </summary>
				public static StringResourceItem DlgMaintainDivision()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC010.DlgMaintainDivision") );
				}
			}
			/// <summary>
			/// UC011 class
			/// </summary>
			public sealed class UC011
			{
				/// <summary>
				/// DlgGetShipmentDate class
				/// </summary>
				public static StringResourceItem DlgGetShipmentDate()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.DlgGetShipmentDate") );
				}

				/// <summary>
				/// DlgModifyReturnCredit class
				/// </summary>
				public static StringResourceItem DlgModifyReturnCredit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.DlgModifyReturnCredit") );
				}

				/// <summary>
				/// DlgShipmentOut_New class
				/// </summary>
				public static StringResourceItem DlgShipmentOut_New()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.DlgShipmentOut_New") );
				}

				/// <summary>
				/// DlgShipmentOut_Recent class
				/// </summary>
				public static StringResourceItem DlgShipmentOut_Recent()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.DlgShipmentOut_Recent") );
				}

				/// <summary>
				/// DlgViewInvoice class
				/// </summary>
				public static StringResourceItem DlgViewInvoice()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.DlgViewInvoice") );
				}

				/// <summary>
				/// FrmProcessShipmentOut class
				/// </summary>
				public static StringResourceItem FrmProcessShipmentOut()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC011.FrmProcessShipmentOut") );
				}
			}
			/// <summary>
			/// UC013 class
			/// </summary>
			public sealed class UC013
			{
				/// <summary>
				/// FrmInvalidateFinalStatus class
				/// </summary>
				public static StringResourceItem FrmInvalidateFinalStatus()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC013.FrmInvalidateFinalStatus") );
				}
			}
			/// <summary>
			/// UC014 class
			/// </summary>
			public sealed class UC014
			{
				/// <summary>
				/// FrmEditUnitFinancial class
				/// </summary>
				public static StringResourceItem FrmEditUnitFinancial()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC014.FrmEditUnitFinancial") );
				}
			}
			/// <summary>
			/// UC016 class
			/// </summary>
			public sealed class UC016
			{
				/// <summary>
				/// DlgMsbos class
				/// </summary>
				public static StringResourceItem DlgMsbos()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.DlgMsbos") );
				}

				/// <summary>
				/// DlgOrderDetails class
				/// </summary>
				public static StringResourceItem DlgOrderDetails()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.DlgOrderDetails") );
				}

				/// <summary>
				/// DlgOverride class
				/// </summary>
				public static StringResourceItem DlgOverride()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.DlgOverride") );
				}

				/// <summary>
				/// DlgViewAutologousDirectedUnits class
				/// </summary>
				public static StringResourceItem DlgViewAutologousDirectedUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.DlgViewAutologousDirectedUnits") );
				}

				/// <summary>
				/// FrmPendingOrderPrint class
				/// </summary>
				public static StringResourceItem FrmPendingOrderPrint()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.FrmPendingOrderPrint") );
				}

				/// <summary>
				/// FrmPendingOrderSearch class
				/// </summary>
				public static StringResourceItem FrmPendingOrderSearch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.FrmPendingOrderSearch") );
				}

				/// <summary>
				/// FrmPendingOrderSearch_Details class
				/// </summary>
				public static StringResourceItem FrmPendingOrderSearch_Details()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.FrmPendingOrderSearch_Details") );
				}

				/// <summary>
				/// FrmPendingOrderSearch_MSBOS class
				/// </summary>
				public static StringResourceItem FrmPendingOrderSearch_MSBOS()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.FrmPendingOrderSearch_MSBOS") );
				}

				/// <summary>
				/// FrmPendingOrderSearch_POL class
				/// </summary>
				public static StringResourceItem FrmPendingOrderSearch_POL()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC016.FrmPendingOrderSearch_POL") );
				}
			}
			/// <summary>
			/// UC017 class
			/// </summary>
			public sealed class UC017
			{
				/// <summary>
				/// FrmEditInvoiceText class
				/// </summary>
				public static StringResourceItem FrmEditInvoiceText()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC017.FrmEditInvoiceText") );
				}
			}
			/// <summary>
			/// UC018 class
			/// </summary>
			public sealed class UC018
			{
				/// <summary>
				/// DlgDivisionLogonPopup class
				/// </summary>
				public static StringResourceItem DlgDivisionLogonPopup()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.DlgDivisionLogonPopup") );
				}

				/// <summary>
				/// DlgSelectDivision class
				/// </summary>
				public static StringResourceItem DlgSelectDivision()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC018.DlgSelectDivision") );
				}
			}
			/// <summary>
			/// UC019 class
			/// </summary>
			public sealed class UC019
			{
				/// <summary>
				/// FrmUpdateUser class
				/// </summary>
				public static StringResourceItem FrmUpdateUser()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC019.FrmUpdateUser") );
				}

				/// <summary>
				/// FrmUpdateUser_View class
				/// </summary>
				public static StringResourceItem FrmUpdateUser_View()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC019.FrmUpdateUser_View") );
				}
			}
			/// <summary>
			/// UC020 class
			/// </summary>
			public sealed class UC020
			{
				/// <summary>
				/// DlgReagentInventorySearch class
				/// </summary>
				public static StringResourceItem DlgReagentInventorySearch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC020.DlgReagentInventorySearch") );
				}

				/// <summary>
				/// FrmLogInReagents class
				/// </summary>
				public static StringResourceItem FrmLogInReagents()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC020.FrmLogInReagents") );
				}

				/// <summary>
				/// FrmUpdateReagentInventory class
				/// </summary>
				public static StringResourceItem FrmUpdateReagentInventory()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC020.FrmUpdateReagentInventory") );
				}

				/// <summary>
				/// FrmViewReagentInventory class
				/// </summary>
				public static StringResourceItem FrmViewReagentInventory()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC020.FrmViewReagentInventory") );
				}
			}
			/// <summary>
			/// UC021 class
			/// </summary>
			public sealed class UC021
			{
				/// <summary>
				/// FrmTransfusionReactionWorkup class
				/// </summary>
				public static StringResourceItem FrmTransfusionReactionWorkup()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.FrmTransfusionReactionWorkup") );
				}

				/// <summary>
				/// FrmTransfusionReactionWorkup_Symptoms class
				/// </summary>
				public static StringResourceItem FrmTransfusionReactionWorkup_Symptoms()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC021.FrmTransfusionReactionWorkup_Symptoms") );
				}
			}
			/// <summary>
			/// UC022 class
			/// </summary>
			public sealed class UC022
			{
				/// <summary>
				/// DlgSelectAddress class
				/// </summary>
				public static StringResourceItem DlgSelectAddress()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.DlgSelectAddress") );
				}

				/// <summary>
				/// FrmEquipmentInventory class
				/// </summary>
				public static StringResourceItem FrmEquipmentInventory()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.FrmEquipmentInventory") );
				}

				/// <summary>
				/// FrmLoginEquipment class
				/// </summary>
				public static StringResourceItem FrmLoginEquipment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.FrmLoginEquipment") );
				}

				/// <summary>
				/// FrmMaintainEquipment class
				/// </summary>
				public static StringResourceItem FrmMaintainEquipment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC022.FrmMaintainEquipment") );
				}
			}
			/// <summary>
			/// UC023 class
			/// </summary>
			public sealed class UC023
			{
				/// <summary>
				/// DlgMaintainAntibodies class
				/// </summary>
				public static StringResourceItem DlgMaintainAntibodies()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC023.DlgMaintainAntibodies") );
				}
			}
			/// <summary>
			/// UC024 class
			/// </summary>
			public sealed class UC024
			{
				/// <summary>
				/// DlgEditPool class
				/// </summary>
				public static StringResourceItem DlgEditPool()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.DlgEditPool") );
				}

				/// <summary>
				/// DlgExpiredUnitConfirm class
				/// </summary>
				public static StringResourceItem DlgExpiredUnitConfirm()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.DlgExpiredUnitConfirm") );
				}

				/// <summary>
				/// DlgModifyAssignments class
				/// </summary>
				public static StringResourceItem DlgModifyAssignments()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.DlgModifyAssignments") );
				}

				/// <summary>
				/// DlgModifyUnit class
				/// </summary>
				public static StringResourceItem DlgModifyUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.DlgModifyUnit") );
				}

				/// <summary>
				/// DlgSelectEquipment class
				/// </summary>
				public static StringResourceItem DlgSelectEquipment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.DlgSelectEquipment") );
				}

				/// <summary>
				/// DlgSelectMultipleUnits class
				/// </summary>
				public static StringResourceItem DlgSelectMultipleUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.DlgSelectMultipleUnits") );
				}

				/// <summary>
				/// DlgSelectSingleUnit class
				/// </summary>
				public static StringResourceItem DlgSelectSingleUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.DlgSelectSingleUnit") );
				}

				/// <summary>
				/// DlgSelectSupply class
				/// </summary>
				public static StringResourceItem DlgSelectSupply()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.DlgSelectSupply") );
				}

				/// <summary>
				/// DlgVerifyModifiedUnit class
				/// </summary>
				public static StringResourceItem DlgVerifyModifiedUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.DlgVerifyModifiedUnit") );
				}

				/// <summary>
				/// FrmPoolUnits class
				/// </summary>
				public static StringResourceItem FrmPoolUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC024.FrmPoolUnits") );
				}
			}
			/// <summary>
			/// UC025 class
			/// </summary>
			public sealed class UC025
			{
				/// <summary>
				/// DlgExpiredUnitConfirm class
				/// </summary>
				public static StringResourceItem DlgExpiredUnitConfirm()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC025.DlgExpiredUnitConfirm") );
				}

				/// <summary>
				/// DlgModifyAssignments class
				/// </summary>
				public static StringResourceItem DlgModifyAssignments()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC025.DlgModifyAssignments") );
				}

				/// <summary>
				/// DlgModifyUnit class
				/// </summary>
				public static StringResourceItem DlgModifyUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC025.DlgModifyUnit") );
				}

				/// <summary>
				/// DlgSelectEquipment class
				/// </summary>
				public static StringResourceItem DlgSelectEquipment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC025.DlgSelectEquipment") );
				}

				/// <summary>
				/// DlgSelectMultipleUnits class
				/// </summary>
				public static StringResourceItem DlgSelectMultipleUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC025.DlgSelectMultipleUnits") );
				}

				/// <summary>
				/// DlgSelectSingleUnit class
				/// </summary>
				public static StringResourceItem DlgSelectSingleUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC025.DlgSelectSingleUnit") );
				}

				/// <summary>
				/// DlgSelectSupply class
				/// </summary>
				public static StringResourceItem DlgSelectSupply()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC025.DlgSelectSupply") );
				}

				/// <summary>
				/// DlgVerifyModifiedUnit class
				/// </summary>
				public static StringResourceItem DlgVerifyModifiedUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC025.DlgVerifyModifiedUnit") );
				}

				/// <summary>
				/// FrmSplitUnit class
				/// </summary>
				public static StringResourceItem FrmSplitUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC025.FrmSplitUnit") );
				}
			}
			/// <summary>
			/// UC026 class
			/// </summary>
			public sealed class UC026
			{
				/// <summary>
				/// DlgExpiredUnitConfirm class
				/// </summary>
				public static StringResourceItem DlgExpiredUnitConfirm()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.DlgExpiredUnitConfirm") );
				}

				/// <summary>
				/// DlgModifyAssignments class
				/// </summary>
				public static StringResourceItem DlgModifyAssignments()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.DlgModifyAssignments") );
				}

				/// <summary>
				/// DlgModifyUnit class
				/// </summary>
				public static StringResourceItem DlgModifyUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.DlgModifyUnit") );
				}

				/// <summary>
				/// DlgSelectEquipment class
				/// </summary>
				public static StringResourceItem DlgSelectEquipment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.DlgSelectEquipment") );
				}

				/// <summary>
				/// DlgSelectMultipleUnits class
				/// </summary>
				public static StringResourceItem DlgSelectMultipleUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.DlgSelectMultipleUnits") );
				}

				/// <summary>
				/// DlgSelectSingleUnit class
				/// </summary>
				public static StringResourceItem DlgSelectSingleUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.DlgSelectSingleUnit") );
				}

				/// <summary>
				/// DlgSelectSupply class
				/// </summary>
				public static StringResourceItem DlgSelectSupply()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.DlgSelectSupply") );
				}

				/// <summary>
				/// DlgVerifyModifiedUnit class
				/// </summary>
				public static StringResourceItem DlgVerifyModifiedUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.DlgVerifyModifiedUnit") );
				}

				/// <summary>
				/// FrmModifyUnits class
				/// </summary>
				public static StringResourceItem FrmModifyUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC026.FrmModifyUnits") );
				}
			}
			/// <summary>
			/// UC027 class
			/// </summary>
			public sealed class UC027
			{
				/// <summary>
				/// DlgDiscardQuarantineChangeReimbursement class
				/// </summary>
				public static StringResourceItem DlgDiscardQuarantineChangeReimbursement()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC027.DlgDiscardQuarantineChangeReimbursement") );
				}

				/// <summary>
				/// DlgDiscardQuarantineInvoice class
				/// </summary>
				public static StringResourceItem DlgDiscardQuarantineInvoice()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC027.DlgDiscardQuarantineInvoice") );
				}

				/// <summary>
				/// FrmDiscardQuarantine_DiscardQuarantine class
				/// </summary>
				public static StringResourceItem FrmDiscardQuarantine_DiscardQuarantine()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC027.FrmDiscardQuarantine_DiscardQuarantine") );
				}

				/// <summary>
				/// FrmDiscardQuarantine_DiscardQuarantine_Shipment class
				/// </summary>
				public static StringResourceItem FrmDiscardQuarantine_DiscardQuarantine_Shipment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC027.FrmDiscardQuarantine_DiscardQuarantine_Shipment") );
				}

				/// <summary>
				/// FrmDiscardQuarantine_Shipment class
				/// </summary>
				public static StringResourceItem FrmDiscardQuarantine_Shipment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC027.FrmDiscardQuarantine_Shipment") );
				}

				/// <summary>
				/// FrmDiscardQuarantine_UnitSearch class
				/// </summary>
				public static StringResourceItem FrmDiscardQuarantine_UnitSearch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC027.FrmDiscardQuarantine_UnitSearch") );
				}
			}
			/// <summary>
			/// UC028 class
			/// </summary>
			public sealed class UC028
			{
				/// <summary>
				/// DlgSelectRack class
				/// </summary>
				public static StringResourceItem DlgSelectRack()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC028.DlgSelectRack") );
				}

				/// <summary>
				/// FrmDailyReagentRackQC class
				/// </summary>
				public static StringResourceItem FrmDailyReagentRackQC()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC028.FrmDailyReagentRackQC") );
				}

				/// <summary>
				/// FrmRecordLotNumbers class
				/// </summary>
				public static StringResourceItem FrmRecordLotNumbers()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC028.FrmRecordLotNumbers") );
				}
			}
			/// <summary>
			/// UC029 class
			/// </summary>
			public sealed class UC029
			{
				/// <summary>
				/// FrmAssignWorkloadCodes class
				/// </summary>
				public static StringResourceItem FrmAssignWorkloadCodes()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC029.FrmAssignWorkloadCodes") );
				}
			}
			/// <summary>
			/// UC031 class
			/// </summary>
			public sealed class UC031
			{
				/// <summary>
				/// FrmMaintainComments class
				/// </summary>
				public static StringResourceItem FrmMaintainComments()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC031.FrmMaintainComments") );
				}
			}
			/// <summary>
			/// UC032 class
			/// </summary>
			public sealed class UC032
			{
				/// <summary>
				/// DlgMsbos class
				/// </summary>
				public static StringResourceItem DlgMsbos()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC032.DlgMsbos") );
				}
			}
			/// <summary>
			/// UC033 class
			/// </summary>
			public sealed class UC033
			{
				/// <summary>
				/// DlgSelectLabTest class
				/// </summary>
				public static StringResourceItem DlgSelectLabTest()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC033.DlgSelectLabTest") );
				}

				/// <summary>
				/// FrmDefineEffectivenessTests class
				/// </summary>
				public static StringResourceItem FrmDefineEffectivenessTests()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC033.FrmDefineEffectivenessTests") );
				}
			}
			/// <summary>
			/// UC034 class
			/// </summary>
			public sealed class UC034
			{
				/// <summary>
				/// DlgSelectLabTest class
				/// </summary>
				public static StringResourceItem DlgSelectLabTest()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC034.DlgSelectLabTest") );
				}

				/// <summary>
				/// FrmMaintainComplications class
				/// </summary>
				public static StringResourceItem FrmMaintainComplications()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC034.FrmMaintainComplications") );
				}
			}
			/// <summary>
			/// UC035 class
			/// </summary>
			public sealed class UC035
			{
				/// <summary>
				/// DlgSpecimenSearch class
				/// </summary>
				public static StringResourceItem DlgSpecimenSearch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC035.DlgSpecimenSearch") );
				}

				/// <summary>
				/// FrmMaintainSpecimen class
				/// </summary>
				public static StringResourceItem FrmMaintainSpecimen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC035.FrmMaintainSpecimen") );
				}
			}
			/// <summary>
			/// UC036 class
			/// </summary>
			public sealed class UC036
			{
				/// <summary>
				/// DlgDisplayTransReqsAndSpecIns class
				/// </summary>
				public static StringResourceItem DlgDisplayTransReqsAndSpecIns()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC036.DlgDisplayTransReqsAndSpecIns") );
				}
			}
			/// <summary>
			/// UC037 class
			/// </summary>
			public sealed class UC037
			{
				/// <summary>
				/// DlgSitrInactivationComment class
				/// </summary>
				public static StringResourceItem DlgSitrInactivationComment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC037.DlgSitrInactivationComment") );
				}

				/// <summary>
				/// FrmDefineTransfusionReqs class
				/// </summary>
				public static StringResourceItem FrmDefineTransfusionReqs()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC037.FrmDefineTransfusionReqs") );
				}
			}
			/// <summary>
			/// UC038 class
			/// </summary>
			public sealed class UC038
			{
				/// <summary>
				/// DlgSitrInactivationComment class
				/// </summary>
				public static StringResourceItem DlgSitrInactivationComment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC038.DlgSitrInactivationComment") );
				}

				/// <summary>
				/// FrmDefineTransfusionReqs class
				/// </summary>
				public static StringResourceItem FrmDefineTransfusionReqs()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC038.FrmDefineTransfusionReqs") );
				}
			}
			/// <summary>
			/// UC040 class
			/// </summary>
			public sealed class UC040
			{
				/// <summary>
				/// FrmRecordTesting class
				/// </summary>
				public static StringResourceItem FrmRecordTesting()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC040.FrmRecordTesting") );
				}
			}
			/// <summary>
			/// UC041 class
			/// </summary>
			public sealed class UC041
			{
				/// <summary>
				/// DlgSelectDControl class
				/// </summary>
				public static StringResourceItem DlgSelectDControl()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.DlgSelectDControl") );
				}

				/// <summary>
				/// DlgSelectSpecificities_New class
				/// </summary>
				public static StringResourceItem DlgSelectSpecificities_New()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.DlgSelectSpecificities_New") );
				}

				/// <summary>
				/// DlgSelectSpecificities_Worksheet class
				/// </summary>
				public static StringResourceItem DlgSelectSpecificities_Worksheet()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.DlgSelectSpecificities_Worksheet") );
				}

				/// <summary>
				/// FrmRecordPhenotypeResults_Typing class
				/// </summary>
				public static StringResourceItem FrmRecordPhenotypeResults_Typing()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.FrmRecordPhenotypeResults_Typing") );
				}

				/// <summary>
				/// FrmRecordPhenotypeResults_Units class
				/// </summary>
				public static StringResourceItem FrmRecordPhenotypeResults_Units()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC041.FrmRecordPhenotypeResults_Units") );
				}
			}
			/// <summary>
			/// UC042 class
			/// </summary>
			public sealed class UC042
			{
				/// <summary>
				/// DlgGenerateFullFaceLabel class
				/// </summary>
				public static StringResourceItem DlgGenerateFullFaceLabel()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC042.DlgGenerateFullFaceLabel") );
				}

				/// <summary>
				/// DlgLabelVerificationOverride class
				/// </summary>
				public static StringResourceItem DlgLabelVerificationOverride()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC042.DlgLabelVerificationOverride") );
				}
			}
			/// <summary>
			/// UC043 class
			/// </summary>
			public sealed class UC043
			{
				/// <summary>
				/// DlgPrintBackupForms class
				/// </summary>
				public static StringResourceItem DlgPrintBackupForms()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC043.DlgPrintBackupForms") );
				}
			}
			/// <summary>
			/// UC044 class
			/// </summary>
			public sealed class UC044
			{
				/// <summary>
				/// DlgPrintBackupForms class
				/// </summary>
				public static StringResourceItem DlgPrintBackupForms()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC044.DlgPrintBackupForms") );
				}

				/// <summary>
				/// DlgPrintCautionTagChoosePatient class
				/// </summary>
				public static StringResourceItem DlgPrintCautionTagChoosePatient()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC044.DlgPrintCautionTagChoosePatient") );
				}

				/// <summary>
				/// FrmPrintCautionTagByPatient class
				/// </summary>
				public static StringResourceItem FrmPrintCautionTagByPatient()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC044.FrmPrintCautionTagByPatient") );
				}

				/// <summary>
				/// FrmPrintCautionTagByUnit class
				/// </summary>
				public static StringResourceItem FrmPrintCautionTagByUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC044.FrmPrintCautionTagByUnit") );
				}
			}
			/// <summary>
			/// UC045 class
			/// </summary>
			public sealed class UC045
			{
				/// <summary>
				/// DlgSelectOrder class
				/// </summary>
				public static StringResourceItem DlgSelectOrder()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC045.DlgSelectOrder") );
				}

				/// <summary>
				/// FrmOrderSpecimenReflex class
				/// </summary>
				public static StringResourceItem FrmOrderSpecimenReflex()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC045.FrmOrderSpecimenReflex") );
				}
			}
			/// <summary>
			/// UC046 class
			/// </summary>
			public sealed class UC046
			{
				/// <summary>
				/// FrmMedProfile class
				/// </summary>
				public static StringResourceItem FrmMedProfile()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC046.FrmMedProfile") );
				}
			}
			/// <summary>
			/// UC047 class
			/// </summary>
			public sealed class UC047
			{
				/// <summary>
				/// DlgConfirmRelease class
				/// </summary>
				public static StringResourceItem DlgConfirmRelease()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC047.DlgConfirmRelease") );
				}

				/// <summary>
				/// FrmReleaseUnits class
				/// </summary>
				public static StringResourceItem FrmReleaseUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC047.FrmReleaseUnits") );
				}
			}
			/// <summary>
			/// UC048 class
			/// </summary>
			public sealed class UC048
			{
				/// <summary>
				/// DlgTestingWorklistCriteria class
				/// </summary>
				public static StringResourceItem DlgTestingWorklistCriteria()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC048.DlgTestingWorklistCriteria") );
				}

				/// <summary>
				/// FrmTestingWorklistReport class
				/// </summary>
				public static StringResourceItem FrmTestingWorklistReport()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC048.FrmTestingWorklistReport") );
				}

				/// <summary>
				/// FrmTestingWorklistReport_Patient class
				/// </summary>
				public static StringResourceItem FrmTestingWorklistReport_Patient()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC048.FrmTestingWorklistReport_Patient") );
				}

				/// <summary>
				/// FrmTestingWorklistSpecimen class
				/// </summary>
				public static StringResourceItem FrmTestingWorklistSpecimen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC048.FrmTestingWorklistSpecimen") );
				}
			}
			/// <summary>
			/// UC049 class
			/// </summary>
			public sealed class UC049
			{
				/// <summary>
				/// DlgBloodAvailabilitySearch class
				/// </summary>
				public static StringResourceItem DlgBloodAvailabilitySearch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC049.DlgBloodAvailabilitySearch") );
				}

				/// <summary>
				/// DlgPatientAvailabilityType class
				/// </summary>
				public static StringResourceItem DlgPatientAvailabilityType()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC049.DlgPatientAvailabilityType") );
				}

				/// <summary>
				/// DlgReportBloodAvailability class
				/// </summary>
				public static StringResourceItem DlgReportBloodAvailability()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC049.DlgReportBloodAvailability") );
				}

				/// <summary>
				/// DlgReportBloodAvailability_Patient class
				/// </summary>
				public static StringResourceItem DlgReportBloodAvailability_Patient()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC049.DlgReportBloodAvailability_Patient") );
				}

				/// <summary>
				/// DlgReportBloodAvailability_Print class
				/// </summary>
				public static StringResourceItem DlgReportBloodAvailability_Print()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC049.DlgReportBloodAvailability_Print") );
				}
			}
			/// <summary>
			/// UC050 class
			/// </summary>
			public sealed class UC050
			{
				/// <summary>
				/// DlgSelectLabTest class
				/// </summary>
				public static StringResourceItem DlgSelectLabTest()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC050.DlgSelectLabTest") );
				}

				/// <summary>
				/// FrmConfigureComponents class
				/// </summary>
				public static StringResourceItem FrmConfigureComponents()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC050.FrmConfigureComponents") );
				}
			}
			/// <summary>
			/// UC051 class
			/// </summary>
			public sealed class UC051
			{
				/// <summary>
				/// DlgConfirmQCSave class
				/// </summary>
				public static StringResourceItem DlgConfirmQCSave()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC051.DlgConfirmQCSave") );
				}

				/// <summary>
				/// DlgEditMinimumReaction class
				/// </summary>
				public static StringResourceItem DlgEditMinimumReaction()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC051.DlgEditMinimumReaction") );
				}

				/// <summary>
				/// FrmConfigureReagent class
				/// </summary>
				public static StringResourceItem FrmConfigureReagent()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC051.FrmConfigureReagent") );
				}
			}
			/// <summary>
			/// UC052 class
			/// </summary>
			public sealed class UC052
			{
				/// <summary>
				/// DlgPatientTestingComments class
				/// </summary>
				public static StringResourceItem DlgPatientTestingComments()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC052.DlgPatientTestingComments") );
				}

				/// <summary>
				/// FrmRecordTesting class
				/// </summary>
				public static StringResourceItem FrmRecordTesting()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC052.FrmRecordTesting") );
				}
			}
			/// <summary>
			/// UC053 class
			/// </summary>
			public sealed class UC053
			{
				/// <summary>
				/// FrmRecordTesting class
				/// </summary>
				public static StringResourceItem FrmRecordTesting()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC053.FrmRecordTesting") );
				}
			}
			/// <summary>
			/// UC054 class
			/// </summary>
			public sealed class UC054
			{
				/// <summary>
				/// FrmRecordTesting class
				/// </summary>
				public static StringResourceItem FrmRecordTesting()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC054.FrmRecordTesting") );
				}
			}
			/// <summary>
			/// UC055 class
			/// </summary>
			public sealed class UC055
			{
				/// <summary>
				/// DlgMaintainDivision class
				/// </summary>
				public static StringResourceItem DlgMaintainDivision()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC055.DlgMaintainDivision") );
				}
			}
			/// <summary>
			/// UC056 class
			/// </summary>
			public sealed class UC056
			{
				/// <summary>
				/// DlgPatientTestingComments class
				/// </summary>
				public static StringResourceItem DlgPatientTestingComments()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.DlgPatientTestingComments") );
				}

				/// <summary>
				/// DlgSelectTestingRack class
				/// </summary>
				public static StringResourceItem DlgSelectTestingRack()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.DlgSelectTestingRack") );
				}

				/// <summary>
				/// FrmRecordTesting class
				/// </summary>
				public static StringResourceItem FrmRecordTesting()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC056.FrmRecordTesting") );
				}
			}
			/// <summary>
			/// UC057 class
			/// </summary>
			public sealed class UC057
			{
				/// <summary>
				/// FrmRecordTesting class
				/// </summary>
				public static StringResourceItem FrmRecordTesting()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC057.FrmRecordTesting") );
				}
			}
			/// <summary>
			/// UC058 class
			/// </summary>
			public sealed class UC058
			{
				/// <summary>
				/// FrmMaintainReagentMinLevels class
				/// </summary>
				public static StringResourceItem FrmMaintainReagentMinLevels()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC058.FrmMaintainReagentMinLevels") );
				}
			}
			/// <summary>
			/// UC059 class
			/// </summary>
			public sealed class UC059
			{
				/// <summary>
				/// DlgReturnUnitsInfo class
				/// </summary>
				public static StringResourceItem DlgReturnUnitsInfo()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC059.DlgReturnUnitsInfo") );
				}

				/// <summary>
				/// FrmReturnIssuedUnits class
				/// </summary>
				public static StringResourceItem FrmReturnIssuedUnits()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC059.FrmReturnIssuedUnits") );
				}

				/// <summary>
				/// FrmReturnIssuedUnits_Return class
				/// </summary>
				public static StringResourceItem FrmReturnIssuedUnits_Return()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC059.FrmReturnIssuedUnits_Return") );
				}
			}
			/// <summary>
			/// UC061 class
			/// </summary>
			public sealed class UC061
			{
				/// <summary>
				/// DlgCancelOrder class
				/// </summary>
				public static StringResourceItem DlgCancelOrder()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC061.DlgCancelOrder") );
				}

				/// <summary>
				/// FrmPendingOrderSearch class
				/// </summary>
				public static StringResourceItem FrmPendingOrderSearch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC061.FrmPendingOrderSearch") );
				}
			}
			/// <summary>
			/// UC065 class
			/// </summary>
			public sealed class UC065
			{
				/// <summary>
				/// DlgRecentOrders class
				/// </summary>
				public static StringResourceItem DlgRecentOrders()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC065.DlgRecentOrders") );
				}

				/// <summary>
				/// DlgRecentTransfusionsIssues class
				/// </summary>
				public static StringResourceItem DlgRecentTransfusionsIssues()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC065.DlgRecentTransfusionsIssues") );
				}
			}
			/// <summary>
			/// UC068 class
			/// </summary>
			public sealed class UC068
			{
				/// <summary>
				/// FrmMergePatients class
				/// </summary>
				public static StringResourceItem FrmMergePatients()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC068.FrmMergePatients") );
				}

				/// <summary>
				/// FrmViewDeceasedPatients class
				/// </summary>
				public static StringResourceItem FrmViewDeceasedPatients()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC068.FrmViewDeceasedPatients") );
				}

				/// <summary>
				/// FrmViewUpdatedPatients class
				/// </summary>
				public static StringResourceItem FrmViewUpdatedPatients()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC068.FrmViewUpdatedPatients") );
				}
			}
			/// <summary>
			/// UC069 class
			/// </summary>
			public sealed class UC069
			{
				/// <summary>
				/// FrmAboIncompatibleTransfusion class
				/// </summary>
				public static StringResourceItem FrmAboIncompatibleTransfusion()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC069.FrmAboIncompatibleTransfusion") );
				}

				/// <summary>
				/// FrmEnterPostTransfusionInfo class
				/// </summary>
				public static StringResourceItem FrmEnterPostTransfusionInfo()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC069.FrmEnterPostTransfusionInfo") );
				}

				/// <summary>
				/// FrmEnterPostTransfusionInfo_Info class
				/// </summary>
				public static StringResourceItem FrmEnterPostTransfusionInfo_Info()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC069.FrmEnterPostTransfusionInfo_Info") );
				}

				/// <summary>
				/// FrmEnterPostTransfusionInfo_Patient class
				/// </summary>
				public static StringResourceItem FrmEnterPostTransfusionInfo_Patient()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC069.FrmEnterPostTransfusionInfo_Patient") );
				}

				/// <summary>
				/// FrmEnterPostTransfusionInfo_Units class
				/// </summary>
				public static StringResourceItem FrmEnterPostTransfusionInfo_Units()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC069.FrmEnterPostTransfusionInfo_Units") );
				}
			}
			/// <summary>
			/// UC070 class
			/// </summary>
			public sealed class UC070
			{
				/// <summary>
				/// FrmEditUnitProcessing class
				/// </summary>
				public static StringResourceItem FrmEditUnitProcessing()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC070.FrmEditUnitProcessing") );
				}

				/// <summary>
				/// FrmEditUnitProcessing_Inactivate class
				/// </summary>
				public static StringResourceItem FrmEditUnitProcessing_Inactivate()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC070.FrmEditUnitProcessing_Inactivate") );
				}

				/// <summary>
				/// FrmEditUnitProcessing_Invalidate class
				/// </summary>
				public static StringResourceItem FrmEditUnitProcessing_Invalidate()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC070.FrmEditUnitProcessing_Invalidate") );
				}

				/// <summary>
				/// FrmEditUnitProcessing_UnitInfo class
				/// </summary>
				public static StringResourceItem FrmEditUnitProcessing_UnitInfo()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC070.FrmEditUnitProcessing_UnitInfo") );
				}
			}
			/// <summary>
			/// UC071 class
			/// </summary>
			public sealed class UC071
			{
				/// <summary>
				/// FrmFreeDirectedUnit class
				/// </summary>
				public static StringResourceItem FrmFreeDirectedUnit()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC071.FrmFreeDirectedUnit") );
				}
			}
			/// <summary>
			/// UC072 class
			/// </summary>
			public sealed class UC072
			{
				/// <summary>
				/// DlgCancelActiveOrderComment class
				/// </summary>
				public static StringResourceItem DlgCancelActiveOrderComment()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC072.DlgCancelActiveOrderComment") );
				}

				/// <summary>
				/// FrmPendingTaskList class
				/// </summary>
				public static StringResourceItem FrmPendingTaskList()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC072.FrmPendingTaskList") );
				}
			}
			/// <summary>
			/// UC073 class
			/// </summary>
			public sealed class UC073
			{
				/// <summary>
				/// DlgIssueBloodDetails class
				/// </summary>
				public static StringResourceItem DlgIssueBloodDetails()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.DlgIssueBloodDetails") );
				}

				/// <summary>
				/// DlgIssueOverride class
				/// </summary>
				public static StringResourceItem DlgIssueOverride()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.DlgIssueOverride") );
				}

				/// <summary>
				/// FrmIssueBloodComponents class
				/// </summary>
				public static StringResourceItem FrmIssueBloodComponents()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.FrmIssueBloodComponents") );
				}

				/// <summary>
				/// FrmIssueBloodComponents_ER class
				/// </summary>
				public static StringResourceItem FrmIssueBloodComponents_ER()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC073.FrmIssueBloodComponents_ER") );
				}
			}
			/// <summary>
			/// UC074 class
			/// </summary>
			public sealed class UC074
			{
				/// <summary>
				/// DlgTransfusionReportCriteria class
				/// </summary>
				public static StringResourceItem DlgTransfusionReportCriteria()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC074.DlgTransfusionReportCriteria") );
				}

				/// <summary>
				/// FrmTransfusionReport class
				/// </summary>
				public static StringResourceItem FrmTransfusionReport()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC074.FrmTransfusionReport") );
				}
			}
			/// <summary>
			/// UC075 class
			/// </summary>
			public sealed class UC075
			{
				/// <summary>
				/// DlgCostAccountingReportCriteria class
				/// </summary>
				public static StringResourceItem DlgCostAccountingReportCriteria()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC075.DlgCostAccountingReportCriteria") );
				}

				/// <summary>
				/// FrmCostAccountingReport class
				/// </summary>
				public static StringResourceItem FrmCostAccountingReport()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC075.FrmCostAccountingReport") );
				}
			}
			/// <summary>
			/// UC076 class
			/// </summary>
			public sealed class UC076
			{
				/// <summary>
				/// DlgIssuedReturnedReportCriteria class
				/// </summary>
				public static StringResourceItem DlgIssuedReturnedReportCriteria()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC076.DlgIssuedReturnedReportCriteria") );
				}

				/// <summary>
				/// FrmIssuedReturnedReport class
				/// </summary>
				public static StringResourceItem FrmIssuedReturnedReport()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC076.FrmIssuedReturnedReport") );
				}
			}
			/// <summary>
			/// UC077 class
			/// </summary>
			public sealed class UC077
			{
				/// <summary>
				/// DlgAuditTrailCriteria class
				/// </summary>
				public static StringResourceItem DlgAuditTrailCriteria()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC077.DlgAuditTrailCriteria") );
				}

				/// <summary>
				/// FrmAuditTrailReport class
				/// </summary>
				public static StringResourceItem FrmAuditTrailReport()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC077.FrmAuditTrailReport") );
				}
			}
			/// <summary>
			/// UC078 class
			/// </summary>
			public sealed class UC078
			{
				/// <summary>
				/// DlgFinalizeTrwReport class
				/// </summary>
				public static StringResourceItem DlgFinalizeTrwReport()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC078.DlgFinalizeTrwReport") );
				}

				/// <summary>
				/// DlgSelectCompletedTrw class
				/// </summary>
				public static StringResourceItem DlgSelectCompletedTrw()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC078.DlgSelectCompletedTrw") );
				}

				/// <summary>
				/// FrmGenerateTrwReport class
				/// </summary>
				public static StringResourceItem FrmGenerateTrwReport()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC078.FrmGenerateTrwReport") );
				}
			}
			/// <summary>
			/// UC079 class
			/// </summary>
			public sealed class UC079
			{
				/// <summary>
				/// DlgDivisionWorkloadReportCriteria class
				/// </summary>
				public static StringResourceItem DlgDivisionWorkloadReportCriteria()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC079.DlgDivisionWorkloadReportCriteria") );
				}

				/// <summary>
				/// FrmDivisionWorkloadReport class
				/// </summary>
				public static StringResourceItem FrmDivisionWorkloadReport()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC079.FrmDivisionWorkloadReport") );
				}
			}
			/// <summary>
			/// UC081 class
			/// </summary>
			public sealed class UC081
			{
				/// <summary>
				/// DlgSupplyInventoryCriteria class
				/// </summary>
				public static StringResourceItem DlgSupplyInventoryCriteria()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC081.DlgSupplyInventoryCriteria") );
				}

				/// <summary>
				/// FrmLogInSupplies class
				/// </summary>
				public static StringResourceItem FrmLogInSupplies()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC081.FrmLogInSupplies") );
				}

				/// <summary>
				/// FrmRecordSupplyUsage class
				/// </summary>
				public static StringResourceItem FrmRecordSupplyUsage()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC081.FrmRecordSupplyUsage") );
				}

				/// <summary>
				/// FrmSupplyInventory class
				/// </summary>
				public static StringResourceItem FrmSupplyInventory()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC081.FrmSupplyInventory") );
				}
			}
			/// <summary>
			/// UC082 class
			/// </summary>
			public sealed class UC082
			{
				/// <summary>
				/// DlgExceptionReportCriteria class
				/// </summary>
				public static StringResourceItem DlgExceptionReportCriteria()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC082.DlgExceptionReportCriteria") );
				}

				/// <summary>
				/// FrmExceptionReport class
				/// </summary>
				public static StringResourceItem FrmExceptionReport()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC082.FrmExceptionReport") );
				}
			}
			/// <summary>
			/// UC085 class
			/// </summary>
			public sealed class UC085
			{
				/// <summary>
				/// DlgUnitDataReportCriteria class
				/// </summary>
				public static StringResourceItem DlgUnitDataReportCriteria()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC085.DlgUnitDataReportCriteria") );
				}

				/// <summary>
				/// FrmUnitDataReport class
				/// </summary>
				public static StringResourceItem FrmUnitDataReport()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC085.FrmUnitDataReport") );
				}
			}
			/// <summary>
			/// UC086 class
			/// </summary>
			public sealed class UC086
			{
				/// <summary>
				/// DlgOrderReportCriteria class
				/// </summary>
				public static StringResourceItem DlgOrderReportCriteria()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC086.DlgOrderReportCriteria") );
				}

				/// <summary>
				/// DlgSelectPatientOrder class
				/// </summary>
				public static StringResourceItem DlgSelectPatientOrder()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC086.DlgSelectPatientOrder") );
				}

				/// <summary>
				/// FrmOrderHistoryReport class
				/// </summary>
				public static StringResourceItem FrmOrderHistoryReport()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC086.FrmOrderHistoryReport") );
				}

				/// <summary>
				/// FrmOrderHistoryReport_Single class
				/// </summary>
				public static StringResourceItem FrmOrderHistoryReport_Single()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC086.FrmOrderHistoryReport_Single") );
				}
			}
			/// <summary>
			/// UC088 class
			/// </summary>
			public sealed class UC088
			{
				/// <summary>
				/// FrmPendingOrderSearch class
				/// </summary>
				public static StringResourceItem FrmPendingOrderSearch()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC088.FrmPendingOrderSearch") );
				}
			}
			/// <summary>
			/// UC089 class
			/// </summary>
			public sealed class UC089
			{
				/// <summary>
				/// DlgTransfusionRequirementsReportCriteria class
				/// </summary>
				public static StringResourceItem DlgTransfusionRequirementsReportCriteria()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC089.DlgTransfusionRequirementsReportCriteria") );
				}

				/// <summary>
				/// FrmTransfusionRequirementsReport class
				/// </summary>
				public static StringResourceItem FrmTransfusionRequirementsReport()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC089.FrmTransfusionRequirementsReport") );
				}
			}
			/// <summary>
			/// UC090 class
			/// </summary>
			public sealed class UC090
			{
				/// <summary>
				/// DlgTransfusionComplicationDetails class
				/// </summary>
				public static StringResourceItem DlgTransfusionComplicationDetails()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC090.DlgTransfusionComplicationDetails") );
				}

				/// <summary>
				/// FrmTransfusionComplicationsReport class
				/// </summary>
				public static StringResourceItem FrmTransfusionComplicationsReport()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC090.FrmTransfusionComplicationsReport") );
				}
			}
			/// <summary>
			/// UC091 class
			/// </summary>
			public sealed class UC091
			{
				/// <summary>
				/// DlgTransfusionEffectivenessReportCriteria class
				/// </summary>
				public static StringResourceItem DlgTransfusionEffectivenessReportCriteria()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC091.DlgTransfusionEffectivenessReportCriteria") );
				}

				/// <summary>
				/// FrmTransfusionEffectivenessReport class
				/// </summary>
				public static StringResourceItem FrmTransfusionEffectivenessReport()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC091.FrmTransfusionEffectivenessReport") );
				}
			}
			/// <summary>
			/// UC092 class
			/// </summary>
			public sealed class UC092
			{
				/// <summary>
				/// FrmPendingTaskList class
				/// </summary>
				public static StringResourceItem FrmPendingTaskList()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC092.FrmPendingTaskList") );
				}
			}
			/// <summary>
			/// UC094 class
			/// </summary>
			public sealed class UC094
			{
				/// <summary>
				/// DlgInvalidatePatientTestConfirm class
				/// </summary>
				public static StringResourceItem DlgInvalidatePatientTestConfirm()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC094.DlgInvalidatePatientTestConfirm") );
				}

				/// <summary>
				/// DlgInvalidateSpecimen class
				/// </summary>
				public static StringResourceItem DlgInvalidateSpecimen()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC094.DlgInvalidateSpecimen") );
				}

				/// <summary>
				/// FrmInvalidatePatientTestResults class
				/// </summary>
				public static StringResourceItem FrmInvalidatePatientTestResults()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC094.FrmInvalidatePatientTestResults") );
				}
			}
			/// <summary>
			/// UC095 class
			/// </summary>
			public sealed class UC095
			{
				/// <summary>
				/// DlgMaintainDivision class
				/// </summary>
				public static StringResourceItem DlgMaintainDivision()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC095.DlgMaintainDivision") );
				}

				/// <summary>
				/// DlgMaintainDivision_Login class
				/// </summary>
				public static StringResourceItem DlgMaintainDivision_Login()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC095.DlgMaintainDivision_Login") );
				}
			}
			/// <summary>
			/// UC096 class
			/// </summary>
			public sealed class UC096
			{
				/// <summary>
				/// DlgInappropriateRequestReportCriteria class
				/// </summary>
				public static StringResourceItem DlgInappropriateRequestReportCriteria()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC096.DlgInappropriateRequestReportCriteria") );
				}

				/// <summary>
				/// FrmInappropriateRequestReport class
				/// </summary>
				public static StringResourceItem FrmInappropriateRequestReport()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC096.FrmInappropriateRequestReport") );
				}
			}
			/// <summary>
			/// UC098 class
			/// </summary>
			public sealed class UC098
			{
				/// <summary>
				/// DlgPatientAntigenTypingSpecificity class
				/// </summary>
				public static StringResourceItem DlgPatientAntigenTypingSpecificity()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC098.DlgPatientAntigenTypingSpecificity") );
				}

				/// <summary>
				/// DlgPatientTestingComments class
				/// </summary>
				public static StringResourceItem DlgPatientTestingComments()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC098.DlgPatientTestingComments") );
				}

				/// <summary>
				/// FrmRecordTesting class
				/// </summary>
				public static StringResourceItem FrmRecordTesting()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC098.FrmRecordTesting") );
				}
			}
			/// <summary>
			/// UC100 class
			/// </summary>
			public sealed class UC100
			{
				/// <summary>
				/// FrmJustifyAboRHChange class
				/// </summary>
				public static StringResourceItem FrmJustifyAboRHChange()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC100.FrmJustifyAboRHChange") );
				}
			}
			/// <summary>
			/// UC101 class
			/// </summary>
			public sealed class UC101
			{
				/// <summary>
				/// DlgPatientRecordReportCriteria class
				/// </summary>
				public static StringResourceItem DlgPatientRecordReportCriteria()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC101.DlgPatientRecordReportCriteria") );
				}

				/// <summary>
				/// FrmPatientRecordReport class
				/// </summary>
				public static StringResourceItem FrmPatientRecordReport()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC101.FrmPatientRecordReport") );
				}
			}
			/// <summary>
			/// UC102 class
			/// </summary>
			public sealed class UC102
			{
				/// <summary>
				/// DlgVistAChangeVerifyCode class
				/// </summary>
				public static StringResourceItem DlgVistAChangeVerifyCode()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.DlgVistAChangeVerifyCode") );
				}

				/// <summary>
				/// DlgVistASignOn class
				/// </summary>
				public static StringResourceItem DlgVistASignOn()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC102.DlgVistASignOn") );
				}
			}
			/// <summary>
			/// UC103 class
			/// </summary>
			public sealed class UC103
			{
				/// <summary>
				/// DlgRestoreVistALinkConnection class
				/// </summary>
				public static StringResourceItem DlgRestoreVistALinkConnection()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC103.DlgRestoreVistALinkConnection") );
				}
			}
			/// <summary>
			/// UC104 class
			/// </summary>
			public sealed class UC104
			{
				/// <summary>
				/// DlgCTRatioReportCriteria class
				/// </summary>
				public static StringResourceItem DlgCTRatioReportCriteria()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC104.DlgCTRatioReportCriteria") );
				}

				/// <summary>
				/// FrmCTRatioReport class
				/// </summary>
				public static StringResourceItem FrmCTRatioReport()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC104.FrmCTRatioReport") );
				}
			}
			/// <summary>
			/// UC105 class
			/// </summary>
			public sealed class UC105
			{
				/// <summary>
				/// DlgProlongedTransfusionReportCriteria class
				/// </summary>
				public static StringResourceItem DlgProlongedTransfusionReportCriteria()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC105.DlgProlongedTransfusionReportCriteria") );
				}

				/// <summary>
				/// FrmProlongedTransfusionReport class
				/// </summary>
				public static StringResourceItem FrmProlongedTransfusionReport()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC105.FrmProlongedTransfusionReport") );
				}
			}
			/// <summary>
			/// UC106 class
			/// </summary>
			public sealed class UC106
			{
				/// <summary>
				/// DlgTransfusionReactionCountReportCriteria class
				/// </summary>
				public static StringResourceItem DlgTransfusionReactionCountReportCriteria()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC106.DlgTransfusionReactionCountReportCriteria") );
				}

				/// <summary>
				/// FrmTransfusionReactionCountReport class
				/// </summary>
				public static StringResourceItem FrmTransfusionReactionCountReport()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC106.FrmTransfusionReactionCountReport") );
				}
			}
			/// <summary>
			/// UC107 class
			/// </summary>
			public sealed class UC107
			{
				/// <summary>
				/// DlgAdministrativeDataReportCriteria class
				/// </summary>
				public static StringResourceItem DlgAdministrativeDataReportCriteria()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC107.DlgAdministrativeDataReportCriteria") );
				}

				/// <summary>
				/// FrmAdministrativeDataReport class
				/// </summary>
				public static StringResourceItem FrmAdministrativeDataReport()
				{
					return  GetStringResourceItem(_classResType, _resourceManager.GetString("UC107.FrmAdministrativeDataReport") );
				}
			}
		}
	}
}
